/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.peer.ContainerPeer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.SunGraphicsCallback;
import sun.java2d.pipe.Region;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

abstract class LWContainerPeer<T extends Container, D extends JComponent>
extends LWComponentPeer<T, D>
implements ContainerPeer {
    private List<LWComponentPeer> childPeers = new LinkedList<LWComponentPeer>();

    LWContainerPeer(T t, PlatformComponent platformComponent) {
        super(t, platformComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildPeer(LWComponentPeer lWComponentPeer) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            this.addChildPeer(lWComponentPeer, this.childPeers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildPeer(LWComponentPeer lWComponentPeer, int n) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            this.childPeers.add(n, lWComponentPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildPeer(LWComponentPeer lWComponentPeer) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            this.childPeers.remove(lWComponentPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChildPeerZOrder(LWComponentPeer lWComponentPeer, LWComponentPeer lWComponentPeer2) {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            int n;
            this.childPeers.remove(lWComponentPeer);
            int n2 = n = lWComponentPeer2 != null ? this.childPeers.indexOf(lWComponentPeer2) : this.childPeers.size();
            if (n >= 0) {
                this.childPeers.add(n, lWComponentPeer);
            }
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void beginValidate() {
    }

    @Override
    public void endValidate() {
    }

    @Override
    public void beginLayout() {
        this.setLayouting(true);
    }

    @Override
    public void endLayout() {
        this.setLayouting(false);
        this.postPaintEvent(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LWComponentPeer> getChildren() {
        Object object = LWContainerPeer.getPeerTreeLock();
        synchronized (object) {
            Object object2 = ((LinkedList)this.childPeers).clone();
            return (List)object2;
        }
    }

    @Override
    public final Region getVisibleRegion() {
        return this.cutChildren(super.getVisibleRegion(), null);
    }

    protected final Region cutChildren(Region region, LWComponentPeer lWComponentPeer) {
        boolean bl = lWComponentPeer == null;
        for (LWComponentPeer lWComponentPeer2 : this.getChildren()) {
            if (!bl && lWComponentPeer2 == lWComponentPeer) {
                bl = true;
                continue;
            }
            if (!bl || !lWComponentPeer2.isVisible()) continue;
            Rectangle rectangle = lWComponentPeer2.getBounds();
            Region region2 = lWComponentPeer2.getRegion();
            Region region3 = region2.getTranslatedRegion(rectangle.x, rectangle.y);
            region = region.getDifference(region3.getIntersection(this.getContentSize()));
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LWComponentPeer findPeerAt(int n, int n2) {
        LWComponentPeer lWComponentPeer = super.findPeerAt(n, n2);
        Rectangle rectangle = this.getBounds();
        if (lWComponentPeer != null && this.getContentSize().contains(n -= rectangle.x, n2 -= rectangle.y)) {
            Object object = LWContainerPeer.getPeerTreeLock();
            synchronized (object) {
                for (int i = this.childPeers.size() - 1; i >= 0; --i) {
                    LWComponentPeer lWComponentPeer2 = this.childPeers.get(i).findPeerAt(n, n2);
                    if (lWComponentPeer2 == null) continue;
                    lWComponentPeer = lWComponentPeer2;
                    break;
                }
            }
        }
        return lWComponentPeer;
    }

    @Override
    public final void repaintPeer(Rectangle rectangle) {
        Rectangle rectangle2 = this.getSize().intersection(rectangle);
        if (!this.isShowing() || rectangle2.isEmpty()) {
            return;
        }
        super.repaintPeer(rectangle2);
        this.repaintChildren(rectangle2);
    }

    private void repaintChildren(Rectangle rectangle) {
        Rectangle rectangle2 = this.getContentSize();
        for (LWComponentPeer lWComponentPeer : this.getChildren()) {
            Rectangle rectangle3 = lWComponentPeer.getBounds();
            Rectangle rectangle4 = rectangle.intersection(rectangle3);
            rectangle4 = rectangle4.intersection(rectangle2);
            rectangle4.translate(-rectangle3.x, -rectangle3.y);
            lWComponentPeer.repaintPeer(rectangle4);
        }
    }

    protected Rectangle getContentSize() {
        return this.getSize();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (LWComponentPeer lWComponentPeer : this.getChildren()) {
            lWComponentPeer.setEnabled(bl && ((Component)lWComponentPeer.getTarget()).isEnabled());
        }
    }

    @Override
    public void setBackground(Color color) {
        for (LWComponentPeer lWComponentPeer : this.getChildren()) {
            if (((Component)lWComponentPeer.getTarget()).isBackgroundSet()) continue;
            lWComponentPeer.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        for (LWComponentPeer lWComponentPeer : this.getChildren()) {
            if (((Component)lWComponentPeer.getTarget()).isForegroundSet()) continue;
            lWComponentPeer.setForeground(color);
        }
        super.setForeground(color);
    }

    @Override
    public void setFont(Font font) {
        for (LWComponentPeer lWComponentPeer : this.getChildren()) {
            if (((Component)lWComponentPeer.getTarget()).isFontSet()) continue;
            lWComponentPeer.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        SunGraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.getTarget()).getComponents(), graphics, 3);
    }

    @Override
    public final void print(Graphics graphics) {
        super.print(graphics);
        SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.getTarget()).getComponents(), graphics, 3);
    }
}

