/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HiddenTagView;

class CommentView
extends HiddenTagView {
    static final Border CBorder = new CommentBorder();
    static final int commentPadding = 3;
    static final int commentPaddingD = 9;

    CommentView(Element element) {
        super(element);
    }

    @Override
    protected Component createComponent() {
        Font font;
        Container container = this.getContainer();
        if (container != null && !((JTextComponent)container).isEditable()) {
            return null;
        }
        JTextArea jTextArea = new JTextArea(this.getRepresentedText());
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            font = ((StyledDocument)document).getFont(this.getAttributes());
            jTextArea.setFont(font);
        } else {
            font = jTextArea.getFont();
        }
        this.updateYAlign(font);
        jTextArea.setBorder(CBorder);
        jTextArea.getDocument().addDocumentListener(this);
        jTextArea.setFocusable(this.isVisible());
        return jTextArea;
    }

    @Override
    void resetBorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void _updateModelFromText() {
        JTextComponent jTextComponent = this.getTextComponent();
        Document document = this.getDocument();
        if (jTextComponent != null && document != null) {
            String string = jTextComponent.getText();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            this.isSettingAttributes = true;
            try {
                simpleAttributeSet.addAttribute(HTML.Attribute.COMMENT, string);
                ((StyledDocument)document).setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), simpleAttributeSet, false);
            }
            finally {
                this.isSettingAttributes = false;
            }
        }
    }

    @Override
    JTextComponent getTextComponent() {
        return (JTextComponent)this.getComponent();
    }

    @Override
    String getRepresentedText() {
        Object object;
        AttributeSet attributeSet = this.getElement().getAttributes();
        if (attributeSet != null && (object = attributeSet.getAttribute(HTML.Attribute.COMMENT)) instanceof String) {
            return (String)object;
        }
        return "";
    }

    static class CommentBorder
    extends LineBorder {
        CommentBorder() {
            super(Color.black, 1);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n + 3, n2, n3 - 9, n4);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = super.getBorderInsets(component, insets);
            insets2.left += 3;
            insets2.right += 3;
            return insets2;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

