/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AccessibleBundle {
    private static Hashtable table = new Hashtable();
    private final String defaultResourceBundleName = "com.sun.accessibility.internal.resources.accessibility";
    protected String key = null;

    protected String toDisplayString(String string, Locale locale) {
        Hashtable hashtable;
        this.loadResourceBundle(string, locale);
        Object v = table.get(locale);
        if (v != null && v instanceof Hashtable && (v = (hashtable = (Hashtable)v).get(this.key)) != null && v instanceof String) {
            return (String)v;
        }
        return this.key;
    }

    public String toDisplayString(Locale locale) {
        return this.toDisplayString("com.sun.accessibility.internal.resources.accessibility", locale);
    }

    public String toDisplayString() {
        return this.toDisplayString(Locale.getDefault());
    }

    public String toString() {
        return this.toDisplayString();
    }

    private void loadResourceBundle(String string, Locale locale) {
        if (!table.contains(locale)) {
            try {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    hashtable.put(string2, resourceBundle.getObject(string2));
                }
                table.put(locale, hashtable);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("loadResourceBundle: " + missingResourceException);
                return;
            }
        }
    }
}

