/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.ImageCache;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import sun.awt.image.SunWritableRaster;
import sun.java2d.SunGraphics2D;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;

abstract class AquaPainter<T extends JRSUIState> {
    final Rectangle boundsRect = new Rectangle();
    final JRSUIControl control;
    T state;

    static <T extends JRSUIState> AquaPainter<T> create(T t) {
        return new AquaSingleImagePainter<T>(t);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, int n, int n2, int n3, int n4, int n5, int n6) {
        return AquaPainter.create(t, n, n2, n3, n4, n5, n6, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return AquaPainter.create(t, n, n2, n3, n4, n5, n6, bl, true, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final boolean bl, final boolean bl2, final boolean bl3) {
        return AquaPainter.create(t, new JRSUIUtils.NineSliceMetricsProvider(){

            @Override
            public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState jRSUIState) {
                return new AquaImageFactory.NineSliceMetrics(n, n2, n3, n4, n5, n6, bl, bl2, bl3);
            }
        });
    }

    static <T extends JRSUIState> AquaPainter<T> create(T t, JRSUIUtils.NineSliceMetricsProvider nineSliceMetricsProvider) {
        return new AquaNineSlicingImagePainter<T>(t, nineSliceMetricsProvider);
    }

    abstract void paint(Graphics2D var1, T var2);

    AquaPainter(JRSUIControl jRSUIControl, T t) {
        this.control = jRSUIControl;
        this.state = t;
    }

    final JRSUIControl getControl() {
        this.state = ((JRSUIState)this.state).derive();
        this.control.set((JRSUIState)this.state);
        return this.control;
    }

    final void paint(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        this.boundsRect.setBounds(n, n2, n3, n4);
        Object t = ((JRSUIState)this.state).derive();
        Graphics2D graphics2D = this.getGraphics2D(graphics);
        if (graphics2D != null) {
            this.paint(graphics2D, t);
        }
        this.state = t;
    }

    private Graphics2D getGraphics2D(Graphics graphics) {
        try {
            return (SunGraphics2D)graphics;
        }
        catch (Exception exception) {
            if (graphics instanceof PeekGraphics) {
                graphics.fillRect(this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
            } else if (graphics instanceof ProxyGraphics2D) {
                ProxyGraphics2D proxyGraphics2D = (ProxyGraphics2D)graphics;
                Graphics2D graphics2D = proxyGraphics2D.getDelegate();
                if (graphics2D instanceof SunGraphics2D) {
                    return graphics2D;
                }
            } else if (graphics instanceof Graphics2D) {
                return (Graphics2D)graphics;
            }
            return null;
        }
    }

    private static class RecyclableJRSUISlicedImageControl
    extends AquaImageFactory.RecyclableSlicedImageControl {
        private final JRSUIControl control;
        private final JRSUIState state;

        RecyclableJRSUISlicedImageControl(JRSUIControl jRSUIControl, JRSUIState jRSUIState, AquaImageFactory.NineSliceMetrics nineSliceMetrics) {
            super(nineSliceMetrics);
            this.control = jRSUIControl;
            this.state = jRSUIState;
        }

        @Override
        protected Image createTemplateImage(int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(this.metrics.minW, this.metrics.minH, 3);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.control.set(this.state);
            this.control.paint(SunWritableRaster.stealData(dataBufferInt, 0), this.metrics.minW, this.metrics.minH, 0.0, 0.0, this.metrics.minW, this.metrics.minH);
            SunWritableRaster.markDirty(dataBufferInt);
            return bufferedImage;
        }
    }

    private static final class AquaSingleImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        AquaSingleImagePainter(T t) {
            super(new JRSUIControl(false), t);
        }

        @Override
        void paint(Graphics2D graphics2D, T t) {
            AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
        }

        static void paintFromSingleCachedImage(Graphics2D graphics2D, JRSUIControl jRSUIControl, JRSUIState jRSUIState, Rectangle rectangle) {
            int n;
            int n2;
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                return;
            }
            int n3 = 1;
            if (graphics2D instanceof SunGraphics2D) {
                n3 = ((SunGraphics2D)graphics2D).surfaceData.getDefaultScale();
            }
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            ImageCache imageCache = ImageCache.getInstance();
            BufferedImage bufferedImage = (BufferedImage)imageCache.getImage(graphicsConfiguration, n2 = rectangle.width * n3, n = rectangle.height * n3, n3, jRSUIState);
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(n2, n, 3);
                imageCache.setImage(bufferedImage, graphicsConfiguration, n2, n, n3, jRSUIState);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                jRSUIControl.set(jRSUIState);
                jRSUIControl.paint(SunWritableRaster.stealData(dataBufferInt, 0), n2, n, 0.0, 0.0, rectangle.width, rectangle.height);
                SunWritableRaster.markDirty(dataBufferInt);
            }
            graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        }
    }

    private static class AquaNineSlicingImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        private final HashMap<T, RecyclableJRSUISlicedImageControl> slicedControlImages;
        private final JRSUIUtils.NineSliceMetricsProvider metricsProvider;

        AquaNineSlicingImagePainter(T t) {
            this(t, null);
        }

        AquaNineSlicingImagePainter(T t, JRSUIUtils.NineSliceMetricsProvider nineSliceMetricsProvider) {
            super(new JRSUIControl(false), t);
            this.metricsProvider = nineSliceMetricsProvider;
            this.slicedControlImages = new HashMap();
        }

        @Override
        void paint(Graphics2D graphics2D, T t) {
            Object object;
            if (this.metricsProvider == null) {
                AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
                return;
            }
            RecyclableJRSUISlicedImageControl recyclableJRSUISlicedImageControl = this.slicedControlImages.get(t);
            if (recyclableJRSUISlicedImageControl == null) {
                object = this.metricsProvider.getNineSliceMetricsForState((JRSUIState)t);
                if (object == null) {
                    AquaSingleImagePainter.paintFromSingleCachedImage(graphics2D, this.control, t, this.boundsRect);
                    return;
                }
                recyclableJRSUISlicedImageControl = new RecyclableJRSUISlicedImageControl(this.control, (JRSUIState)t, (AquaImageFactory.NineSliceMetrics)object);
                this.slicedControlImages.put(t, recyclableJRSUISlicedImageControl);
            }
            object = (AquaImageFactory.SlicedImageControl)recyclableJRSUISlicedImageControl.get();
            ((AquaImageFactory.SlicedImageControl)object).paint(graphics2D, this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
        }
    }
}

