/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.DisplayChangedListener;
import sun.util.logging.PlatformLogger;

public class SunDisplayChanger {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map<DisplayChangedListener, Void> listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(PlatformLogger.Level.FINE) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Adding listener: " + displayChangedListener);
        }
        this.listeners.put(displayChangedListener, null);
    }

    public void remove(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(PlatformLogger.Level.FINE) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Removing listener: " + displayChangedListener);
        }
        this.listeners.remove(displayChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        HashSet<DisplayChangedListener> hashSet;
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("notifyListeners");
        }
        Map<DisplayChangedListener, Void> map = this.listeners;
        synchronized (map) {
            hashSet = new HashSet<DisplayChangedListener>(this.listeners.keySet());
        }
        for (DisplayChangedListener displayChangedListener : hashSet) {
            try {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("displayChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.displayChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPaletteChanged() {
        HashSet<DisplayChangedListener> hashSet;
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("notifyPaletteChanged");
        }
        Map<DisplayChangedListener, Void> map = this.listeners;
        synchronized (map) {
            hashSet = new HashSet<DisplayChangedListener>(this.listeners.keySet());
        }
        for (DisplayChangedListener displayChangedListener : hashSet) {
            try {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("paletteChanged for listener: " + displayChangedListener);
                }
                displayChangedListener.paletteChanged();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }
}

