/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.FileLockTable;

abstract class AsynchronousFileChannelImpl
extends AsynchronousFileChannel {
    protected final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    protected volatile boolean closed;
    protected final FileDescriptor fdObj;
    protected final boolean reading;
    protected final boolean writing;
    protected final ExecutorService executor;
    private volatile FileLockTable fileLockTable;

    protected AsynchronousFileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, ExecutorService executorService) {
        this.fdObj = fileDescriptor;
        this.reading = bl;
        this.writing = bl2;
        this.executor = executorService;
    }

    final ExecutorService executor() {
        return this.executor;
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    protected final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    protected final void end() {
        this.closeLock.readLock().unlock();
    }

    protected final void end(boolean bl) throws IOException {
        this.end();
        if (!bl && !this.isOpen()) {
            throw new AsynchronousCloseException();
        }
    }

    abstract <A> Future<FileLock> implLock(long var1, long var3, boolean var5, A var6, CompletionHandler<FileLock, ? super A> var7);

    @Override
    public final Future<FileLock> lock(long l, long l2, boolean bl) {
        return this.implLock(l, l2, bl, null, null);
    }

    @Override
    public final <A> void lock(long l, long l2, boolean bl, A a, CompletionHandler<FileLock, ? super A> completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implLock(l, l2, bl, a, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureFileLockTableInitialized() throws IOException {
        if (this.fileLockTable == null) {
            AsynchronousFileChannelImpl asynchronousFileChannelImpl = this;
            synchronized (asynchronousFileChannelImpl) {
                if (this.fileLockTable == null) {
                    this.fileLockTable = FileLockTable.newSharedFileLockTable(this, this.fdObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidateAllLocks() throws IOException {
        if (this.fileLockTable != null) {
            Iterator<FileLock> iterator = this.fileLockTable.removeAll().iterator();
            while (iterator.hasNext()) {
                FileLock fileLock;
                FileLock fileLock2 = fileLock = iterator.next();
                synchronized (fileLock2) {
                    if (fileLock.isValid()) {
                        FileLockImpl fileLockImpl = (FileLockImpl)fileLock;
                        this.implRelease(fileLockImpl);
                        fileLockImpl.invalidate();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FileLockImpl addToFileLockTable(long l, long l2, boolean bl) {
        FileLockImpl fileLockImpl;
        try {
            this.closeLock.readLock().lock();
            if (this.closed) {
                FileLockImpl fileLockImpl2 = null;
                return fileLockImpl2;
            }
            try {
                this.ensureFileLockTableInitialized();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            fileLockImpl = new FileLockImpl(this, l, l2, bl);
            this.fileLockTable.add(fileLockImpl);
        }
        finally {
            this.end();
        }
        return fileLockImpl;
    }

    protected final void removeFromFileLockTable(FileLockImpl fileLockImpl) {
        this.fileLockTable.remove(fileLockImpl);
    }

    protected abstract void implRelease(FileLockImpl var1) throws IOException;

    final void release(FileLockImpl fileLockImpl) throws IOException {
        try {
            this.begin();
            this.implRelease(fileLockImpl);
            this.removeFromFileLockTable(fileLockImpl);
        }
        finally {
            this.end();
        }
    }

    abstract <A> Future<Integer> implRead(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    @Override
    public final Future<Integer> read(ByteBuffer byteBuffer, long l) {
        return this.implRead(byteBuffer, l, null, null);
    }

    @Override
    public final <A> void read(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implRead(byteBuffer, l, a, completionHandler);
    }

    abstract <A> Future<Integer> implWrite(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    @Override
    public final Future<Integer> write(ByteBuffer byteBuffer, long l) {
        return this.implWrite(byteBuffer, l, null, null);
    }

    @Override
    public final <A> void write(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implWrite(byteBuffer, l, a, completionHandler);
    }
}

