/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class ArrayType<T>
extends OpenType<T> {
    static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType<?> elementType;
    private boolean primitiveArray;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private static final int PRIMITIVE_WRAPPER_NAME_INDEX = 0;
    private static final int PRIMITIVE_TYPE_NAME_INDEX = 1;
    private static final int PRIMITIVE_TYPE_KEY_INDEX = 2;
    private static final int PRIMITIVE_OPEN_TYPE_INDEX = 3;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class.getName(), Boolean.TYPE.getName(), "Z", SimpleType.BOOLEAN}, {Character.class.getName(), Character.TYPE.getName(), "C", SimpleType.CHARACTER}, {Byte.class.getName(), Byte.TYPE.getName(), "B", SimpleType.BYTE}, {Short.class.getName(), Short.TYPE.getName(), "S", SimpleType.SHORT}, {Integer.class.getName(), Integer.TYPE.getName(), "I", SimpleType.INTEGER}, {Long.class.getName(), Long.TYPE.getName(), "J", SimpleType.LONG}, {Float.class.getName(), Float.TYPE.getName(), "F", SimpleType.FLOAT}, {Double.class.getName(), Double.TYPE.getName(), "D", SimpleType.DOUBLE}};

    static boolean isPrimitiveContentType(String string) {
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (!objectArray[2].equals(string)) continue;
            return true;
        }
        return false;
    }

    static String getPrimitiveTypeKey(String string) {
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (!string.equals(objectArray[0])) continue;
            return (String)objectArray[2];
        }
        return null;
    }

    static String getPrimitiveTypeName(String string) {
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (!string.equals(objectArray[0])) continue;
            return (String)objectArray[1];
        }
        return null;
    }

    static SimpleType<?> getPrimitiveOpenType(String string) {
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (!string.equals(objectArray[1])) continue;
            return (SimpleType)objectArray[3];
        }
        return null;
    }

    public ArrayType(int n, OpenType<?> openType) throws OpenDataException {
        super(ArrayType.buildArrayClassName(n, openType), ArrayType.buildArrayClassName(n, openType), ArrayType.buildArrayDescription(n, openType));
        if (openType.isArray()) {
            ArrayType arrayType = (ArrayType)openType;
            this.dimension = arrayType.getDimension() + n;
            this.elementType = arrayType.getElementOpenType();
            this.primitiveArray = arrayType.isPrimitiveArray();
        } else {
            this.dimension = n;
            this.elementType = openType;
            this.primitiveArray = false;
        }
    }

    public ArrayType(SimpleType<?> simpleType, boolean bl) throws OpenDataException {
        super(ArrayType.buildArrayClassName(1, simpleType, bl), ArrayType.buildArrayClassName(1, simpleType, bl), ArrayType.buildArrayDescription(1, simpleType, bl), true);
        this.dimension = 1;
        this.elementType = simpleType;
        this.primitiveArray = bl;
    }

    ArrayType(String string, String string2, String string3, int n, OpenType<?> openType, boolean bl) {
        super(string, string2, string3, true);
        this.dimension = n;
        this.elementType = openType;
        this.primitiveArray = bl;
    }

    private static String buildArrayClassName(int n, OpenType<?> openType) throws OpenDataException {
        boolean bl = false;
        if (openType.isArray()) {
            bl = ((ArrayType)openType).isPrimitiveArray();
        }
        return ArrayType.buildArrayClassName(n, openType, bl);
    }

    private static String buildArrayClassName(int n, OpenType<?> openType, boolean bl) throws OpenDataException {
        if (n < 1) {
            throw new IllegalArgumentException("Value of argument dimension must be greater than 0");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = openType.getClassName();
        for (int i = 1; i <= n; ++i) {
            stringBuilder.append('[');
        }
        if (openType.isArray()) {
            stringBuilder.append(string);
        } else if (bl) {
            String string2 = ArrayType.getPrimitiveTypeKey(string);
            if (string2 == null) {
                throw new OpenDataException("Element type is not primitive: " + string);
            }
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("L");
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    private static String buildArrayDescription(int n, OpenType<?> openType) throws OpenDataException {
        boolean bl = false;
        if (openType.isArray()) {
            bl = ((ArrayType)openType).isPrimitiveArray();
        }
        return ArrayType.buildArrayDescription(n, openType, bl);
    }

    private static String buildArrayDescription(int n, OpenType<?> openType, boolean bl) throws OpenDataException {
        Serializable serializable;
        if (openType.isArray()) {
            serializable = (ArrayType)openType;
            n += ((ArrayType)serializable).getDimension();
            openType = ((ArrayType)serializable).getElementOpenType();
            bl = ((ArrayType)serializable).isPrimitiveArray();
        }
        serializable = new StringBuilder(n + "-dimension array of ");
        String string = openType.getClassName();
        if (bl) {
            String string2 = ArrayType.getPrimitiveTypeName(string);
            if (string2 == null) {
                throw new OpenDataException("Element is not a primitive type: " + string);
            }
            ((StringBuilder)serializable).append(string2);
        } else {
            ((StringBuilder)serializable).append(string);
        }
        return ((StringBuilder)serializable).toString();
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType<?> getElementOpenType() {
        return this.elementType;
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    @Override
    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.getClassName().equals(string)) {
            return true;
        }
        if (this.elementType.getClassName().equals(TabularData.class.getName()) || this.elementType.getClassName().equals(CompositeData.class.getName())) {
            int[] nArray;
            boolean bl = this.elementType.getClassName().equals(TabularData.class.getName());
            Class clazz2 = bl ? TabularData.class : CompositeData.class;
            Class<?> clazz3 = Array.newInstance(clazz2, nArray = new int[this.getDimension()]).getClass();
            if (!clazz3.isAssignableFrom(clazz)) {
                return false;
            }
            return this.checkElementsType((Object[])object, this.dimension);
        }
        return false;
    }

    private boolean checkElementsType(Object[] objectArray, int n) {
        if (n > 1) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.checkElementsType((Object[])objectArray[i], n - 1)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || this.getElementOpenType().isValue(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAssignableFrom(OpenType<?> openType) {
        if (!(openType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)openType;
        return arrayType.getDimension() == this.getDimension() && arrayType.isPrimitiveArray() == this.isPrimitiveArray() && arrayType.getElementOpenType().isAssignableFrom(this.getElementOpenType());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        if (this.dimension != arrayType.dimension) {
            return false;
        }
        if (!this.elementType.equals(arrayType.elementType)) {
            return false;
        }
        return this.primitiveArray == arrayType.primitiveArray;
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.dimension;
            n += this.elementType.hashCode();
            this.myHashCode = n += Boolean.valueOf(this.primitiveArray).hashCode();
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getTypeName() + ",dimension=" + this.dimension + ",elementType=" + this.elementType + ",primitiveArray=" + this.primitiveArray + ")";
        }
        return this.myToString;
    }

    public static <E> ArrayType<E[]> getArrayType(OpenType<E> openType) throws OpenDataException {
        return new ArrayType<E[]>(1, openType);
    }

    public static <T> ArrayType<T> getPrimitiveArrayType(Class<T> clazz) {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("arrayClass must be an array");
        }
        int n = 1;
        Class<?> clazz2 = clazz.getComponentType();
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        String string = clazz2.getName();
        if (!clazz2.isPrimitive()) {
            throw new IllegalArgumentException("component type of the array must be a primitive type");
        }
        SimpleType<?> simpleType = ArrayType.getPrimitiveOpenType(string);
        try {
            ArrayType<T> arrayType = new ArrayType<T>(simpleType, true);
            if (n > 1) {
                arrayType = new ArrayType<T>(n - 1, arrayType);
            }
            return arrayType;
        }
        catch (OpenDataException openDataException) {
            throw new IllegalArgumentException(openDataException);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.primitiveArray) {
            return this.convertFromWrapperToPrimitiveTypes();
        }
        return this;
    }

    private <T> ArrayType<T> convertFromWrapperToPrimitiveTypes() {
        String string = this.getClassName();
        String string2 = this.getTypeName();
        String string3 = this.getDescription();
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (string.indexOf((String)objectArray[0]) == -1) continue;
            string = string.replaceFirst("L" + objectArray[0] + ";", (String)objectArray[2]);
            string2 = string2.replaceFirst("L" + objectArray[0] + ";", (String)objectArray[2]);
            string3 = string3.replaceFirst((String)objectArray[0], (String)objectArray[1]);
            break;
        }
        return new ArrayType<T>(string, string2, string3, this.dimension, this.elementType, this.primitiveArray);
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this.primitiveArray) {
            return this.convertFromPrimitiveToWrapperTypes();
        }
        return this;
    }

    private <T> ArrayType<T> convertFromPrimitiveToWrapperTypes() {
        String string = this.getClassName();
        String string2 = this.getTypeName();
        String string3 = this.getDescription();
        for (Object[] objectArray : PRIMITIVE_ARRAY_TYPES) {
            if (string.indexOf((String)objectArray[2]) == -1) continue;
            string = string.replaceFirst((String)objectArray[2], "L" + objectArray[0] + ";");
            string2 = string2.replaceFirst((String)objectArray[2], "L" + objectArray[0] + ";");
            string3 = string3.replaceFirst((String)objectArray[1], (String)objectArray[0]);
            break;
        }
        return new ArrayType<T>(string, string2, string3, this.dimension, this.elementType, this.primitiveArray);
    }
}

