/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.AccessMode;
import java.nio.file.CopyMoveHelper;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.TempFileHelper;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import sun.nio.fs.DefaultFileTypeDetector;

public final class Files {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    private Files() {
    }

    private static FileSystemProvider provider(Path path) {
        return path.getFileSystem().provider();
    }

    public static InputStream newInputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return Files.provider(path).newInputStream(path, openOptionArray);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... openOptionArray) throws IOException {
        return Files.provider(path).newOutputStream(path, openOptionArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return Files.provider(path).newByteChannel(path, set, fileAttributeArray);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(openOptionArray.length);
        Collections.addAll(hashSet, openOptionArray);
        return Files.newByteChannel(path, hashSet, new FileAttribute[0]);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path) throws IOException {
        return Files.provider(path).newDirectoryStream(path, AcceptAllFilter.FILTER);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, String string) throws IOException {
        if (string.equals("*")) {
            return Files.newDirectoryStream(path);
        }
        FileSystem fileSystem = path.getFileSystem();
        final PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return pathMatcher.matches(path.getFileName());
            }
        };
        return fileSystem.provider().newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return Files.provider(path).newDirectoryStream(path, filter);
    }

    public static Path createFile(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        EnumSet<StandardOpenOption> enumSet = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Files.newByteChannel(path, enumSet, fileAttributeArray).close();
        return path;
    }

    public static Path createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        Files.provider(path).createDirectory(path, fileAttributeArray);
        return path;
    }

    public static Path createDirectories(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        try {
            Files.createAndCheckIsDirectory(path, fileAttributeArray);
            return path;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw fileAlreadyExistsException;
        }
        catch (IOException iOException) {
            Path path2;
            SecurityException securityException = null;
            try {
                path = path.toAbsolutePath();
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            for (path2 = path.getParent(); path2 != null; path2 = path2.getParent()) {
                try {
                    Files.provider(path2).checkAccess(path2, new AccessMode[0]);
                    break;
                }
                catch (NoSuchFileException noSuchFileException) {
                    continue;
                }
            }
            if (path2 == null) {
                if (securityException != null) {
                    throw securityException;
                }
                throw new IOException("Root directory does not exist");
            }
            Path path3 = path2;
            for (Path path4 : path2.relativize(path)) {
                path3 = path3.resolve(path4);
                Files.createAndCheckIsDirectory(path3, fileAttributeArray);
            }
            return path;
        }
    }

    private static void createAndCheckIsDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, fileAttributeArray);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) break block2;
                throw fileAlreadyExistsException;
            }
        }
    }

    public static Path createTempFile(Path path, String string, String string2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempFile(Objects.requireNonNull(path), string, string2, fileAttributeArray);
    }

    public static Path createTempFile(String string, String string2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempFile(null, string, string2, fileAttributeArray);
    }

    public static Path createTempDirectory(Path path, String string, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempDirectory(Objects.requireNonNull(path), string, fileAttributeArray);
    }

    public static Path createTempDirectory(String string, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return TempFileHelper.createTempDirectory(null, string, fileAttributeArray);
    }

    public static Path createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        Files.provider(path).createSymbolicLink(path, path2, fileAttributeArray);
        return path;
    }

    public static Path createLink(Path path, Path path2) throws IOException {
        Files.provider(path).createLink(path, path2);
        return path;
    }

    public static void delete(Path path) throws IOException {
        Files.provider(path).delete(path);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        return Files.provider(path).deleteIfExists(path);
    }

    public static Path copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        FileSystemProvider fileSystemProvider = Files.provider(path);
        if (Files.provider(path2) == fileSystemProvider) {
            fileSystemProvider.copy(path, path2, copyOptionArray);
        } else {
            CopyMoveHelper.copyToForeignTarget(path, path2, copyOptionArray);
        }
        return path2;
    }

    public static Path move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        FileSystemProvider fileSystemProvider = Files.provider(path);
        if (Files.provider(path2) == fileSystemProvider) {
            fileSystemProvider.move(path, path2, copyOptionArray);
        } else {
            CopyMoveHelper.moveToForeignTarget(path, path2, copyOptionArray);
        }
        return path2;
    }

    public static Path readSymbolicLink(Path path) throws IOException {
        return Files.provider(path).readSymbolicLink(path);
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return Files.provider(path).getFileStore(path);
    }

    public static boolean isSameFile(Path path, Path path2) throws IOException {
        return Files.provider(path).isSameFile(path, path2);
    }

    public static boolean isHidden(Path path) throws IOException {
        return Files.provider(path).isHidden(path);
    }

    public static String probeContentType(Path path) throws IOException {
        for (FileTypeDetector fileTypeDetector : FileTypeDetectors.installeDetectors) {
            String string = fileTypeDetector.probeContentType(path);
            if (string == null) continue;
            return string;
        }
        return FileTypeDetectors.defaultFileTypeDetector.probeContentType(path);
    }

    public static <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        return Files.provider(path).getFileAttributeView(path, clazz, linkOptionArray);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        return Files.provider(path).readAttributes(path, clazz, linkOptionArray);
    }

    public static Path setAttribute(Path path, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        Files.provider(path).setAttribute(path, string, object, linkOptionArray);
        return path;
    }

    public static Object getAttribute(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        if (string.indexOf(42) >= 0 || string.indexOf(44) >= 0) {
            throw new IllegalArgumentException(string);
        }
        Map<String, Object> map = Files.readAttributes(path, string, linkOptionArray);
        assert (map.size() == 1);
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : (n == string.length() ? "" : string.substring(n + 1));
        return map.get(string2);
    }

    public static Map<String, Object> readAttributes(Path path, String string, LinkOption ... linkOptionArray) throws IOException {
        return Files.provider(path).readAttributes(path, string, linkOptionArray);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... linkOptionArray) throws IOException {
        return Files.readAttributes(path, PosixFileAttributes.class, linkOptionArray).permissions();
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> set) throws IOException {
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        posixFileAttributeView.setPermissions(set);
        return path;
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... linkOptionArray) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, linkOptionArray);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        return fileOwnerAttributeView.getOwner();
    }

    public static Path setOwner(Path path, UserPrincipal userPrincipal) throws IOException {
        FileOwnerAttributeView fileOwnerAttributeView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        if (fileOwnerAttributeView == null) {
            throw new UnsupportedOperationException();
        }
        fileOwnerAttributeView.setOwner(userPrincipal);
        return path;
    }

    public static boolean isSymbolicLink(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).isSymbolicLink();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isDirectory(Path path, LinkOption ... linkOptionArray) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isRegularFile(Path path, LinkOption ... linkOptionArray) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).isRegularFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... linkOptionArray) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray).lastModifiedTime();
    }

    public static Path setLastModifiedTime(Path path, FileTime fileTime) throws IOException {
        Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(fileTime, null, null);
        return path;
    }

    public static long size(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).size();
    }

    private static boolean followLinks(LinkOption ... linkOptionArray) {
        boolean bl = true;
        for (LinkOption linkOption : linkOptionArray) {
            if (linkOption != LinkOption.NOFOLLOW_LINKS) {
                if (linkOption == null) {
                    throw new NullPointerException();
                }
                throw new AssertionError((Object)"Should not get here");
            }
            bl = false;
        }
        return bl;
    }

    public static boolean exists(Path path, LinkOption ... linkOptionArray) {
        try {
            if (Files.followLinks(linkOptionArray)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean notExists(Path path, LinkOption ... linkOptionArray) {
        try {
            if (Files.followLinks(linkOptionArray)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return false;
        }
        catch (NoSuchFileException noSuchFileException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean isAccessible(Path path, AccessMode ... accessModeArray) {
        try {
            Files.provider(path).checkAccess(path, accessModeArray);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isReadable(Path path) {
        return Files.isAccessible(path, AccessMode.READ);
    }

    public static boolean isWritable(Path path) {
        return Files.isAccessible(path, AccessMode.WRITE);
    }

    public static boolean isExecutable(Path path) {
        return Files.isAccessible(path, AccessMode.EXECUTE);
    }

    public static Path walkFileTree(Path path, Set<FileVisitOption> set, int n, FileVisitor<? super Path> fileVisitor) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        new FileTreeWalker(set, fileVisitor, n).walk(path);
        return path;
    }

    public static Path walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) throws IOException {
        return Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, fileVisitor);
    }

    public static BufferedReader newBufferedReader(Path path, Charset charset) throws IOException {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), charsetDecoder);
        return new BufferedReader(inputStreamReader);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset charset, OpenOption ... openOptionArray) throws IOException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(path, openOptionArray), charsetEncoder);
        return new BufferedWriter(outputStreamWriter);
    }

    private static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream inputStream, Path path, CopyOption ... copyOptionArray) throws IOException {
        OutputStream outputStream;
        Objects.requireNonNull(inputStream);
        boolean bl = false;
        for (CopyOption copyOption : copyOptionArray) {
            if (copyOption != StandardCopyOption.REPLACE_EXISTING) {
                if (copyOption == null) {
                    throw new NullPointerException("options contains 'null'");
                }
                throw new UnsupportedOperationException(copyOption + " not supported");
            }
            bl = true;
        }
        Object var4_5 = null;
        if (bl) {
            try {
                Files.deleteIfExists(path);
            }
            catch (SecurityException securityException) {
                SecurityException securityException2 = securityException;
            }
        }
        try {
            outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            void var4_7;
            if (var4_7 != null) {
                throw var4_7;
            }
            throw fileAlreadyExistsException;
        }
        Throwable throwable = null;
        try (OutputStream outputStream2 = outputStream;){
            long l = Files.copy(inputStream, outputStream2);
            return l;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    public static long copy(Path path, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            long l = Files.copy(inputStream, outputStream);
            return l;
        }
    }

    private static byte[] read(InputStream inputStream, int n) throws IOException {
        int n2 = n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = inputStream.read(byArray, n3, n2 - n3)) > 0) {
                n3 += n4;
                continue;
            }
            if (n4 < 0 || (n4 = inputStream.read()) < 0) break;
            if (n2 <= 0x7FFFFFF7 - n2) {
                n2 = Math.max(n2 << 1, 8192);
            } else {
                if (n2 == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                n2 = 0x7FFFFFF7;
            }
            byArray = Arrays.copyOf(byArray, n2);
            byArray[n3++] = (byte)n4;
        }
        return n2 == n3 ? byArray : Arrays.copyOf(byArray, n3);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(Path var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> readAllLines(Path path, Charset charset) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(path, charset);){
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((object = bufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            object = arrayList;
            return object;
        }
    }

    public static Path write(Path path, byte[] byArray, OpenOption ... openOptionArray) throws IOException {
        Objects.requireNonNull(byArray);
        try (OutputStream outputStream = Files.newOutputStream(path, openOptionArray);){
            int n;
            int n2;
            for (int i = n = byArray.length; i > 0; i -= n2) {
                n2 = Math.min(i, 8192);
                outputStream.write(byArray, n - i, n2);
            }
        }
        return path;
    }

    public static Path write(Path path, Iterable<? extends CharSequence> iterable, Charset charset, OpenOption ... openOptionArray) throws IOException {
        Objects.requireNonNull(iterable);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        OutputStream outputStream = Files.newOutputStream(path, openOptionArray);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charsetEncoder));){
            for (CharSequence charSequence : iterable) {
                bufferedWriter.append(charSequence);
                bufferedWriter.newLine();
            }
        }
        return path;
    }

    private static class FileTypeDetectors {
        static final FileTypeDetector defaultFileTypeDetector = FileTypeDetectors.createDefaultFileTypeDetector();
        static final List<FileTypeDetector> installeDetectors = FileTypeDetectors.loadInstalledDetectors();

        private FileTypeDetectors() {
        }

        private static FileTypeDetector createDefaultFileTypeDetector() {
            return AccessController.doPrivileged(new PrivilegedAction<FileTypeDetector>(){

                @Override
                public FileTypeDetector run() {
                    return DefaultFileTypeDetector.create();
                }
            });
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    ArrayList<FileTypeDetector> arrayList = new ArrayList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> serviceLoader = ServiceLoader.load(FileTypeDetector.class, ClassLoader.getSystemClassLoader());
                    for (FileTypeDetector fileTypeDetector : serviceLoader) {
                        arrayList.add(fileTypeDetector);
                    }
                    return arrayList;
                }
            });
        }
    }

    private static class AcceptAllFilter
    implements DirectoryStream.Filter<Path> {
        static final AcceptAllFilter FILTER = new AcceptAllFilter();

        private AcceptAllFilter() {
        }

        @Override
        public boolean accept(Path path) {
            return true;
        }
    }
}

