/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.InactiveGroupException;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private final Hashtable<ActivationID, ActiveEntry> active = new Hashtable();
    private boolean groupInactive = false;
    private final ActivationGroupID groupID;
    private final List<ActivationID> lockedIDs = new ArrayList<ActivationID>();

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject<?> marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        ActivationGroupImpl.unexportObject(this, true);
        ServerSocketFactoryImpl serverSocketFactoryImpl = new ServerSocketFactoryImpl();
        UnicastRemoteObject.exportObject(this, 0, null, serverSocketFactoryImpl);
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new SecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2;
            Object object = this.lockedIDs;
            synchronized (object) {
                int n = this.lockedIDs.indexOf(activationID);
                if (n < 0) {
                    this.lockedIDs.add(activationID);
                    return;
                }
                activationID2 = this.lockedIDs.get(n);
            }
            object = activationID2;
            synchronized (object) {
                List<ActivationID> list = this.lockedIDs;
                synchronized (list) {
                    int n = this.lockedIDs.indexOf(activationID2);
                    if (n < 0) {
                        continue;
                    }
                    ActivationID activationID3 = this.lockedIDs.get(n);
                    if (activationID3 != activationID2) {
                        continue;
                    }
                }
                try {
                    activationID2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID activationID) {
        Object object = this.lockedIDs;
        synchronized (object) {
            activationID = this.lockedIDs.remove(this.lockedIDs.indexOf(activationID));
        }
        object = activationID;
        synchronized (object) {
            activationID.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledObject<? extends Remote> newInstance(final ActivationID activationID, final ActivationDesc activationDesc) throws ActivationException, RemoteException {
        RegistryImpl.checkAccess("ActivationInstantiator.newInstance");
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            Remote remote;
            Object object;
            block21: {
                this.acquireLock(activationID);
                object = this;
                synchronized (object) {
                    if (this.groupInactive) {
                        throw new InactiveGroupException("group is inactive");
                    }
                }
                object = this.active.get(activationID);
                if (object != null) {
                    MarshalledObject<Remote> marshalledObject = ((ActiveEntry)object).mobj;
                    return marshalledObject;
                }
                String string = activationDesc.getClassName();
                final Class<Remote> clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string).asSubclass(Remote.class);
                remote = null;
                final Thread thread = Thread.currentThread();
                final ClassLoader classLoader = thread.getContextClassLoader();
                ClassLoader classLoader2 = clazz.getClassLoader();
                final ClassLoader classLoader3 = ActivationGroupImpl.covers(classLoader2, classLoader) ? classLoader2 : classLoader;
                try {
                    remote = AccessController.doPrivileged(new PrivilegedExceptionAction<Remote>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Remote run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                            Constructor constructor = clazz.getDeclaredConstructor(ActivationID.class, MarshalledObject.class);
                            constructor.setAccessible(true);
                            try {
                                thread.setContextClassLoader(classLoader3);
                                Remote remote = (Remote)constructor.newInstance(activationID, activationDesc.getData());
                                return remote;
                            }
                            finally {
                                thread.setContextClassLoader(classLoader);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof InstantiationException) {
                        throw (InstantiationException)exception;
                    }
                    if (exception instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)exception;
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw (IllegalAccessException)exception;
                    }
                    if (exception instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exception;
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    if (!(exception instanceof Error)) break block21;
                    throw (Error)((Object)exception);
                }
            }
            object = new ActiveEntry(remote);
            this.active.put(activationID, (ActiveEntry)object);
            MarshalledObject<Remote> marshalledObject = ((ActiveEntry)object).mobj;
            return marshalledObject;
        }
        catch (NoSuchMethodError | NoSuchMethodException throwable) {
            throw new ActivationException("Activatable object must provide an activation constructor", throwable);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new ActivationException("unable to activate object", exception);
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            object = this.active.get(activationID);
            if (object == null) {
                throw new UnknownObjectException("object not active");
            }
            try {
                if (!Activatable.unexportObject(((ActiveEntry)object).impl, false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException unknownObjectException) {
                // empty catch block
            }
            this.active.remove(activationID);
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInactiveGroup() {
        boolean bl = false;
        ActivationGroupImpl activationGroupImpl = this;
        synchronized (activationGroupImpl) {
            if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                this.groupInactive = true;
                bl = true;
            }
        }
        if (bl) {
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(activationID)) {
                object = new ActiveEntry(remote);
                this.active.put(activationID, (ActiveEntry)object);
                try {
                    super.activeObject(activationID, ((ActiveEntry)object).mobj);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject<Remote> mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject<Remote>(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }

    private static class ServerSocketFactoryImpl
    implements RMIServerSocketFactory {
        private ServerSocketFactoryImpl() {
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
            if (rMISocketFactory == null) {
                rMISocketFactory = RMISocketFactory.getDefaultSocketFactory();
            }
            return rMISocketFactory.createServerSocket(n);
        }
    }
}

