/*
 * Copyright (C) 2020  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _gc_9_4_1_OFFSET_HEADER
#define _gc_9_4_1_OFFSET_HEADER

// addressBlock: gc_grbmdec
// base address: 0x8000
#define mmGRBM_CNTL                                                                                    0x0000
#define mmGRBM_CNTL_BASE_IDX                                                                           0
#define mmGRBM_SKEW_CNTL                                                                               0x0001
#define mmGRBM_SKEW_CNTL_BASE_IDX                                                                      0
#define mmGRBM_STATUS2                                                                                 0x0002
#define mmGRBM_STATUS2_BASE_IDX                                                                        0
#define mmGRBM_PWR_CNTL                                                                                0x0003
#define mmGRBM_PWR_CNTL_BASE_IDX                                                                       0
#define mmGRBM_STATUS                                                                                  0x0004
#define mmGRBM_STATUS_BASE_IDX                                                                         0
#define mmGRBM_STATUS_SE0                                                                              0x0005
#define mmGRBM_STATUS_SE0_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE1                                                                              0x0006
#define mmGRBM_STATUS_SE1_BASE_IDX                                                                     0
#define mmGRBM_SOFT_RESET                                                                              0x0008
#define mmGRBM_SOFT_RESET_BASE_IDX                                                                     0
#define mmGRBM_GFX_CLKEN_CNTL                                                                          0x000c
#define mmGRBM_GFX_CLKEN_CNTL_BASE_IDX                                                                 0
#define mmGRBM_WAIT_IDLE_CLOCKS                                                                        0x000d
#define mmGRBM_WAIT_IDLE_CLOCKS_BASE_IDX                                                               0
#define mmGRBM_STATUS_SE2                                                                              0x000e
#define mmGRBM_STATUS_SE2_BASE_IDX                                                                     0
#define mmGRBM_STATUS_SE3                                                                              0x000f
#define mmGRBM_STATUS_SE3_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR                                                                              0x0016
#define mmGRBM_READ_ERROR_BASE_IDX                                                                     0
#define mmGRBM_READ_ERROR2                                                                             0x0017
#define mmGRBM_READ_ERROR2_BASE_IDX                                                                    0
#define mmGRBM_INT_CNTL                                                                                0x0018
#define mmGRBM_INT_CNTL_BASE_IDX                                                                       0
#define mmGRBM_TRAP_OP                                                                                 0x0019
#define mmGRBM_TRAP_OP_BASE_IDX                                                                        0
#define mmGRBM_TRAP_ADDR                                                                               0x001a
#define mmGRBM_TRAP_ADDR_BASE_IDX                                                                      0
#define mmGRBM_TRAP_ADDR_MSK                                                                           0x001b
#define mmGRBM_TRAP_ADDR_MSK_BASE_IDX                                                                  0
#define mmGRBM_TRAP_WD                                                                                 0x001c
#define mmGRBM_TRAP_WD_BASE_IDX                                                                        0
#define mmGRBM_TRAP_WD_MSK                                                                             0x001d
#define mmGRBM_TRAP_WD_MSK_BASE_IDX                                                                    0
#define mmGRBM_DSM_BYPASS                                                                              0x001e
#define mmGRBM_DSM_BYPASS_BASE_IDX                                                                     0
#define mmGRBM_WRITE_ERROR                                                                             0x001f
#define mmGRBM_WRITE_ERROR_BASE_IDX                                                                    0
#define mmGRBM_IOV_ERROR                                                                               0x0020
#define mmGRBM_IOV_ERROR_BASE_IDX                                                                      0
#define mmGRBM_CHIP_REVISION                                                                           0x0021
#define mmGRBM_CHIP_REVISION_BASE_IDX                                                                  0
#define mmGRBM_GFX_CNTL                                                                                0x0022
#define mmGRBM_GFX_CNTL_BASE_IDX                                                                       0
#define mmGRBM_RSMU_CFG                                                                                0x0023
#define mmGRBM_RSMU_CFG_BASE_IDX                                                                       0
#define mmGRBM_IH_CREDIT                                                                               0x0024
#define mmGRBM_IH_CREDIT_BASE_IDX                                                                      0
#define mmGRBM_PWR_CNTL2                                                                               0x0025
#define mmGRBM_PWR_CNTL2_BASE_IDX                                                                      0
#define mmGRBM_UTCL2_INVAL_RANGE_START                                                                 0x0026
#define mmGRBM_UTCL2_INVAL_RANGE_START_BASE_IDX                                                        0
#define mmGRBM_UTCL2_INVAL_RANGE_END                                                                   0x0027
#define mmGRBM_UTCL2_INVAL_RANGE_END_BASE_IDX                                                          0
#define mmGRBM_RSMU_READ_ERROR                                                                         0x0028
#define mmGRBM_RSMU_READ_ERROR_BASE_IDX                                                                0
#define mmGRBM_CHICKEN_BITS                                                                            0x0029
#define mmGRBM_CHICKEN_BITS_BASE_IDX                                                                   0
#define mmGRBM_FENCE_RANGE0                                                                            0x002a
#define mmGRBM_FENCE_RANGE0_BASE_IDX                                                                   0
#define mmGRBM_FENCE_RANGE1                                                                            0x002b
#define mmGRBM_FENCE_RANGE1_BASE_IDX                                                                   0
#define mmGRBM_NOWHERE                                                                                 0x003f
#define mmGRBM_NOWHERE_BASE_IDX                                                                        0
#define mmGRBM_SCRATCH_REG0                                                                            0x0040
#define mmGRBM_SCRATCH_REG0_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG1                                                                            0x0041
#define mmGRBM_SCRATCH_REG1_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG2                                                                            0x0042
#define mmGRBM_SCRATCH_REG2_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG3                                                                            0x0043
#define mmGRBM_SCRATCH_REG3_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG4                                                                            0x0044
#define mmGRBM_SCRATCH_REG4_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG5                                                                            0x0045
#define mmGRBM_SCRATCH_REG5_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG6                                                                            0x0046
#define mmGRBM_SCRATCH_REG6_BASE_IDX                                                                   0
#define mmGRBM_SCRATCH_REG7                                                                            0x0047
#define mmGRBM_SCRATCH_REG7_BASE_IDX                                                                   0

// addressBlock: gc_cppdec2
// base address: 0xc600
#define mmCPF_EDC_TAG_CNT                                                                              0x1189
#define mmCPF_EDC_TAG_CNT_BASE_IDX                                                                     0
#define mmCPF_EDC_ROQ_CNT                                                                              0x118a
#define mmCPF_EDC_ROQ_CNT_BASE_IDX                                                                     0
#define mmCPG_EDC_TAG_CNT                                                                              0x118b
#define mmCPG_EDC_TAG_CNT_BASE_IDX                                                                     0
#define mmCPG_EDC_DMA_CNT                                                                              0x118d
#define mmCPG_EDC_DMA_CNT_BASE_IDX                                                                     0
#define mmCPC_EDC_SCRATCH_CNT                                                                          0x118e
#define mmCPC_EDC_SCRATCH_CNT_BASE_IDX                                                                 0
#define mmCPC_EDC_UCODE_CNT                                                                            0x118f
#define mmCPC_EDC_UCODE_CNT_BASE_IDX                                                                   0
#define mmDC_EDC_STATE_CNT                                                                             0x1191
#define mmDC_EDC_STATE_CNT_BASE_IDX                                                                    0
#define mmDC_EDC_CSINVOC_CNT                                                                           0x1192
#define mmDC_EDC_CSINVOC_CNT_BASE_IDX                                                                  0
#define mmDC_EDC_RESTORE_CNT                                                                           0x1193
#define mmDC_EDC_RESTORE_CNT_BASE_IDX                                                                  0

// addressBlock: gc_gdsdec
// base address: 0x9700
#define mmGDS_EDC_CNT                                                                                  0x05c5
#define mmGDS_EDC_CNT_BASE_IDX                                                                         0
#define mmGDS_EDC_GRBM_CNT                                                                             0x05c6
#define mmGDS_EDC_GRBM_CNT_BASE_IDX                                                                    0
#define mmGDS_EDC_OA_DED                                                                               0x05c7
#define mmGDS_EDC_OA_DED_BASE_IDX                                                                      0
#define mmGDS_EDC_OA_PHY_CNT                                                                           0x05cb
#define mmGDS_EDC_OA_PHY_CNT_BASE_IDX                                                                  0
#define mmGDS_EDC_OA_PIPE_CNT                                                                          0x05cc
#define mmGDS_EDC_OA_PIPE_CNT_BASE_IDX                                                                 0

// addressBlock: gc_shsdec
// base address: 0x9000
#define mmSPI_EDC_CNT                                                                                  0x0445
#define mmSPI_EDC_CNT_BASE_IDX                                                                         0

// addressBlock: gc_sqdec
// base address: 0x8c00
#define mmSQC_EDC_CNT2                                                                                 0x032c
#define mmSQC_EDC_CNT2_BASE_IDX                                                                        0
#define mmSQC_EDC_CNT3                                                                                 0x032d
#define mmSQC_EDC_CNT3_BASE_IDX                                                                        0
#define mmSQC_EDC_PARITY_CNT3                                                                          0x032e
#define mmSQC_EDC_PARITY_CNT3_BASE_IDX                                                                 0
#define mmSQC_EDC_CNT                                                                                  0x03a2
#define mmSQC_EDC_CNT_BASE_IDX                                                                         0
#define mmSQ_EDC_SEC_CNT                                                                               0x03a3
#define mmSQ_EDC_SEC_CNT_BASE_IDX                                                                      0
#define mmSQ_EDC_DED_CNT                                                                               0x03a4
#define mmSQ_EDC_DED_CNT_BASE_IDX                                                                      0
#define mmSQ_EDC_INFO                                                                                  0x03a5
#define mmSQ_EDC_INFO_BASE_IDX                                                                         0
#define mmSQ_EDC_CNT                                                                                   0x03a6
#define mmSQ_EDC_CNT_BASE_IDX                                                                          0

// addressBlock: gc_tpdec
// base address: 0x9400
#define mmTA_EDC_CNT                                                                                   0x0586
#define mmTA_EDC_CNT_BASE_IDX                                                                          0

// addressBlock: gc_tcdec
// base address: 0xac00
#define mmTCP_EDC_CNT                                                                                  0x0b17
#define mmTCP_EDC_CNT_BASE_IDX                                                                         0
#define mmTCP_EDC_CNT_NEW                                                                              0x0b18
#define mmTCP_EDC_CNT_NEW_BASE_IDX                                                                     0
#define mmTCP_ATC_EDC_GATCL1_CNT                                                                       0x12b1
#define mmTCP_ATC_EDC_GATCL1_CNT_BASE_IDX                                                              0
#define mmTCI_EDC_CNT                                                                                  0x0b60
#define mmTCI_EDC_CNT_BASE_IDX                                                                         0
#define mmTCC_EDC_CNT                                                                                  0x0b82
#define mmTCC_EDC_CNT_BASE_IDX                                                                         0
#define mmTCC_EDC_CNT2                                                                                 0x0b83
#define mmTCC_EDC_CNT2_BASE_IDX                                                                        0
#define mmTCA_EDC_CNT                                                                                  0x0bc5
#define mmTCA_EDC_CNT_BASE_IDX                                                                         0

// addressBlock: gc_tpdec
// base address: 0x9400
#define mmTD_EDC_CNT                                                                                   0x052e
#define mmTD_EDC_CNT_BASE_IDX                                                                          0
#define mmTA_EDC_CNT                                                                                   0x0586
#define mmTA_EDC_CNT_BASE_IDX                                                                          0

// addressBlock: gc_ea_gceadec2
// base address: 0x9c00
#define mmGCEA_EDC_CNT                                                                                 0x0706
#define mmGCEA_EDC_CNT_BASE_IDX                                                                        0
#define mmGCEA_EDC_CNT2                                                                                0x0707
#define mmGCEA_EDC_CNT2_BASE_IDX                                                                       0
#define mmGCEA_EDC_CNT3                                                                                0x071b
#define mmGCEA_EDC_CNT3_BASE_IDX                                                                       0

// addressBlock: gc_gfxudec
// base address: 0x30000
#define mmSCRATCH_REG0                                                                                 0x2040
#define mmSCRATCH_REG0_BASE_IDX                                                                        1
#define mmSCRATCH_REG1                                                                                 0x2041
#define mmSCRATCH_REG1_BASE_IDX                                                                        1
#define mmSCRATCH_REG2                                                                                 0x2042
#define mmSCRATCH_REG2_BASE_IDX                                                                        1
#define mmSCRATCH_REG3                                                                                 0x2043
#define mmSCRATCH_REG3_BASE_IDX                                                                        1
#define mmSCRATCH_REG4                                                                                 0x2044
#define mmSCRATCH_REG4_BASE_IDX                                                                        1
#define mmSCRATCH_REG5                                                                                 0x2045
#define mmSCRATCH_REG5_BASE_IDX                                                                        1
#define mmSCRATCH_REG6                                                                                 0x2046
#define mmSCRATCH_REG6_BASE_IDX                                                                        1
#define mmSCRATCH_REG7                                                                                 0x2047
#define mmSCRATCH_REG7_BASE_IDX                                                                        1
#define mmGRBM_GFX_INDEX                                                                               0x2200
#define mmGRBM_GFX_INDEX_BASE_IDX                                                                      1

// addressBlock: gc_utcl2_atcl2dec
// base address: 0xa000
#define mmATC_L2_CACHE_4K_DSM_INDEX                                                                    0x080e
#define mmATC_L2_CACHE_4K_DSM_INDEX_BASE_IDX                                                           0
#define mmATC_L2_CACHE_2M_DSM_INDEX                                                                    0x080f
#define mmATC_L2_CACHE_2M_DSM_INDEX_BASE_IDX                                                           0
#define mmATC_L2_CACHE_4K_DSM_CNTL                                                                     0x0810
#define mmATC_L2_CACHE_4K_DSM_CNTL_BASE_IDX                                                            0
#define mmATC_L2_CACHE_2M_DSM_CNTL                                                                     0x0811
#define mmATC_L2_CACHE_2M_DSM_CNTL_BASE_IDX                                                            0

// addressBlock: gc_utcl2_vml2pfdec
// base address: 0xa100
#define mmVML2_MEM_ECC_INDEX                                                                           0x0860
#define mmVML2_MEM_ECC_INDEX_BASE_IDX                                                                  0
#define mmVML2_WALKER_MEM_ECC_INDEX                                                                    0x0861
#define mmVML2_WALKER_MEM_ECC_INDEX_BASE_IDX                                                           0
#define mmUTCL2_MEM_ECC_INDEX                                                                          0x0862
#define mmUTCL2_MEM_ECC_INDEX_BASE_IDX                                                                 0

#define mmVML2_MEM_ECC_CNTL                                                                            0x0863
#define mmVML2_MEM_ECC_CNTL_BASE_IDX                                                                   0
#define mmVML2_WALKER_MEM_ECC_CNTL                                                                     0x0864
#define mmVML2_WALKER_MEM_ECC_CNTL_BASE_IDX                                                            0
#define mmUTCL2_MEM_ECC_CNTL                                                                           0x0865
#define mmUTCL2_MEM_ECC_CNTL_BASE_IDX                                                                  0

// addressBlock: gc_rlcpdec
// base address: 0x3b000
#define mmRLC_EDC_CNT                                                                                  0x4d40
#define mmRLC_EDC_CNT_BASE_IDX                                                                         1
#define mmRLC_EDC_CNT2                                                                                 0x4d41
#define mmRLC_EDC_CNT2_BASE_IDX                                                                        1

#endif