/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.management.Descriptor;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable {
    static final long serialVersionUID = -6178860474881375330L;
    static final MBeanOperationInfo[] NO_OPERATIONS = new MBeanOperationInfo[0];
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private final String type;
    private final MBeanParameterInfo[] signature;
    private final int impact;
    private final transient boolean arrayGettersSafe;

    public MBeanOperationInfo(String string, Method method) {
        this(method.getName(), string, MBeanOperationInfo.methodSignature(method), method.getReturnType().getName(), 3, Introspector.descriptorForElement(method));
    }

    public MBeanOperationInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, String string3, int n) {
        this(string, string2, mBeanParameterInfoArray, string3, n, null);
    }

    public MBeanOperationInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray, String string3, int n, Descriptor descriptor) {
        super(string, string2, descriptor);
        mBeanParameterInfoArray = mBeanParameterInfoArray == null || mBeanParameterInfoArray.length == 0 ? MBeanParameterInfo.NO_PARAMS : (MBeanParameterInfo[])mBeanParameterInfoArray.clone();
        this.signature = mBeanParameterInfoArray;
        this.type = string3;
        this.impact = n;
        this.arrayGettersSafe = MBeanInfo.arrayGettersSafe(this.getClass(), MBeanOperationInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature == null) {
            return MBeanParameterInfo.NO_PARAMS;
        }
        if (this.signature.length == 0) {
            return this.signature;
        }
        return (MBeanParameterInfo[])this.signature.clone();
    }

    private MBeanParameterInfo[] fastGetSignature() {
        if (this.arrayGettersSafe) {
            if (this.signature == null) {
                return MBeanParameterInfo.NO_PARAMS;
            }
            return this.signature;
        }
        return this.getSignature();
    }

    public int getImpact() {
        return this.impact;
    }

    public String toString() {
        String string;
        switch (this.getImpact()) {
            case 1: {
                string = "action";
                break;
            }
            case 2: {
                string = "action/info";
                break;
            }
            case 0: {
                string = "info";
                break;
            }
            case 3: {
                string = "unknown";
                break;
            }
            default: {
                string = "(" + this.getImpact() + ")";
            }
        }
        return this.getClass().getName() + "[" + "description=" + this.getDescription() + ", " + "name=" + this.getName() + ", " + "returnType=" + this.getReturnType() + ", " + "signature=" + Arrays.asList(this.fastGetSignature()) + ", " + "impact=" + string + ", " + "descriptor=" + this.getDescriptor() + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanOperationInfo)) {
            return false;
        }
        MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)object;
        return Objects.equals(mBeanOperationInfo.getName(), this.getName()) && Objects.equals(mBeanOperationInfo.getReturnType(), this.getReturnType()) && Objects.equals(mBeanOperationInfo.getDescription(), this.getDescription()) && mBeanOperationInfo.getImpact() == this.getImpact() && Arrays.equals(mBeanOperationInfo.fastGetSignature(), this.fastGetSignature()) && Objects.equals(mBeanOperationInfo.getDescriptor(), this.getDescriptor());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getReturnType());
    }

    private static MBeanParameterInfo[] methodSignature(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        return MBeanOperationInfo.parameters(classArray, annotationArray);
    }

    static MBeanParameterInfo[] parameters(Class<?>[] classArray, Annotation[][] annotationArray) {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[classArray.length];
        assert (classArray.length == annotationArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            Descriptor descriptor = Introspector.descriptorForAnnotations(annotationArray[i]);
            String string = "p" + (i + 1);
            mBeanParameterInfoArray[i] = new MBeanParameterInfo(string, classArray[i].getName(), "", descriptor);
        }
        return mBeanParameterInfoArray;
    }
}

