/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeTypeParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MimeTypeParameterList
implements Cloneable {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public int hashCode() {
        int n = 0x2D82D82;
        String string = null;
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n += string.hashCode();
            n += this.get(string).hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MimeTypeParameterList)) {
            return false;
        }
        MimeTypeParameterList mimeTypeParameterList = (MimeTypeParameterList)object;
        if (this.size() != mimeTypeParameterList.size()) {
            return false;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Set set = this.parameters.entrySet();
        Iterator iterator = set.iterator();
        Map.Entry entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            string2 = (String)entry.getValue();
            string3 = (String)mimeTypeParameterList.parameters.get(string);
            if (!(string2 == null || string3 == null ? string2 != string3 : !string2.equals(string3))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String string) throws MimeTypeParseException {
        int n = string.length();
        if (n <= 0) return;
        int n2 = MimeTypeParameterList.skipWhiteSpace(string, 0);
        int n3 = 0;
        if (n2 >= n) return;
        char c = string.charAt(n2);
        while (n2 < n && c == ';') {
            String string2;
            boolean bl;
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) throw new MimeTypeParseException("Couldn't find parameter name");
            n3 = n2;
            c = string.charAt(n2);
            while (n2 < n && MimeTypeParameterList.isTokenChar(c)) {
                c = string.charAt(++n2);
            }
            String string3 = string.substring(n3, n2).toLowerCase();
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n || string.charAt(n2) != '=') throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) throw new MimeTypeParseException("Couldn't find a value for parameter named " + string3);
            c = string.charAt(n2);
            if (c == '\"') {
                n3 = ++n2;
                if (n2 >= n) throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                bl = false;
                while (n2 < n && !bl) {
                    c = string.charAt(n2);
                    if (c == '\\') {
                        n2 += 2;
                        continue;
                    }
                    if (c == '\"') {
                        bl = true;
                        continue;
                    }
                    ++n2;
                }
                if (c != '\"') throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                string2 = MimeTypeParameterList.unquote(string.substring(n3, n2));
                ++n2;
            } else {
                if (!MimeTypeParameterList.isTokenChar(c)) throw new MimeTypeParseException("Unexpected character encountered at index " + n2);
                n3 = n2;
                bl = false;
                while (n2 < n && !bl) {
                    c = string.charAt(n2);
                    if (MimeTypeParameterList.isTokenChar(c)) {
                        ++n2;
                        continue;
                    }
                    bl = true;
                }
                string2 = string.substring(n3, n2);
            }
            this.parameters.put(string3, string2);
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) continue;
            c = string.charAt(n2);
        }
        if (n2 >= n) return;
        throw new MimeTypeParseException("More characters encountered in input than expected.");
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String string) {
        return (String)this.parameters.get(string.trim().toLowerCase());
    }

    public void set(String string, String string2) {
        this.parameters.put(string.trim().toLowerCase(), string2);
    }

    public void remove(String string) {
        this.parameters.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.parameters.size() * 16);
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            stringBuilder.append("; ");
            String string = (String)enumeration.nextElement();
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(MimeTypeParameterList.quote((String)this.parameters.get(string)));
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        MimeTypeParameterList mimeTypeParameterList = null;
        try {
            mimeTypeParameterList = (MimeTypeParameterList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        mimeTypeParameterList.parameters = (Hashtable)this.parameters.clone();
        return mimeTypeParameterList;
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String string, int n) {
        int n2 = string.length();
        if (n < n2) {
            char c = string.charAt(n);
            while (n < n2 && Character.isWhitespace(c)) {
                c = string.charAt(++n);
            }
        }
        return n;
    }

    private static String quote(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n && !bl; ++i) {
            bl = !MimeTypeParameterList.isTokenChar(string.charAt(i));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.5));
            stringBuilder.append('\"');
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '\"') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\"');
            return stringBuilder.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!bl && c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }
}

