/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XRectangle
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 8;
    }

    @Override
    public int getDataSize() {
        return XRectangle.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XRectangle(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XRectangle() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XRectangle.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_x() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_x(short s) {
        log.finest("");
        Native.putShort(this.pData + 0L, s);
    }

    public short get_y() {
        log.finest("");
        return Native.getShort(this.pData + 2L);
    }

    public void set_y(short s) {
        log.finest("");
        Native.putShort(this.pData + 2L, s);
    }

    public short get_width() {
        log.finest("");
        return Native.getShort(this.pData + 4L);
    }

    public void set_width(short s) {
        log.finest("");
        Native.putShort(this.pData + 4L, s);
    }

    public short get_height() {
        log.finest("");
        return Native.getShort(this.pData + 6L);
    }

    public void set_height(short s) {
        log.finest("");
        Native.putShort(this.pData + 6L, s);
    }

    @Override
    String getName() {
        return "XRectangle";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(160);
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        return stringBuilder.toString();
    }
}

