/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Arrays;

public class BatchUpdateException
extends SQLException {
    private int[] updateCounts;
    private long[] longUpdateCounts;
    private static final long serialVersionUID = 5977529877145521757L;

    public BatchUpdateException(String string, String string2, int n, int[] nArray) {
        super(string, string2, n);
        this.updateCounts = nArray == null ? null : Arrays.copyOf(nArray, nArray.length);
        this.longUpdateCounts = nArray == null ? null : BatchUpdateException.copyUpdateCount(nArray);
    }

    public BatchUpdateException(String string, String string2, int[] nArray) {
        this(string, string2, 0, nArray);
    }

    public BatchUpdateException(String string, int[] nArray) {
        this(string, null, 0, nArray);
    }

    public BatchUpdateException(int[] nArray) {
        this(null, null, 0, nArray);
    }

    public BatchUpdateException() {
        this((String)null, (String)null, 0, (int[])null);
    }

    public BatchUpdateException(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), (String)null, 0, (int[])null, throwable);
    }

    public BatchUpdateException(int[] nArray, Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), (String)null, 0, nArray, throwable);
    }

    public BatchUpdateException(String string, int[] nArray, Throwable throwable) {
        this(string, (String)null, 0, nArray, throwable);
    }

    public BatchUpdateException(String string, String string2, int[] nArray, Throwable throwable) {
        this(string, string2, 0, nArray, throwable);
    }

    public BatchUpdateException(String string, String string2, int n, int[] nArray, Throwable throwable) {
        super(string, string2, n, throwable);
        this.updateCounts = nArray == null ? null : Arrays.copyOf(nArray, nArray.length);
        this.longUpdateCounts = nArray == null ? null : BatchUpdateException.copyUpdateCount(nArray);
    }

    public int[] getUpdateCounts() {
        return this.updateCounts == null ? null : Arrays.copyOf(this.updateCounts, this.updateCounts.length);
    }

    public BatchUpdateException(String string, String string2, int n, long[] lArray, Throwable throwable) {
        super(string, string2, n, throwable);
        this.longUpdateCounts = lArray == null ? null : Arrays.copyOf(lArray, lArray.length);
        this.updateCounts = this.longUpdateCounts == null ? null : BatchUpdateException.copyUpdateCount(this.longUpdateCounts);
    }

    public long[] getLargeUpdateCounts() {
        return this.longUpdateCounts == null ? null : Arrays.copyOf(this.longUpdateCounts, this.longUpdateCounts.length);
    }

    private static long[] copyUpdateCount(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    private static int[] copyUpdateCount(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        int[] nArray = (int[])getField.get("updateCounts", null);
        long[] lArray = (long[])getField.get("longUpdateCounts", null);
        if (nArray != null && lArray != null && nArray.length != lArray.length) {
            throw new InvalidObjectException("update counts are not the expected size");
        }
        if (nArray != null) {
            this.updateCounts = (int[])nArray.clone();
        }
        if (lArray != null) {
            this.longUpdateCounts = (long[])lArray.clone();
        }
        if (this.updateCounts == null && this.longUpdateCounts != null) {
            this.updateCounts = BatchUpdateException.copyUpdateCount(this.longUpdateCounts);
        }
        if (this.longUpdateCounts == null && this.updateCounts != null) {
            this.longUpdateCounts = BatchUpdateException.copyUpdateCount(this.updateCounts);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("updateCounts", this.updateCounts);
        putField.put("longUpdateCounts", this.longUpdateCounts);
        objectOutputStream.writeFields();
    }
}

