/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSBorder;
import javax.swing.text.html.CSSParser;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.MuxingAttributeSet;
import sun.swing.SwingUtilities2;

public class StyleSheet
extends StyleContext {
    static final Border noBorder = new EmptyBorder(0, 0, 0, 0);
    static final int DEFAULT_FONT_SIZE = 3;
    private CSS css;
    private SelectorMapping selectorMapping;
    private Hashtable<String, ResolvedStyle> resolvedStyles;
    private Vector<StyleSheet> linkedStyleSheets;
    private URL base;
    static final int[] sizeMapDefault = new int[]{8, 10, 12, 14, 18, 24, 36};
    private int[] sizeMap = sizeMapDefault;
    private boolean w3cLengthUnits = false;

    public StyleSheet() {
        this.selectorMapping = new SelectorMapping(0);
        this.resolvedStyles = new Hashtable();
        if (this.css == null) {
            this.css = new CSS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getRule(HTML.Tag tag, Element element) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        try {
            Style style;
            AttributeSet attributeSet;
            Vector vector = searchBuffer.getVector();
            for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
                vector.addElement(element2);
            }
            int n = vector.size();
            StringBuffer stringBuffer = searchBuffer.getStringBuffer();
            for (int i = n - 1; i >= 1; --i) {
                element = (Element)vector.elementAt(i);
                attributeSet = element.getAttributes();
                Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                String string = object.toString();
                stringBuffer.append(string);
                if (attributeSet != null) {
                    if (attributeSet.isDefined(HTML.Attribute.ID)) {
                        stringBuffer.append('#');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                    } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                        stringBuffer.append('.');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                    }
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append(tag.toString());
            element = (Element)vector.elementAt(0);
            attributeSet = element.getAttributes();
            if (element.isLeaf()) {
                Object object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringBuffer.append('#');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                    stringBuffer.append('.');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                }
            }
            Style style2 = style = this.getResolvedStyle(stringBuffer.toString(), vector, tag);
            return style2;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    public Style getRule(String string) {
        if ((string = this.cleanSelectorString(string)) != null) {
            Style style = this.getResolvedStyle(string);
            return style;
        }
        return null;
    }

    public void addRule(String string) {
        if (string != null) {
            if (string == "BASE_SIZE_DISABLE") {
                this.sizeMap = sizeMapDefault;
            } else if (string.startsWith("BASE_SIZE ")) {
                this.rebaseSizeMap(Integer.parseInt(string.substring("BASE_SIZE ".length())));
            } else if (string == "W3C_LENGTH_UNITS_ENABLE") {
                this.w3cLengthUnits = true;
            } else if (string == "W3C_LENGTH_UNITS_DISABLE") {
                this.w3cLengthUnits = false;
            } else {
                CssParser cssParser = new CssParser();
                try {
                    cssParser.parse(this.getBase(), new StringReader(string), false, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public AttributeSet getDeclaration(String string) {
        if (string == null) {
            return SimpleAttributeSet.EMPTY;
        }
        CssParser cssParser = new CssParser();
        return cssParser.parseDeclaration(string);
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        CssParser cssParser = new CssParser();
        cssParser.parse(uRL, reader, false, false);
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStyle(String string) {
        Style style = this.getStyle(string);
        if (style != null) {
            String string2 = this.cleanSelectorString(string);
            String[] stringArray = this.getSimpleSelectors(string2);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i], true);
                }
                Style style2 = selectorMapping.getStyle();
                if (style2 != null) {
                    selectorMapping.setStyle(null);
                    if (this.resolvedStyles.size() > 0) {
                        Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
                        while (enumeration.hasMoreElements()) {
                            ResolvedStyle resolvedStyle = enumeration.nextElement();
                            resolvedStyle.removeStyle(style2);
                        }
                    }
                }
            }
        }
        super.removeStyle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            if (this.linkedStyleSheets == null) {
                this.linkedStyleSheets = new Vector();
            }
            if (!this.linkedStyleSheets.contains(styleSheet)) {
                int n = 0;
                if (styleSheet instanceof UIResource && this.linkedStyleSheets.size() > 1) {
                    n = this.linkedStyleSheets.size() - 1;
                }
                this.linkedStyleSheets.insertElementAt(styleSheet, n);
                this.linkStyleSheetAt(styleSheet, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            int n;
            if (this.linkedStyleSheets != null && (n = this.linkedStyleSheets.indexOf(styleSheet)) != -1) {
                this.linkedStyleSheets.removeElementAt(n);
                this.unlinkStyleSheet(styleSheet, n);
                if (n == 0 && this.linkedStyleSheets.size() == 0) {
                    this.linkedStyleSheets = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheet[] getStyleSheets() {
        Object[] objectArray;
        StyleSheet styleSheet = this;
        synchronized (styleSheet) {
            if (this.linkedStyleSheets != null) {
                objectArray = new StyleSheet[this.linkedStyleSheets.size()];
                this.linkedStyleSheets.copyInto(objectArray);
            } else {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public void importStyleSheet(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            CssParser cssParser = new CssParser();
            cssParser.parse(uRL, bufferedReader, false, true);
            ((Reader)bufferedReader).close();
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    public URL getBase() {
        return this.base;
    }

    public void addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        this.css.addInternalCSSValue(mutableAttributeSet, attribute, string);
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = this.css.getCssValue(attribute, string);
        if (object != null) {
            mutableAttributeSet.addAttribute(attribute, object);
            return true;
        }
        return false;
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.css.translateHTMLToCSS(attributeSet);
        Style style = this.addStyle(null, null);
        style.addAttributes(attributeSet2);
        return style;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (this.css == null) {
            this.css = new CSS();
        }
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            Object object3;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null && attributeSet.isDefined(tag)) {
                attributeSet = this.removeAttribute(attributeSet, tag);
            }
            if ((object3 = this.css.styleConstantsValueToCSSValue((StyleConstants)object, object2)) != null && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.addAttribute(attributeSet, attribute, object3);
            }
        }
        return super.addAttribute(attributeSet, object, object2);
    }

    @Override
    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof HTMLDocument.TaggedAttributeSet)) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.addAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null) {
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
            if ((attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.removeAttribute(attributeSet, attribute);
            }
        }
        return super.removeAttribute(attributeSet, object);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        return super.removeAttributes(attributeSet, enumeration);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet != attributeSet2) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.removeAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallConversionSet(attributeSet);
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new LargeConversionSet(attributeSet);
    }

    private AttributeSet removeHTMLTags(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof LargeConversionSet) && !(attributeSet2 instanceof SmallConversionSet)) {
            Enumeration<?> enumeration = attributeSet2.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                HTML.Tag tag;
                Object obj = enumeration.nextElement();
                if (!(obj instanceof StyleConstants) || (tag = HTML.getTagForStyleConstantsKey((StyleConstants)obj)) == null || !attributeSet.isDefined(tag)) continue;
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
        }
        return attributeSet;
    }

    AttributeSet convertAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof LargeConversionSet || attributeSet instanceof SmallConversionSet) {
            return attributeSet;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof StyleConstants)) continue;
            LargeConversionSet largeConversionSet = new LargeConversionSet();
            Enumeration<?> enumeration2 = attributeSet.getAttributeNames();
            while (enumeration2.hasMoreElements()) {
                Object object;
                CSS.Attribute attribute;
                Object obj2 = enumeration2.nextElement();
                Object object2 = null;
                if (obj2 instanceof StyleConstants && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)obj2)) != null && (object2 = this.css.styleConstantsValueToCSSValue((StyleConstants)obj2, object = attributeSet.getAttribute(obj2))) != null) {
                    largeConversionSet.addAttribute(attribute, object2);
                }
                if (object2 != null) continue;
                largeConversionSet.addAttribute(obj2, attributeSet.getAttribute(obj2));
            }
            return largeConversionSet;
        }
        return attributeSet;
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        return this.css.getFont(this, attributeSet, 12, this);
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        Color color = this.css.getColor(attributeSet, CSS.Attribute.COLOR);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        return this.css.getColor(attributeSet, CSS.Attribute.BACKGROUND_COLOR);
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet, this.css, this);
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet, this);
    }

    public void setBaseFontSize(int n) {
        this.css.setBaseFontSize(n);
    }

    public void setBaseFontSize(String string) {
        this.css.setBaseFontSize(string);
    }

    public static int getIndexOfSize(float f) {
        return CSS.getIndexOfSize(f, sizeMapDefault);
    }

    public float getPointSize(int n) {
        return this.css.getPointSize(n, this);
    }

    public float getPointSize(String string) {
        return this.css.getPointSize(string, this);
    }

    public Color stringToColor(String string) {
        return CSS.stringToColor(string);
    }

    ImageIcon getBackgroundImage(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(CSS.Attribute.BACKGROUND_IMAGE);
        if (object != null) {
            return ((CSS.BackgroundImage)object).getImage(this.getBase());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRule(String[] stringArray, AttributeSet attributeSet, boolean bl) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(stringArray[i]);
        }
        String string = stringBuilder.toString();
        Style style = this.getStyle(string);
        if (style == null) {
            Style style2 = this.addStyle(string, null);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i = n - 1; i >= 0; --i) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i], true);
                }
                style = selectorMapping.getStyle();
                if (style == null) {
                    style = style2;
                    selectorMapping.setStyle(style);
                    this.refreshResolvedRules(string, stringArray, style, selectorMapping.getSpecificity());
                }
            }
        }
        if (bl) {
            style = this.getLinkedStyle(style);
        }
        style.addAttributes(attributeSet);
    }

    private synchronized void linkStyleSheetAt(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                resolvedStyle.insertExtendedStyleAt(styleSheet.getRule(resolvedStyle.getName()), n);
            }
        }
    }

    private synchronized void unlinkStyleSheet(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                resolvedStyle.removeExtendedStyleAt(n);
            }
        }
    }

    String[] getSimpleSelectors(String string) {
        string = this.cleanSelectorString(string);
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        int n = 0;
        int n2 = string.length();
        while (n != -1) {
            int n3 = string.indexOf(32, n);
            if (n3 != -1) {
                vector.addElement(string.substring(n, n3));
                if (++n3 == n2) {
                    n = -1;
                    continue;
                }
                n = n3;
                continue;
            }
            vector.addElement(string.substring(n));
            n = -1;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return objectArray;
    }

    String cleanSelectorString(String string) {
        boolean bl = true;
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    if (bl) {
                        return this._cleanSelectorString(string);
                    }
                    bl = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return this._cleanSelectorString(string);
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            return this._cleanSelectorString(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _cleanSelectorString(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        StringBuffer stringBuffer = searchBuffer.getStringBuffer();
        boolean bl = true;
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        String string2 = null;
        try {
            block7: for (int i = 0; i < n2; ++i) {
                switch (cArray[i]) {
                    case ' ': {
                        if (!bl) {
                            bl = true;
                            if (n < i) {
                                stringBuffer.append(cArray, n, 1 + i - n);
                            }
                        }
                        n = i + 1;
                        continue block7;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if (!bl) {
                            bl = true;
                            if (n < i) {
                                stringBuffer.append(cArray, n, i - n);
                                stringBuffer.append(' ');
                            }
                        }
                        n = i + 1;
                        continue block7;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (bl && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else if (n < n2) {
                stringBuffer.append(cArray, n, n2 - n);
            }
            string2 = stringBuffer.toString();
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
        return string2;
    }

    private SelectorMapping getRootSelectorMapping() {
        return this.selectorMapping;
    }

    static int getSpecificity(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = string.length();
        block5: for (int i = 0; i < n2; ++i) {
            switch (string.charAt(i)) {
                case '.': {
                    n += 100;
                    continue block5;
                }
                case '#': {
                    n += 10000;
                    continue block5;
                }
                case ' ': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (!bl) continue block5;
                    bl = false;
                    ++n;
                }
            }
        }
        return n;
    }

    private Style getLinkedStyle(Style style) {
        Style style2 = (Style)style.getResolveParent();
        if (style2 == null) {
            style2 = this.addStyle(null, null);
            style.setResolveParent(style2);
        }
        return style2;
    }

    private synchronized Style getResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        Style style = this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string, vector, tag);
        }
        return style;
    }

    private synchronized Style getResolvedStyle(String string) {
        Style style = this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string);
        }
        return style;
    }

    private void addSortedStyle(SelectorMapping selectorMapping, Vector<SelectorMapping> vector) {
        int n = vector.size();
        if (n > 0) {
            int n2 = selectorMapping.getSpecificity();
            for (int i = 0; i < n; ++i) {
                if (n2 < vector.elementAt(i).getSpecificity()) continue;
                vector.insertElementAt(selectorMapping, i);
                return;
            }
        }
        vector.addElement(selectorMapping);
    }

    private synchronized void getStyles(SelectorMapping selectorMapping, Vector<SelectorMapping> vector, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, Hashtable<SelectorMapping, SelectorMapping> hashtable) {
        if (hashtable.contains(selectorMapping)) {
            return;
        }
        hashtable.put(selectorMapping, selectorMapping);
        Style style = selectorMapping.getStyle();
        if (style != null) {
            this.addSortedStyle(selectorMapping, vector);
        }
        for (int i = n; i < n2; ++i) {
            String string;
            String string2 = stringArray[i];
            if (string2 == null) continue;
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string2, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
            }
            if (stringArray3[i] != null) {
                string = stringArray3[i];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "." + string, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
                }
            }
            if (stringArray2[i] == null) continue;
            string = stringArray2[i];
            selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "#" + string, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
            }
            if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string, false)) == null) continue;
            this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i + 1, n2, hashtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Style createResolvedStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        Hashtable hashtable = searchBuffer.getHashtable();
        try {
            Style style;
            int n;
            String string2;
            SelectorMapping selectorMapping = this.getRootSelectorMapping();
            int n2 = stringArray.length;
            String string3 = stringArray[0];
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string3, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
            }
            if (stringArray3[0] != null) {
                string2 = stringArray3[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "." + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
            }
            if (stringArray2[0] != null) {
                string2 = stringArray2[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "#" + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n2, hashtable);
                }
            }
            int n3 = this.linkedStyleSheets != null ? this.linkedStyleSheets.size() : 0;
            int n4 = vector.size();
            AttributeSet[] attributeSetArray = new AttributeSet[n4 + n3];
            for (n = 0; n < n4; ++n) {
                attributeSetArray[n] = ((SelectorMapping)vector.elementAt(n)).getStyle();
            }
            for (n = 0; n < n3; ++n) {
                style = this.linkedStyleSheets.elementAt(n).getRule(string);
                attributeSetArray[n + n4] = style == null ? SimpleAttributeSet.EMPTY : style;
            }
            ResolvedStyle resolvedStyle = new ResolvedStyle(string, attributeSetArray, n4);
            this.resolvedStyles.put(string, resolvedStyle);
            style = resolvedStyle;
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private Style createResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        int n = vector.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element = (Element)vector.elementAt(i);
            AttributeSet attributeSet = element.getAttributes();
            if (i == 0 && element.isLeaf()) {
                object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                object = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                stringArray[i] = object != null ? ((HTML.Tag)object).toString() : null;
                stringArray3[i] = attributeSet.isDefined(HTML.Attribute.CLASS) ? attributeSet.getAttribute(HTML.Attribute.CLASS).toString() : null;
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringArray2[i] = attributeSet.getAttribute(HTML.Attribute.ID).toString();
                    continue;
                }
                stringArray2[i] = null;
                continue;
            }
            stringArray3[i] = null;
            stringArray2[i] = null;
            stringArray[i] = null;
        }
        stringArray[0] = tag.toString();
        return this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Style createResolvedStyle(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            while (n3 < n4) {
                int n5;
                if (n == n3) {
                    n = string.indexOf(46, n3);
                }
                if (n2 == n3) {
                    n2 = string.indexOf(35, n3);
                }
                if ((n5 = string.indexOf(32, n3)) == -1) {
                    n5 = n4;
                }
                if (n != -1 && n2 != -1 && n < n5 && n2 < n5) {
                    if (n2 < n) {
                        if (n3 == n2) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n3, n2));
                        }
                        if (n + 1 < n5) {
                            vector.addElement(string.substring(n + 1, n5));
                        } else {
                            vector.addElement(null);
                        }
                        if (n2 + 1 == n) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n2 + 1, n));
                        }
                    } else if (n2 < n5) {
                        if (n3 == n) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n3, n));
                        }
                        if (n + 1 < n2) {
                            vector.addElement(string.substring(n + 1, n2));
                        } else {
                            vector.addElement(null);
                        }
                        if (n2 + 1 == n5) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n2 + 1, n5));
                        }
                    }
                    n = n2 = n5 + 1;
                } else if (n != -1 && n < n5) {
                    if (n == n3) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n3, n));
                    }
                    if (n + 1 == n5) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n + 1, n5));
                    }
                    vector.addElement(null);
                    n = n5 + 1;
                } else if (n2 != -1 && n2 < n5) {
                    if (n2 == n3) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n3, n2));
                    }
                    vector.addElement(null);
                    if (n2 + 1 == n5) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n2 + 1, n5));
                    }
                    n2 = n5 + 1;
                } else {
                    vector.addElement(string.substring(n3, n5));
                    vector.addElement(null);
                    vector.addElement(null);
                }
                n3 = n5 + 1;
            }
            int n6 = vector.size();
            int n7 = n6 / 3;
            String[] stringArray = new String[n7];
            String[] stringArray2 = new String[n7];
            String[] stringArray3 = new String[n7];
            int n8 = 0;
            int n9 = n6 - 3;
            while (n8 < n7) {
                stringArray[n8] = (String)vector.elementAt(n9);
                stringArray3[n8] = (String)vector.elementAt(n9 + 1);
                stringArray2[n8] = (String)vector.elementAt(n9 + 2);
                ++n8;
                n9 -= 3;
            }
            Style style = this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private synchronized void refreshResolvedRules(String string, String[] stringArray, Style style, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration<ResolvedStyle> enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = enumeration.nextElement();
                if (!resolvedStyle.matches(string)) continue;
                resolvedStyle.insertStyle(style, n);
            }
        }
    }

    void rebaseSizeMap(int n) {
        this.sizeMap = new int[sizeMapDefault.length];
        for (int i = 0; i < sizeMapDefault.length; ++i) {
            this.sizeMap[i] = Math.max(n * sizeMapDefault[i] / sizeMapDefault[CSS.baseFontSizeIndex], 4);
        }
    }

    int[] getSizeMap() {
        return this.sizeMap;
    }

    boolean isW3CLengthUnits() {
        return this.w3cLengthUnits;
    }

    class CssParser
    implements CSSParser.CSSParserCallback {
        Vector<String[]> selectors = new Vector();
        Vector<String> selectorTokens = new Vector();
        String propertyName;
        MutableAttributeSet declaration = new SimpleAttributeSet();
        boolean parsingDeclaration;
        boolean isLink;
        URL base;
        CSSParser parser = new CSSParser();

        CssParser() {
        }

        public AttributeSet parseDeclaration(String string) {
            try {
                return this.parseDeclaration(new StringReader(string));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public AttributeSet parseDeclaration(Reader reader) throws IOException {
            this.parse(this.base, reader, true, false);
            return this.declaration.copyAttributes();
        }

        public void parse(URL uRL, Reader reader, boolean bl, boolean bl2) throws IOException {
            this.base = uRL;
            this.isLink = bl2;
            this.parsingDeclaration = bl;
            this.declaration.removeAttributes(this.declaration);
            this.selectorTokens.removeAllElements();
            this.selectors.removeAllElements();
            this.propertyName = null;
            this.parser.parse(reader, this, bl);
        }

        @Override
        public void handleImport(String string) {
            URL uRL = CSS.getURL(this.base, string);
            if (uRL != null) {
                StyleSheet.this.importStyleSheet(uRL);
            }
        }

        @Override
        public void handleSelector(String string) {
            if (!string.startsWith(".") && !string.startsWith("#")) {
                string = string.toLowerCase();
            }
            int n = string.length();
            if (string.endsWith(",")) {
                if (n > 1) {
                    string = string.substring(0, n - 1);
                    this.selectorTokens.addElement(string);
                }
                this.addSelector();
            } else if (n > 0) {
                this.selectorTokens.addElement(string);
            }
        }

        @Override
        public void startRule() {
            if (this.selectorTokens.size() > 0) {
                this.addSelector();
            }
            this.propertyName = null;
        }

        @Override
        public void handleProperty(String string) {
            this.propertyName = string;
        }

        @Override
        public void handleValue(String string) {
            if (this.propertyName != null && string != null && string.length() > 0) {
                CSS.Attribute attribute = CSS.getAttribute(this.propertyName);
                if (attribute != null) {
                    URL uRL;
                    if (attribute == CSS.Attribute.LIST_STYLE_IMAGE && string != null && !string.equals("none") && (uRL = CSS.getURL(this.base, string)) != null) {
                        string = uRL.toString();
                    }
                    StyleSheet.this.addCSSAttribute(this.declaration, attribute, string);
                }
                this.propertyName = null;
            }
        }

        @Override
        public void endRule() {
            int n = this.selectors.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = this.selectors.elementAt(i);
                if (stringArray.length <= 0) continue;
                StyleSheet.this.addRule(stringArray, this.declaration, this.isLink);
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        private void addSelector() {
            Object[] objectArray = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(objectArray);
            this.selectors.addElement((String[])objectArray);
            this.selectorTokens.removeAllElements();
        }
    }

    static class SelectorMapping
    implements Serializable {
        private int specificity;
        private Style style;
        private HashMap<String, SelectorMapping> children;

        public SelectorMapping(int n) {
            this.specificity = n;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public SelectorMapping getChildSelectorMapping(String string, boolean bl) {
            SelectorMapping selectorMapping = null;
            if (this.children != null) {
                selectorMapping = this.children.get(string);
            } else if (bl) {
                this.children = new HashMap(7);
            }
            if (selectorMapping == null && bl) {
                int n = this.getChildSpecificity(string);
                selectorMapping = this.createChildSelectorMapping(n);
                this.children.put(string, selectorMapping);
            }
            return selectorMapping;
        }

        protected SelectorMapping createChildSelectorMapping(int n) {
            return new SelectorMapping(n);
        }

        protected int getChildSpecificity(String string) {
            char c = string.charAt(0);
            int n = this.getSpecificity();
            if (c == '.') {
                n += 100;
            } else if (c == '#') {
                n += 10000;
            } else {
                ++n;
                if (string.indexOf(46) != -1) {
                    n += 100;
                }
                if (string.indexOf(35) != -1) {
                    n += 10000;
                }
            }
            return n;
        }
    }

    static class ResolvedStyle
    extends MuxingAttributeSet
    implements Serializable,
    Style {
        String name;
        private int extendedIndex;

        ResolvedStyle(String string, AttributeSet[] attributeSetArray, int n) {
            super(attributeSetArray);
            this.name = string;
            this.extendedIndex = n;
        }

        synchronized void insertStyle(Style style, int n) {
            int n2;
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n3 = attributeSetArray.length;
            for (n2 = 0; n2 < this.extendedIndex && n <= StyleSheet.getSpecificity(((Style)attributeSetArray[n2]).getName()); ++n2) {
            }
            this.insertAttributeSetAt(style, n2);
            ++this.extendedIndex;
        }

        synchronized void removeStyle(Style style) {
            AttributeSet[] attributeSetArray = this.getAttributes();
            for (int i = attributeSetArray.length - 1; i >= 0; --i) {
                if (attributeSetArray[i] != style) continue;
                this.removeAttributeSetAt(i);
                if (i >= this.extendedIndex) break;
                --this.extendedIndex;
                break;
            }
        }

        synchronized void insertExtendedStyleAt(Style style, int n) {
            this.insertAttributeSetAt(style, this.extendedIndex + n);
        }

        synchronized void addExtendedStyle(Style style) {
            this.insertAttributeSetAt(style, this.getAttributes().length);
        }

        synchronized void removeExtendedStyleAt(int n) {
            this.removeAttributeSetAt(this.extendedIndex + n);
        }

        protected boolean matches(String string) {
            int n = string.length();
            if (n == 0) {
                return false;
            }
            int n2 = this.name.length();
            int n3 = string.lastIndexOf(32);
            int n4 = this.name.lastIndexOf(32);
            if (n3 >= 0) {
                ++n3;
            }
            if (n4 >= 0) {
                ++n4;
            }
            if (!this.matches(string, n3, n, n4, n2)) {
                return false;
            }
            while (n3 != -1) {
                n = n3 - 1;
                if ((n3 = string.lastIndexOf(32, n - 1)) >= 0) {
                    ++n3;
                }
                boolean bl = false;
                while (!bl && n4 != -1) {
                    n2 = n4 - 1;
                    if ((n4 = this.name.lastIndexOf(32, n2 - 1)) >= 0) {
                        ++n4;
                    }
                    bl = this.matches(string, n3, n, n4, n2);
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        boolean matches(String string, int n, int n2, int n3, int n4) {
            n = Math.max(n, 0);
            n3 = Math.max(n3, 0);
            int n5 = this.boundedIndexOf(this.name, '.', n3, n4);
            int n6 = this.boundedIndexOf(this.name, '#', n3, n4);
            int n7 = this.boundedIndexOf(string, '.', n, n2);
            int n8 = this.boundedIndexOf(string, '#', n, n2);
            if (n7 != -1) {
                if (n5 == -1) {
                    return false;
                }
                return !(n == n7 ? n4 - n5 != n2 - n7 || !string.regionMatches(n, this.name, n5, n4 - n5) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n8 != -1) {
                if (n6 == -1) {
                    return false;
                }
                return !(n == n8 ? n4 - n6 != n2 - n8 || !string.regionMatches(n, this.name, n6, n4 - n6) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n5 != -1) {
                return n5 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n5 - n3);
            }
            if (n6 != -1) {
                return n6 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n6 - n3);
            }
            return n4 - n3 == n2 - n && string.regionMatches(n, this.name, n3, n4 - n3);
        }

        int boundedIndexOf(String string, char c, int n, int n2) {
            int n3 = string.indexOf(c, n);
            if (n3 >= n2) {
                return -1;
            }
            return n3;
        }

        @Override
        public void addAttribute(Object object, Object object2) {
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void removeAttribute(Object object) {
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        public ChangeListener[] getChangeListeners() {
            return new ChangeListener[0];
        }
    }

    class ViewAttributeSet
    extends MuxingAttributeSet {
        View host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViewAttributeSet(View view) {
            this.host = view;
            Document document = view.getDocument();
            SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
            Vector vector = searchBuffer.getVector();
            try {
                Object[] objectArray2;
                if (document instanceof HTMLDocument) {
                    objectArray2 = StyleSheet.this;
                    Element element = view.getElement();
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = objectArray2.translateHTMLToCSS(attributeSet);
                    if (attributeSet2.getAttributeCount() != 0) {
                        vector.addElement(attributeSet2);
                    }
                    if (element.isLeaf()) {
                        Enumeration<?> enumeration = attributeSet.getAttributeNames();
                        while (enumeration.hasMoreElements()) {
                            AttributeSet attributeSet3;
                            Object object;
                            Object obj = enumeration.nextElement();
                            if (!(obj instanceof HTML.Tag) || obj == HTML.Tag.A && (object = attributeSet.getAttribute(obj)) != null && object instanceof AttributeSet && (attributeSet3 = (AttributeSet)object).getAttribute(HTML.Attribute.HREF) == null || (object = objectArray2.getRule((HTML.Tag)obj, element)) == null) continue;
                            vector.addElement(object);
                        }
                    } else {
                        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                        Style style = objectArray2.getRule(tag, element);
                        if (style != null) {
                            vector.addElement(style);
                        }
                    }
                }
                objectArray2 = new AttributeSet[vector.size()];
                vector.copyInto(objectArray2);
                this.setAttributes((AttributeSet[])objectArray2);
            }
            finally {
                SearchBuffer.releaseSearchBuffer(searchBuffer);
            }
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                object = attribute;
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = this.doGetAttribute(attribute)) instanceof CSS.CssValue) {
                return ((CSS.CssValue)object2).toStyleConstants((StyleConstants)object, this.host);
            }
            return this.doGetAttribute(object);
        }

        Object doGetAttribute(Object object) {
            AttributeSet attributeSet;
            CSS.Attribute attribute;
            Object object2 = super.getAttribute(object);
            if (object2 != null) {
                return object2;
            }
            if (object instanceof CSS.Attribute && (attribute = (CSS.Attribute)object).isInherited() && (attributeSet = this.getResolveParent()) != null) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        @Override
        public AttributeSet getResolveParent() {
            if (this.host == null) {
                return null;
            }
            View view = this.host.getParent();
            return view != null ? view.getAttributes() : null;
        }
    }

    static class BackgroundImagePainter
    implements Serializable {
        ImageIcon backgroundImage;
        float hPosition;
        float vPosition;
        short flags;
        private int paintX;
        private int paintY;
        private int paintMaxX;
        private int paintMaxY;

        BackgroundImagePainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            CSS.Value value;
            this.backgroundImage = styleSheet.getBackgroundImage(attributeSet);
            CSS.BackgroundPosition backgroundPosition = (CSS.BackgroundPosition)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
            if (backgroundPosition != null) {
                this.hPosition = backgroundPosition.getHorizontalPosition();
                this.vPosition = backgroundPosition.getVerticalPosition();
                if (backgroundPosition.isHorizontalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 4);
                } else if (backgroundPosition.isHorizontalPositionRelativeToSize()) {
                    this.hPosition *= (float)CSS.getFontSize(attributeSet, 12, styleSheet);
                }
                if (backgroundPosition.isVerticalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 8);
                } else if (backgroundPosition.isVerticalPositionRelativeToFontSize()) {
                    this.vPosition *= (float)CSS.getFontSize(attributeSet, 12, styleSheet);
                }
            }
            if ((value = (CSS.Value)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_REPEAT)) == null || value == CSS.Value.BACKGROUND_REPEAT) {
                this.flags = (short)(this.flags | 3);
            } else if (value == CSS.Value.BACKGROUND_REPEAT_X) {
                this.flags = (short)(this.flags | 1);
            } else if (value == CSS.Value.BACKGROUND_REPEAT_Y) {
                this.flags = (short)(this.flags | 2);
            }
        }

        void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            Rectangle rectangle = graphics.getClipRect();
            if (rectangle != null) {
                graphics.clipRect((int)f, (int)f2, (int)f3, (int)f4);
            }
            if ((this.flags & 3) == 0) {
                int n = this.backgroundImage.getIconWidth();
                int n2 = this.backgroundImage.getIconWidth();
                this.paintX = (this.flags & 4) == 4 ? (int)(f + f3 * this.hPosition - (float)n * this.hPosition) : (int)f + (int)this.hPosition;
                this.paintY = (this.flags & 8) == 8 ? (int)(f2 + f4 * this.vPosition - (float)n2 * this.vPosition) : (int)f2 + (int)this.vPosition;
                if (rectangle == null || this.paintX + n > rectangle.x && this.paintY + n2 > rectangle.y && this.paintX < rectangle.x + rectangle.width && this.paintY < rectangle.y + rectangle.height) {
                    this.backgroundImage.paintIcon(null, graphics, this.paintX, this.paintY);
                }
            } else {
                int n = this.backgroundImage.getIconWidth();
                int n3 = this.backgroundImage.getIconHeight();
                if (n > 0 && n3 > 0) {
                    this.paintX = (int)f;
                    this.paintY = (int)f2;
                    this.paintMaxX = (int)(f + f3);
                    this.paintMaxY = (int)(f2 + f4);
                    if (this.updatePaintCoordinates(rectangle, n, n3)) {
                        while (this.paintX < this.paintMaxX) {
                            for (int i = this.paintY; i < this.paintMaxY; i += n3) {
                                this.backgroundImage.paintIcon(null, graphics, this.paintX, i);
                            }
                            this.paintX += n;
                        }
                    }
                }
            }
            if (rectangle != null) {
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private boolean updatePaintCoordinates(Rectangle rectangle, int n, int n2) {
            if ((this.flags & 3) == 1) {
                this.paintMaxY = this.paintY + 1;
            } else if ((this.flags & 3) == 2) {
                this.paintMaxX = this.paintX + 1;
            }
            if (rectangle != null) {
                if ((this.flags & 3) == 1 && (this.paintY + n2 <= rectangle.y || this.paintY > rectangle.y + rectangle.height)) {
                    return false;
                }
                if ((this.flags & 3) == 2 && (this.paintX + n <= rectangle.x || this.paintX > rectangle.x + rectangle.width)) {
                    return false;
                }
                if ((this.flags & 1) == 1) {
                    if (rectangle.x + rectangle.width < this.paintMaxX) {
                        this.paintMaxX = (rectangle.x + rectangle.width - this.paintX) % n == 0 ? rectangle.x + rectangle.width : ((rectangle.x + rectangle.width - this.paintX) / n + 1) * n + this.paintX;
                    }
                    if (rectangle.x > this.paintX) {
                        this.paintX = (rectangle.x - this.paintX) / n * n + this.paintX;
                    }
                }
                if ((this.flags & 2) == 2) {
                    if (rectangle.y + rectangle.height < this.paintMaxY) {
                        this.paintMaxY = (rectangle.y + rectangle.height - this.paintY) % n2 == 0 ? rectangle.y + rectangle.height : ((rectangle.y + rectangle.height - this.paintY) / n2 + 1) * n2 + this.paintY;
                    }
                    if (rectangle.y > this.paintY) {
                        this.paintY = (rectangle.y - this.paintY) / n2 * n2 + this.paintY;
                    }
                }
            }
            return true;
        }
    }

    public static class ListPainter
    implements Serializable {
        static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
        private Rectangle paintRect;
        private boolean checkedForStart;
        private int start;
        private CSS.Value type;
        URL imageurl;
        private StyleSheet ss = null;
        Icon img = null;
        private int bulletgap = 5;
        private boolean isLeftToRight;

        ListPainter(AttributeSet attributeSet, StyleSheet styleSheet) {
            this.ss = styleSheet;
            String string = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_IMAGE);
            this.type = null;
            if (string != null && !string.equals("none")) {
                String string2 = null;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    URL uRL = new URL(string2);
                    this.img = new ImageIcon(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    if (string2 != null && styleSheet != null && styleSheet.getBase() != null) {
                        try {
                            URL uRL = new URL(styleSheet.getBase(), string2);
                            this.img = new ImageIcon(uRL);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            this.img = null;
                        }
                    }
                    this.img = null;
                }
            }
            if (this.img == null) {
                this.type = (CSS.Value)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            }
            this.start = 1;
            this.paintRect = new Rectangle();
        }

        private CSS.Value getChildType(View view) {
            CSS.Value value = (CSS.Value)view.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            if (value == null) {
                if (this.type == null) {
                    View view2 = view.getParent();
                    HTMLDocument hTMLDocument = (HTMLDocument)view2.getDocument();
                    value = HTMLDocument.matchNameAttribute(view2.getElement().getAttributes(), HTML.Tag.OL) ? CSS.Value.DECIMAL : CSS.Value.DISC;
                } else {
                    value = this.type;
                }
            }
            return value;
        }

        private void getStart(View view) {
            Object object;
            AttributeSet attributeSet;
            this.checkedForStart = true;
            Element element = view.getElement();
            if (element != null && (attributeSet = element.getAttributes()) != null && attributeSet.isDefined(HTML.Attribute.START) && (object = attributeSet.getAttribute(HTML.Attribute.START)) != null && object instanceof String) {
                try {
                    this.start = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private int getRenderIndex(View view, int n) {
            if (!this.checkedForStart) {
                this.getStart(view);
            }
            int n2 = n;
            for (int i = n; i >= 0; --i) {
                Object object;
                AttributeSet attributeSet = view.getElement().getElement(i).getAttributes();
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.LI) {
                    --n2;
                    continue;
                }
                if (!attributeSet.isDefined(HTML.Attribute.VALUE) || (object = attributeSet.getAttribute(HTML.Attribute.VALUE)) == null || !(object instanceof String)) continue;
                try {
                    int n3 = Integer.parseInt((String)object);
                    return n2 - i + n3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n2 + this.start;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view, int n) {
            Object object;
            Object object2;
            Object object3;
            View view2 = view.getView(n);
            Container container = view.getContainer();
            Object object4 = view2.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (!(object4 instanceof HTML.Tag) || object4 != HTML.Tag.LI) {
                return;
            }
            this.isLeftToRight = container.getComponentOrientation().isLeftToRight();
            float f5 = 0.0f;
            if (view2.getViewCount() > 0 && ((object3 = ((View)(object2 = view2.getView(0))).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || object3 == HTML.Tag.IMPLIED) && ((View)object2).getViewCount() > 0) {
                this.paintRect.setBounds((int)f, (int)f2, (int)f3, (int)f4);
                object = view2.getChildAllocation(0, this.paintRect);
                if (object != null && (object = ((View)object2).getView(0).getChildAllocation(0, (Shape)object)) != null) {
                    Rectangle rectangle = object instanceof Rectangle ? (Rectangle)object : object.getBounds();
                    f5 = ((View)object2).getView(0).getAlignment(1);
                    f2 = rectangle.y;
                    f4 = rectangle.height;
                }
            }
            object2 = container.isEnabled() ? (this.ss != null ? this.ss.getForeground(view2.getAttributes()) : container.getForeground()) : UIManager.getColor("textInactiveText");
            graphics.setColor((Color)object2);
            if (this.img != null) {
                this.drawIcon(graphics, (int)f, (int)f2, (int)f3, (int)f4, f5, container);
                return;
            }
            object3 = this.getChildType(view2);
            object = ((StyledDocument)view2.getDocument()).getFont(view2.getAttributes());
            if (object != null) {
                graphics.setFont((Font)object);
            }
            if (object3 == CSS.Value.SQUARE || object3 == CSS.Value.CIRCLE || object3 == CSS.Value.DISC) {
                this.drawShape(graphics, (CSS.Value)object3, (int)f, (int)f2, (int)f3, (int)f4, f5);
            } else if (object3 == CSS.Value.DECIMAL) {
                this.drawLetter(graphics, '1', (int)f, (int)f2, (int)f3, (int)f4, f5, this.getRenderIndex(view, n));
            } else if (object3 == CSS.Value.LOWER_ALPHA) {
                this.drawLetter(graphics, 'a', (int)f, (int)f2, (int)f3, (int)f4, f5, this.getRenderIndex(view, n));
            } else if (object3 == CSS.Value.UPPER_ALPHA) {
                this.drawLetter(graphics, 'A', (int)f, (int)f2, (int)f3, (int)f4, f5, this.getRenderIndex(view, n));
            } else if (object3 == CSS.Value.LOWER_ROMAN) {
                this.drawLetter(graphics, 'i', (int)f, (int)f2, (int)f3, (int)f4, f5, this.getRenderIndex(view, n));
            } else if (object3 == CSS.Value.UPPER_ROMAN) {
                this.drawLetter(graphics, 'I', (int)f, (int)f2, (int)f3, (int)f4, f5, this.getRenderIndex(view, n));
            }
        }

        void drawIcon(Graphics graphics, int n, int n2, int n3, int n4, float f, Component component) {
            int n5 = this.isLeftToRight ? -(this.img.getIconWidth() + this.bulletgap) : n3 + this.bulletgap;
            int n6 = n + n5;
            int n7 = Math.max(n2, n2 + (int)(f * (float)n4) - this.img.getIconHeight());
            this.img.paintIcon(component, graphics, n6, n7);
        }

        void drawShape(Graphics graphics, CSS.Value value, int n, int n2, int n3, int n4, float f) {
            int n5 = this.isLeftToRight ? -(this.bulletgap + 8) : n3 + this.bulletgap;
            int n6 = n + n5;
            int n7 = Math.max(n2, n2 + (int)(f * (float)n4) - 8);
            if (value == CSS.Value.SQUARE) {
                graphics.drawRect(n6, n7, 8, 8);
            } else if (value == CSS.Value.CIRCLE) {
                graphics.drawOval(n6, n7, 8, 8);
            } else {
                graphics.fillOval(n6, n7, 8, 8);
            }
        }

        void drawLetter(Graphics graphics, char c, int n, int n2, int n3, int n4, float f, int n5) {
            String string = this.formatItemNum(n5, c);
            string = this.isLeftToRight ? string + "." : "." + string;
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(null, graphics);
            int n6 = SwingUtilities2.stringWidth(null, fontMetrics, string);
            int n7 = this.isLeftToRight ? -(n6 + this.bulletgap) : n3 + this.bulletgap;
            int n8 = n + n7;
            int n9 = Math.max(n2 + fontMetrics.getAscent(), n2 + (int)((float)n4 * f));
            SwingUtilities2.drawString(null, graphics, string, n8, n9);
        }

        String formatItemNum(int n, char c) {
            String string;
            String string2 = "1";
            boolean bl = false;
            switch (c) {
                default: {
                    string = String.valueOf(n);
                    break;
                }
                case 'A': {
                    bl = true;
                }
                case 'a': {
                    string = this.formatAlphaNumerals(n);
                    break;
                }
                case 'I': {
                    bl = true;
                }
                case 'i': {
                    string = this.formatRomanNumerals(n);
                }
            }
            if (bl) {
                string = string.toUpperCase();
            }
            return string;
        }

        String formatAlphaNumerals(int n) {
            String string = n > 26 ? this.formatAlphaNumerals(n / 26) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
            return string;
        }

        String formatRomanNumerals(int n) {
            return this.formatRomanNumerals(0, n);
        }

        String formatRomanNumerals(int n, int n2) {
            if (n2 < 10) {
                return this.formatRomanDigit(n, n2);
            }
            return this.formatRomanNumerals(n + 1, n2 / 10) + this.formatRomanDigit(n, n2 % 10);
        }

        String formatRomanDigit(int n, int n2) {
            String string = "";
            if (n2 == 9) {
                string = string + romanChars[n][0];
                string = string + romanChars[n + 1][0];
                return string;
            }
            if (n2 == 4) {
                string = string + romanChars[n][0];
                string = string + romanChars[n][1];
                return string;
            }
            if (n2 >= 5) {
                string = string + romanChars[n][1];
                n2 -= 5;
            }
            for (int i = 0; i < n2; ++i) {
                string = string + romanChars[n][0];
            }
            return string;
        }
    }

    public static class BoxPainter
    implements Serializable {
        float topMargin;
        float bottomMargin;
        float leftMargin;
        float rightMargin;
        short marginFlags;
        Border border;
        Insets binsets;
        CSS css;
        StyleSheet ss;
        Color bg;
        BackgroundImagePainter bgPainter;

        BoxPainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            this.ss = styleSheet;
            this.css = cSS;
            this.border = this.getBorder(attributeSet);
            this.binsets = this.border.getBorderInsets(null);
            this.topMargin = this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
            this.bottomMargin = this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
            this.leftMargin = this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
            this.rightMargin = this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
            this.bg = styleSheet.getBackground(attributeSet);
            if (styleSheet.getBackgroundImage(attributeSet) != null) {
                this.bgPainter = new BackgroundImagePainter(attributeSet, cSS, styleSheet);
            }
        }

        Border getBorder(AttributeSet attributeSet) {
            return new CSSBorder(attributeSet);
        }

        Color getBorderColor(AttributeSet attributeSet) {
            Color color = this.css.getColor(attributeSet, CSS.Attribute.BORDER_COLOR);
            if (color == null && (color = this.css.getColor(attributeSet, CSS.Attribute.COLOR)) == null) {
                return Color.black;
            }
            return color;
        }

        public float getInset(int n, View view) {
            AttributeSet attributeSet = view.getAttributes();
            float f = 0.0f;
            switch (n) {
                case 2: {
                    f += this.getOrientationMargin(HorizontalMargin.LEFT, this.leftMargin, attributeSet, BoxPainter.isLeftToRight(view));
                    f += (float)this.binsets.left;
                    f += this.getLength(CSS.Attribute.PADDING_LEFT, attributeSet);
                    break;
                }
                case 4: {
                    f += this.getOrientationMargin(HorizontalMargin.RIGHT, this.rightMargin, attributeSet, BoxPainter.isLeftToRight(view));
                    f += (float)this.binsets.right;
                    f += this.getLength(CSS.Attribute.PADDING_RIGHT, attributeSet);
                    break;
                }
                case 1: {
                    f += this.topMargin;
                    f += (float)this.binsets.top;
                    f += this.getLength(CSS.Attribute.PADDING_TOP, attributeSet);
                    break;
                }
                case 3: {
                    f += this.bottomMargin;
                    f += (float)this.binsets.bottom;
                    f += this.getLength(CSS.Attribute.PADDING_BOTTOM, attributeSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid side: " + n);
                }
            }
            return f;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            AttributeSet attributeSet = view.getAttributes();
            boolean bl = BoxPainter.isLeftToRight(view);
            float f9 = this.getOrientationMargin(HorizontalMargin.LEFT, this.leftMargin, attributeSet, bl);
            float f10 = this.getOrientationMargin(HorizontalMargin.RIGHT, this.rightMargin, attributeSet, bl);
            if (!(view instanceof HTMLEditorKit.HTMLFactory.BodyBlockView)) {
                f5 = f9;
                f6 = this.topMargin;
                f7 = -(f9 + f10);
                f8 = -(this.topMargin + this.bottomMargin);
            }
            if (this.bg != null) {
                graphics.setColor(this.bg);
                graphics.fillRect((int)(f + f5), (int)(f2 + f6), (int)(f3 + f7), (int)(f4 + f8));
            }
            if (this.bgPainter != null) {
                this.bgPainter.paint(graphics, f + f5, f2 + f6, f3 + f7, f4 + f8, view);
            }
            f += f9;
            f2 += this.topMargin;
            f3 -= f9 + f10;
            f4 -= this.topMargin + this.bottomMargin;
            if (this.border instanceof BevelBorder) {
                int n = (int)this.getLength(CSS.Attribute.BORDER_TOP_WIDTH, attributeSet);
                for (int i = n - 1; i >= 0; --i) {
                    this.border.paintBorder(null, graphics, (int)f + i, (int)f2 + i, (int)f3 - 2 * i, (int)f4 - 2 * i);
                }
            } else {
                this.border.paintBorder(null, graphics, (int)f, (int)f2, (int)f3, (int)f4);
            }
        }

        float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
            return this.css.getLength(attributeSet, attribute, this.ss);
        }

        static boolean isLeftToRight(View view) {
            Container container;
            boolean bl = true;
            if (BoxPainter.isOrientationAware(view) && view != null && (container = view.getContainer()) != null) {
                bl = container.getComponentOrientation().isLeftToRight();
            }
            return bl;
        }

        static boolean isOrientationAware(View view) {
            Object object;
            AttributeSet attributeSet;
            boolean bl = false;
            if (view != null && (attributeSet = view.getElement().getAttributes()) != null && (object = attributeSet.getAttribute(StyleConstants.NameAttribute)) instanceof HTML.Tag && (object == HTML.Tag.DIR || object == HTML.Tag.MENU || object == HTML.Tag.UL || object == HTML.Tag.OL)) {
                bl = true;
            }
            return bl;
        }

        float getOrientationMargin(HorizontalMargin horizontalMargin, float f, AttributeSet attributeSet, boolean bl) {
            float f2 = f;
            float f3 = f;
            Object object = null;
            switch (horizontalMargin) {
                case RIGHT: {
                    f3 = bl ? this.getLength(CSS.Attribute.MARGIN_RIGHT_LTR, attributeSet) : this.getLength(CSS.Attribute.MARGIN_RIGHT_RTL, attributeSet);
                    object = attributeSet.getAttribute(CSS.Attribute.MARGIN_RIGHT);
                    break;
                }
                case LEFT: {
                    f3 = bl ? this.getLength(CSS.Attribute.MARGIN_LEFT_LTR, attributeSet) : this.getLength(CSS.Attribute.MARGIN_LEFT_RTL, attributeSet);
                    object = attributeSet.getAttribute(CSS.Attribute.MARGIN_LEFT);
                }
            }
            if (object == null && f3 != -2.1474836E9f) {
                f2 = f3;
            }
            return f2;
        }

        static enum HorizontalMargin {
            LEFT,
            RIGHT;

        }
    }

    private static class SearchBuffer {
        static Stack<SearchBuffer> searchBuffers = new Stack();
        Vector vector = null;
        StringBuffer stringBuffer = null;
        Hashtable hashtable = null;

        private SearchBuffer() {
        }

        static SearchBuffer obtainSearchBuffer() {
            SearchBuffer searchBuffer;
            try {
                searchBuffer = !searchBuffers.empty() ? searchBuffers.pop() : new SearchBuffer();
            }
            catch (EmptyStackException emptyStackException) {
                searchBuffer = new SearchBuffer();
            }
            return searchBuffer;
        }

        static void releaseSearchBuffer(SearchBuffer searchBuffer) {
            searchBuffer.empty();
            searchBuffers.push(searchBuffer);
        }

        StringBuffer getStringBuffer() {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuffer();
            }
            return this.stringBuffer;
        }

        Vector getVector() {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            return this.vector;
        }

        Hashtable getHashtable() {
            if (this.hashtable == null) {
                this.hashtable = new Hashtable();
            }
            return this.hashtable;
        }

        void empty() {
            if (this.stringBuffer != null) {
                this.stringBuffer.setLength(0);
            }
            if (this.vector != null) {
                this.vector.removeAllElements();
            }
            if (this.hashtable != null) {
                this.hashtable.clear();
            }
        }
    }

    class SmallConversionSet
    extends StyleContext.SmallAttributeSet {
        public SmallConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }

    class LargeConversionSet
    extends SimpleAttributeSet {
        public LargeConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public LargeConversionSet() {
        }

        @Override
        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }
}

