/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;

    ZipUtils() {
    }

    public static final FileTime winTimeToFileTime(long l) {
        return FileTime.from(l / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    public static final long fileTimeToWinTime(FileTime fileTime) {
        return (fileTime.to(TimeUnit.MICROSECONDS) - -11644473600000000L) * 10L;
    }

    public static final FileTime unixTimeToFileTime(long l) {
        return FileTime.from(l, TimeUnit.SECONDS);
    }

    public static final long fileTimeToUnixTime(FileTime fileTime) {
        return fileTime.to(TimeUnit.SECONDS);
    }

    private static long dosToJavaTime(long l) {
        Date date = new Date((int)((l >> 25 & 0x7FL) + 80L), (int)((l >> 21 & 0xFL) - 1L), (int)(l >> 16 & 0x1FL), (int)(l >> 11 & 0x1FL), (int)(l >> 5 & 0x3FL), (int)(l << 1 & 0x3EL));
        return date.getTime();
    }

    public static long extendedDosToJavaTime(long l) {
        long l2 = ZipUtils.dosToJavaTime(l);
        return l2 + (l >> 32);
    }

    private static long javaToDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return 0x210000L;
        }
        return n - 1980 << 25 | date.getMonth() + 1 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    public static long javaToExtendedDosTime(long l) {
        if (l < 0L) {
            return 0x210000L;
        }
        long l2 = ZipUtils.javaToDosTime(l);
        return l2 != 0x210000L ? l2 + (l % 2000L << 32) : 0x210000L;
    }

    public static final int get16(byte[] byArray, int n) {
        return Byte.toUnsignedInt(byArray[n]) | Byte.toUnsignedInt(byArray[n + 1]) << 8;
    }

    public static final long get32(byte[] byArray, int n) {
        return ((long)ZipUtils.get16(byArray, n) | (long)ZipUtils.get16(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    public static final long get64(byte[] byArray, int n) {
        return ZipUtils.get32(byArray, n) | ZipUtils.get32(byArray, n + 4) << 32;
    }
}

