/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class AWTCharset
extends Charset {
    protected Charset awtCs;
    protected Charset javaCs;

    public AWTCharset(String string, Charset charset) {
        super(string, null);
        this.javaCs = charset;
        this.awtCs = this;
    }

    @Override
    public boolean contains(Charset charset) {
        if (this.javaCs == null) {
            return false;
        }
        return this.javaCs.contains(charset);
    }

    @Override
    public CharsetEncoder newEncoder() {
        if (this.javaCs == null) {
            throw new Error("Encoder is not supported by this Charset");
        }
        return new Encoder(this.javaCs.newEncoder());
    }

    @Override
    public CharsetDecoder newDecoder() {
        if (this.javaCs == null) {
            throw new Error("Decoder is not supported by this Charset");
        }
        return new Decoder(this.javaCs.newDecoder());
    }

    public class Decoder
    extends CharsetDecoder {
        protected CharsetDecoder dec;
        private String nr;
        ByteBuffer fbb;

        protected Decoder() {
            this(aWTCharset.javaCs.newDecoder());
        }

        protected Decoder(CharsetDecoder charsetDecoder) {
            super(AWTCharset.this.awtCs, charsetDecoder.averageCharsPerByte(), charsetDecoder.maxCharsPerByte());
            this.fbb = ByteBuffer.allocate(0);
            this.dec = charsetDecoder;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return this.dec.decode(byteBuffer, charBuffer, true);
        }

        @Override
        protected CoderResult implFlush(CharBuffer charBuffer) {
            this.dec.decode(this.fbb, charBuffer, true);
            return this.dec.flush(charBuffer);
        }

        @Override
        protected void implReset() {
            this.dec.reset();
        }

        @Override
        protected void implReplaceWith(String string) {
            if (this.dec != null) {
                this.dec.replaceWith(string);
            }
        }

        @Override
        protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
            this.dec.onMalformedInput(codingErrorAction);
        }

        @Override
        protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
            this.dec.onUnmappableCharacter(codingErrorAction);
        }
    }

    public class Encoder
    extends CharsetEncoder {
        protected CharsetEncoder enc;

        protected Encoder() {
            this(aWTCharset.javaCs.newEncoder());
        }

        protected Encoder(CharsetEncoder charsetEncoder) {
            super(AWTCharset.this.awtCs, charsetEncoder.averageBytesPerChar(), charsetEncoder.maxBytesPerChar());
            this.enc = charsetEncoder;
        }

        @Override
        public boolean canEncode(char c) {
            return this.enc.canEncode(c);
        }

        @Override
        public boolean canEncode(CharSequence charSequence) {
            return this.enc.canEncode(charSequence);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            return this.enc.encode(charBuffer, byteBuffer, true);
        }

        @Override
        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            return this.enc.flush(byteBuffer);
        }

        @Override
        protected void implReset() {
            this.enc.reset();
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            if (this.enc != null) {
                this.enc.replaceWith(byArray);
            }
        }

        @Override
        protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
            this.enc.onMalformedInput(codingErrorAction);
        }

        @Override
        protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
            this.enc.onUnmappableCharacter(codingErrorAction);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return true;
        }
    }
}

