/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AccessDescription;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class AuthorityInfoAccessExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.AuthorityInfoAccess";
    public static final String NAME = "AuthorityInfoAccess";
    public static final String DESCRIPTIONS = "descriptions";
    private List<AccessDescription> accessDescriptions;

    public AuthorityInfoAccessExtension(List<AccessDescription> list) throws IOException {
        this.extensionId = PKIXExtensions.AuthInfoAccess_Id;
        this.critical = false;
        this.accessDescriptions = list;
        this.encodeThis();
    }

    public AuthorityInfoAccessExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.AuthInfoAccess_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for AuthorityInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            AccessDescription accessDescription = new AccessDescription(derValue2);
            this.accessDescriptions.add(accessDescription);
        }
    }

    public List<AccessDescription> getAccessDescriptions() {
        return this.accessDescriptions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthInfoAccess_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(DESCRIPTIONS)) {
            if (!(object instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.accessDescriptions = (List)object;
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DESCRIPTIONS)) {
            return this.accessDescriptions;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:AuthorityInfoAccessExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(DESCRIPTIONS)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DESCRIPTIONS);
        return attributeNameEnumeration.elements();
    }

    private void encodeThis() throws IOException {
        if (this.accessDescriptions.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            for (AccessDescription accessDescription : this.accessDescriptions) {
                accessDescription.encode(derOutputStream);
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            this.extensionValue = derOutputStream2.toByteArray();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "AuthorityInfoAccess [\n  " + this.accessDescriptions + "\n]\n";
    }
}

