;; gorilla-repl.fileformat = 1

;; **
;;; # GufoVolante
;;; 
;;; ![](https://raw.githubusercontent.com/d-cent/gufovolante/master/resources/gufo/gufo-volante-kokkola.png)
;;;
;;; ## Terminale interattivo per analisi di dati da soldipubblici.gov.it
;;;
;;; Per eseguire i blocchi di operazioni usare `SHIFT+INVIO`, per completare il nome
;;; delle funzioni disponibili usare `CTRL+SPAZIO`.
;;;
;;; Sviluppo in fase sperimentale, per maggiori informazioni la mailinglist pubblica e'
;;; 
;;; Archivio: https://lists.dyne.org/lurker/list/soldipubblici.it.html
;;; 
;;; Iscrizione: https://mailinglists.dyne.org/cgi-bin/mailman/listinfo/soldipubblici
;;; 
;;; Codice libero ed open source: https://github.com/d-cent/gufovolante
;;; 
;;; Questa ricerca e' legata al progetto D-CENT http://dcentproject.eu
;;;  
;;;     Copyright (c) 2016 Dyne.org, scritto da Denis Roio (@jaromil)
;;;     GufoVolante e' software libero distribuito secondo la Eclipse
;;;     Public License (come Clojure) in versione 1.0.
;;;
;; **

;; @@
(ns gufovolante.term
  (:require
   [clojure.string :as string]
   [clojure.data.json :as json]
   [clojure.contrib.humanize :refer :all]
   [gufovolante.core :refer :all :reload :true])
  (:use [gorilla-repl core table latex html]
        [huri core plot etl]
        ))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; @@
(visualizza-tavola (cerca-enti "PESCARA"))

;; @@
;; =>
;;; {"type":"list-like","open":"<center><table>","close":"</table></center>","separator":"\n","items":[{"type":"list-like","open":"<tr><th>","close":"</th></tr>","separator":"</th><th>","items":[{"type":"html","content":"<span class='clj-keyword'>:nome</span>","value":":nome"},{"type":"html","content":"<span class='clj-keyword'>:scadenza</span>","value":":scadenza"},{"type":"html","content":"<span class='clj-keyword'>:pos4</span>","value":":pos4"},{"type":"html","content":"<span class='clj-keyword'>:codice</span>","value":":codice"},{"type":"html","content":"<span class='clj-keyword'>:pos6</span>","value":":pos6"},{"type":"html","content":"<span class='clj-keyword'>:creazione</span>","value":":creazione"},{"type":"html","content":"<span class='clj-keyword'>:popolazione</span>","value":":popolazione"},{"type":"html","content":"<span class='clj-keyword'>:tipo</span>","value":":tipo"},{"type":"html","content":"<span class='clj-keyword'>:pos7</span>","value":":pos7"}],"value":"(:nome :scadenza :pos4 :codice :pos6 :creazione :popolazione :tipo :pos7)"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;COMUNE DI PESCARA&quot;</span>","value":"\"COMUNE DI PESCARA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;00124600685&quot;</span>","value":"\"00124600685\""},{"type":"html","content":"<span class='clj-string'>&quot;000016324&quot;</span>","value":"\"000016324\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2006-01-02&quot;</span>","value":"\"2006-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;00121325&quot;</span>","value":"\"00121325\""},{"type":"html","content":"<span class='clj-string'>&quot;COMUNE&quot;</span>","value":"\"COMUNE\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"COMUNE DI PESCARA\" \"9999-12-31\" \"00124600685\" \"000016324\" \"028\" \"2006-01-02\" \"00121325\" \"COMUNE\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PESCARA)&quot;</span>","value":"\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PESCARA)\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;01397530682&quot;</span>","value":"\"01397530682\""},{"type":"html","content":"<span class='clj-string'>&quot;000290622000128&quot;</span>","value":"\"000290622000128\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2008-01-02&quot;</span>","value":"\"2008-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;GESTIONI&quot;</span>","value":"\"GESTIONI\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PESCARA)\" \"9999-12-31\" \"01397530682\" \"000290622000128\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;ASL DI PESCARA (GESTIONE STRALCIO 1980 E RETRO EX ULSS PESCARA)&quot;</span>","value":"\"ASL DI PESCARA (GESTIONE STRALCIO 1980 E RETRO EX ULSS PESCARA)\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;01397530682&quot;</span>","value":"\"01397530682\""},{"type":"html","content":"<span class='clj-string'>&quot;000290622000131&quot;</span>","value":"\"000290622000131\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2008-01-02&quot;</span>","value":"\"2008-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;GESTIONI&quot;</span>","value":"\"GESTIONI\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"ASL DI PESCARA (GESTIONE STRALCIO 1980 E RETRO EX ULSS PESCARA)\" \"9999-12-31\" \"01397530682\" \"000290622000131\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PENNE)&quot;</span>","value":"\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PENNE)\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;01397530682&quot;</span>","value":"\"01397530682\""},{"type":"html","content":"<span class='clj-string'>&quot;000290622000129&quot;</span>","value":"\"000290622000129\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2008-01-02&quot;</span>","value":"\"2008-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;GESTIONI&quot;</span>","value":"\"GESTIONI\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PENNE)\" \"9999-12-31\" \"01397530682\" \"000290622000129\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS POPOLI)&quot;</span>","value":"\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS POPOLI)\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;01397530682&quot;</span>","value":"\"01397530682\""},{"type":"html","content":"<span class='clj-string'>&quot;000290622000130&quot;</span>","value":"\"000290622000130\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2008-01-02&quot;</span>","value":"\"2008-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;GESTIONI&quot;</span>","value":"\"GESTIONI\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS POPOLI)\" \"9999-12-31\" \"01397530682\" \"000290622000130\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;CAMERA DI COMMERCIO INDUSTRIA , ARTIGIANATO E AGRICOLTURA DI PESCARA&quot;</span>","value":"\"CAMERA DI COMMERCIO INDUSTRIA , ARTIGIANATO E AGRICOLTURA DI PESCARA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;80000750689&quot;</span>","value":"\"80000750689\""},{"type":"html","content":"<span class='clj-string'>&quot;000699222&quot;</span>","value":"\"000699222\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2012-01-01&quot;</span>","value":"\"2012-01-01\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;CAM_COMMERCIO&quot;</span>","value":"\"CAM_COMMERCIO\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"CAMERA DI COMMERCIO INDUSTRIA , ARTIGIANATO E AGRICOLTURA DI PESCARA\" \"9999-12-31\" \"80000750689\" \"000699222\" \"028\" \"2012-01-01\" \"\" \"CAM_COMMERCIO\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;AZIENDA SANITARIA LOCALE 3 PESCARA&quot;</span>","value":"\"AZIENDA SANITARIA LOCALE 3 PESCARA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;01397530682&quot;</span>","value":"\"01397530682\""},{"type":"html","content":"<span class='clj-string'>&quot;000290622000000&quot;</span>","value":"\"000290622000000\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2008-01-02&quot;</span>","value":"\"2008-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;ASL&quot;</span>","value":"\"ASL\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"AZIENDA SANITARIA LOCALE 3 PESCARA\" \"9999-12-31\" \"01397530682\" \"000290622000000\" \"028\" \"2008-01-02\" \"\" \"ASL\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;U.C. DELL&#x27;AREA URBANA CHIETI-PESCARA - UNICA&quot;</span>","value":"\"U.C. DELL'AREA URBANA CHIETI-PESCARA - UNICA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;91068850683&quot;</span>","value":"\"91068850683\""},{"type":"html","content":"<span class='clj-string'>&quot;020982537&quot;</span>","value":"\"020982537\""},{"type":"html","content":"<span class='clj-string'>&quot;008&quot;</span>","value":"\"008\""},{"type":"html","content":"<span class='clj-string'>&quot;2007-01-01&quot;</span>","value":"\"2007-01-01\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;UNIONE_COMUNI&quot;</span>","value":"\"UNIONE_COMUNI\""},{"type":"html","content":"<span class='clj-string'>&quot;069&quot;</span>","value":"\"069\""}],"value":"(\"U.C. DELL'AREA URBANA CHIETI-PESCARA - UNICA\" \"9999-12-31\" \"91068850683\" \"020982537\" \"008\" \"2007-01-01\" \"\" \"UNIONE_COMUNI\" \"069\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;AMMINISTRAZIONE PROVINCIALE DI PESCARA&quot;</span>","value":"\"AMMINISTRAZIONE PROVINCIALE DI PESCARA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;00212850689&quot;</span>","value":"\"00212850689\""},{"type":"html","content":"<span class='clj-string'>&quot;012540507&quot;</span>","value":"\"012540507\""},{"type":"html","content":"<span class='clj-string'>&quot;028&quot;</span>","value":"\"028\""},{"type":"html","content":"<span class='clj-string'>&quot;2006-01-02&quot;</span>","value":"\"2006-01-02\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;PROVINCIA&quot;</span>","value":"\"PROVINCIA\""},{"type":"html","content":"<span class='clj-string'>&quot;068&quot;</span>","value":"\"068\""}],"value":"(\"AMMINISTRAZIONE PROVINCIALE DI PESCARA\" \"9999-12-31\" \"00212850689\" \"012540507\" \"028\" \"2006-01-02\" \"\" \"PROVINCIA\" \"068\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"html","content":"<span class='clj-string'>&quot;CAMERA DI COMMERCIO INDUSTRIA ARTIGIANATO AGRICOLTURA CHIETI PESCARA&quot;</span>","value":"\"CAMERA DI COMMERCIO INDUSTRIA ARTIGIANATO AGRICOLTURA CHIETI PESCARA\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;02558590697&quot;</span>","value":"\"02558590697\""},{"type":"html","content":"<span class='clj-string'>&quot;030825229&quot;</span>","value":"\"030825229\""},{"type":"html","content":"<span class='clj-string'>&quot;022&quot;</span>","value":"\"022\""},{"type":"html","content":"<span class='clj-string'>&quot;9999-12-31&quot;</span>","value":"\"9999-12-31\""},{"type":"html","content":"<span class='clj-string'>&quot;&quot;</span>","value":"\"\""},{"type":"html","content":"<span class='clj-string'>&quot;CAM_COMMERCIO&quot;</span>","value":"\"CAM_COMMERCIO\""},{"type":"html","content":"<span class='clj-string'>&quot;069&quot;</span>","value":"\"069\""}],"value":"(\"CAMERA DI COMMERCIO INDUSTRIA ARTIGIANATO AGRICOLTURA CHIETI PESCARA\" \"9999-12-31\" \"02558590697\" \"030825229\" \"022\" \"9999-12-31\" \"\" \"CAM_COMMERCIO\" \"069\")"}],"value":"#gorilla_repl.table.TableView{:contents ((\"COMUNE DI PESCARA\" \"9999-12-31\" \"00124600685\" \"000016324\" \"028\" \"2006-01-02\" \"00121325\" \"COMUNE\" \"068\") (\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PESCARA)\" \"9999-12-31\" \"01397530682\" \"000290622000128\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\") (\"ASL DI PESCARA (GESTIONE STRALCIO 1980 E RETRO EX ULSS PESCARA)\" \"9999-12-31\" \"01397530682\" \"000290622000131\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\") (\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS PENNE)\" \"9999-12-31\" \"01397530682\" \"000290622000129\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\") (\"ASL DI PESCARA (GESTIONE LIQUIDATORIA EX ULSS POPOLI)\" \"9999-12-31\" \"01397530682\" \"000290622000130\" \"028\" \"2008-01-02\" \"\" \"GESTIONI\" \"068\") (\"CAMERA DI COMMERCIO INDUSTRIA , ARTIGIANATO E AGRICOLTURA DI PESCARA\" \"9999-12-31\" \"80000750689\" \"000699222\" \"028\" \"2012-01-01\" \"\" \"CAM_COMMERCIO\" \"068\") (\"AZIENDA SANITARIA LOCALE 3 PESCARA\" \"9999-12-31\" \"01397530682\" \"000290622000000\" \"028\" \"2008-01-02\" \"\" \"ASL\" \"068\") (\"U.C. DELL'AREA URBANA CHIETI-PESCARA - UNICA\" \"9999-12-31\" \"91068850683\" \"020982537\" \"008\" \"2007-01-01\" \"\" \"UNIONE_COMUNI\" \"069\") (\"AMMINISTRAZIONE PROVINCIALE DI PESCARA\" \"9999-12-31\" \"00212850689\" \"012540507\" \"028\" \"2006-01-02\" \"\" \"PROVINCIA\" \"068\") (\"CAMERA DI COMMERCIO INDUSTRIA ARTIGIANATO AGRICOLTURA CHIETI PESCARA\" \"9999-12-31\" \"02558590697\" \"030825229\" \"022\" \"9999-12-31\" \"\" \"CAM_COMMERCIO\" \"069\")), :opts (:columns (:nome :scadenza :pos4 :codice :pos6 :creazione :popolazione :tipo :pos7))}"}
;; <=

;; @@
;; qui contatta soldipubblici.gov.it per raccogliere i dati desiderati
(def dati (raccogli-dati "PRO" "000016324" "Comune di Pescara"))
;; con un po' di LISP in piu' qui' e' anche possibile aggregare piu' dati assieme
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;fxc-soldipubblici.core/dati</span>","value":"#'fxc-soldipubblici.core/dati"}
;; <=

;; @@
;; qui analizziamo i dati convertendo i valori numerici
;; questo passo e' necessario per utilizzare i dati raccolti in grafici e quant'altro
(def rilievo (analizza-dati dati))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;fxc-soldipubblici.core/rilievo</span>","value":"#'fxc-soldipubblici.core/rilievo"}
;; <=

;; @@
;; qui usiamo due nuove funzioni:
;; (ordina-analisi condizione dati) usa `condizione` per ordinare ed escludere in base ad un campo
;;                                  aggiunge anche una stringa piu' leggibile agli importi
;; (visualizza-tavola rilievo) semplicemente formatta la tavola in modo da renderla piu' leggibile
(let [interessante   (ordina-analisi {:2015 [> 100000]} rilievo)]
       (visualizza-tavola interessante))
;; qui vogliamo la lista di tutti gli importi ordinati per 2015 e maggiori di 100k
;; @@
;; =>
;;; {"type":"list-like","open":"<center><table>","close":"</table></center>","separator":"\n","items":[{"type":"list-like","open":"<tr><th>","close":"</th></tr>","separator":"</th><th>","items":[{"type":"html","content":"<span class='clj-keyword'>:2016</span>","value":":2016"},{"type":"html","content":"<span class='clj-keyword'>:2015</span>","value":":2015"},{"type":"html","content":"<span class='clj-keyword'>:2014</span>","value":":2014"},{"type":"html","content":"<span class='clj-keyword'>:siope</span>","value":":siope"},{"type":"html","content":"<span class='clj-keyword'>:desc</span>","value":":desc"}],"value":"(:2016 :2015 :2014 :siope :desc)"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>133165276</span>","value":"133165276"},{"type":"html","content":"<span class='clj-string'>&quot;133.2 million&quot;</span>","value":"\"133.2 million\""}],"value":"[133165276 \"133.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>85276623</span>","value":"85276623"},{"type":"html","content":"<span class='clj-string'>&quot;85.3 million&quot;</span>","value":"\"85.3 million\""}],"value":"[85276623 \"85.3 million\"]"},{"type":"html","content":"<span class='clj-long'>3101</span>","value":"3101"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborso anticipazioni di cassa&quot;</span>","value":"\"Rimborso anticipazioni di cassa\""}],"value":"([0 \"zero\"] [133165276 \"133.2 million\"] [85276623 \"85.3 million\"] 3101 \"Rimborso anticipazioni di cassa\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>4869893</span>","value":"4869893"},{"type":"html","content":"<span class='clj-string'>&quot;4.9 million&quot;</span>","value":"\"4.9 million\""}],"value":"[4869893 \"4.9 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>27365173</span>","value":"27365173"},{"type":"html","content":"<span class='clj-string'>&quot;27.4 million&quot;</span>","value":"\"27.4 million\""}],"value":"[27365173 \"27.4 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>35085279</span>","value":"35085279"},{"type":"html","content":"<span class='clj-string'>&quot;35.1 million&quot;</span>","value":"\"35.1 million\""}],"value":"[35085279 \"35.1 million\"]"},{"type":"html","content":"<span class='clj-long'>1303</span>","value":"1303"},{"type":"html","content":"<span class='clj-string'>&quot;Contratti di servizio per smaltimento rifiuti&quot;</span>","value":"\"Contratti di servizio per smaltimento rifiuti\""}],"value":"([4869893 \"4.9 million\"] [27365173 \"27.4 million\"] [35085279 \"35.1 million\"] 1303 \"Contratti di servizio per smaltimento rifiuti\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>7545300</span>","value":"7545300"},{"type":"html","content":"<span class='clj-string'>&quot;7.5 million&quot;</span>","value":"\"7.5 million\""}],"value":"[7545300 \"7.5 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>19349104</span>","value":"19349104"},{"type":"html","content":"<span class='clj-string'>&quot;19.3 million&quot;</span>","value":"\"19.3 million\""}],"value":"[19349104 \"19.3 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>19708165</span>","value":"19708165"},{"type":"html","content":"<span class='clj-string'>&quot;19.7 million&quot;</span>","value":"\"19.7 million\""}],"value":"[19708165 \"19.7 million\"]"},{"type":"html","content":"<span class='clj-long'>1101</span>","value":"1101"},{"type":"html","content":"<span class='clj-string'>&quot;Competenze fisse per il personale a tempo indeterminato&quot;</span>","value":"\"Competenze fisse per il personale a tempo indeterminato\""}],"value":"([7545300 \"7.5 million\"] [19349104 \"19.3 million\"] [19708165 \"19.7 million\"] 1101 \"Competenze fisse per il personale a tempo indeterminato\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6113806</span>","value":"6113806"},{"type":"html","content":"<span class='clj-string'>&quot;6.1 million&quot;</span>","value":"\"6.1 million\""}],"value":"[6113806 \"6.1 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>12308306</span>","value":"12308306"},{"type":"html","content":"<span class='clj-string'>&quot;12.3 million&quot;</span>","value":"\"12.3 million\""}],"value":"[12308306 \"12.3 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>11428189</span>","value":"11428189"},{"type":"html","content":"<span class='clj-string'>&quot;11.4 million&quot;</span>","value":"\"11.4 million\""}],"value":"[11428189 \"11.4 million\"]"},{"type":"html","content":"<span class='clj-long'>2108</span>","value":"2108"},{"type":"html","content":"<span class='clj-string'>&quot;Opere per la sistemazione del suolo&quot;</span>","value":"\"Opere per la sistemazione del suolo\""}],"value":"([6113806 \"6.1 million\"] [12308306 \"12.3 million\"] [11428189 \"11.4 million\"] 2108 \"Opere per la sistemazione del suolo\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>546559</span>","value":"546559"},{"type":"html","content":"<span class='clj-string'>&quot;546559.0&quot;</span>","value":"\"546559.0\""}],"value":"[546559 \"546559.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>8996734</span>","value":"8996734"},{"type":"html","content":"<span class='clj-string'>&quot;9.0 million&quot;</span>","value":"\"9.0 million\""}],"value":"[8996734 \"9.0 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6859493</span>","value":"6859493"},{"type":"html","content":"<span class='clj-string'>&quot;6.9 million&quot;</span>","value":"\"6.9 million\""}],"value":"[6859493 \"6.9 million\"]"},{"type":"html","content":"<span class='clj-long'>1332</span>","value":"1332"},{"type":"html","content":"<span class='clj-string'>&quot;Altre spese per servizi&quot;</span>","value":"\"Altre spese per servizi\""}],"value":"([546559 \"546559.0\"] [8996734 \"9.0 million\"] [6859493 \"6.9 million\"] 1332 \"Altre spese per servizi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2009416</span>","value":"2009416"},{"type":"html","content":"<span class='clj-string'>&quot;2.0 million&quot;</span>","value":"\"2.0 million\""}],"value":"[2009416 \"2.0 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>7585789</span>","value":"7585789"},{"type":"html","content":"<span class='clj-string'>&quot;7.6 million&quot;</span>","value":"\"7.6 million\""}],"value":"[7585789 \"7.6 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>4815155</span>","value":"4815155"},{"type":"html","content":"<span class='clj-string'>&quot;4.8 million&quot;</span>","value":"\"4.8 million\""}],"value":"[4815155 \"4.8 million\"]"},{"type":"html","content":"<span class='clj-long'>1306</span>","value":"1306"},{"type":"html","content":"<span class='clj-string'>&quot;Altri contratti di servizio&quot;</span>","value":"\"Altri contratti di servizio\""}],"value":"([2009416 \"2.0 million\"] [7585789 \"7.6 million\"] [4815155 \"4.8 million\"] 1306 \"Altri contratti di servizio\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2048254</span>","value":"2048254"},{"type":"html","content":"<span class='clj-string'>&quot;2.0 million&quot;</span>","value":"\"2.0 million\""}],"value":"[2048254 \"2.0 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6507892</span>","value":"6507892"},{"type":"html","content":"<span class='clj-string'>&quot;6.5 million&quot;</span>","value":"\"6.5 million\""}],"value":"[6507892 \"6.5 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6818473</span>","value":"6818473"},{"type":"html","content":"<span class='clj-string'>&quot;6.8 million&quot;</span>","value":"\"6.8 million\""}],"value":"[6818473 \"6.8 million\"]"},{"type":"html","content":"<span class='clj-long'>1602</span>","value":"1602"},{"type":"html","content":"<span class='clj-string'>&quot; Interessi passivi a Cassa depositi e prestiti - gestione CDP spa&quot;</span>","value":"\" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\""}],"value":"([2048254 \"2.0 million\"] [6507892 \"6.5 million\"] [6818473 \"6.8 million\"] 1602 \" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3156639</span>","value":"3156639"},{"type":"html","content":"<span class='clj-string'>&quot;3.2 million&quot;</span>","value":"\"3.2 million\""}],"value":"[3156639 \"3.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6044042</span>","value":"6044042"},{"type":"html","content":"<span class='clj-string'>&quot;6.0 million&quot;</span>","value":"\"6.0 million\""}],"value":"[6044042 \"6.0 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>6329841</span>","value":"6329841"},{"type":"html","content":"<span class='clj-string'>&quot;6.3 million&quot;</span>","value":"\"6.3 million\""}],"value":"[6329841 \"6.3 million\"]"},{"type":"html","content":"<span class='clj-long'>1111</span>","value":"1111"},{"type":"html","content":"<span class='clj-string'>&quot;Contributi obbligatori per il personale&quot;</span>","value":"\"Contributi obbligatori per il personale\""}],"value":"([3156639 \"3.2 million\"] [6044042 \"6.0 million\"] [6329841 \"6.3 million\"] 1111 \"Contributi obbligatori per il personale\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1598050</span>","value":"1598050"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1598050 \"1.6 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>5048794</span>","value":"5048794"},{"type":"html","content":"<span class='clj-string'>&quot;5.0 million&quot;</span>","value":"\"5.0 million\""}],"value":"[5048794 \"5.0 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>682963</span>","value":"682963"},{"type":"html","content":"<span class='clj-string'>&quot;682963.0&quot;</span>","value":"\"682963.0\""}],"value":"[682963 \"682963.0\"]"},{"type":"html","content":"<span class='clj-long'>4503</span>","value":"4503"},{"type":"html","content":"<span class='clj-string'>&quot;Altre spese per servizi per conto di terzi&quot;</span>","value":"\"Altre spese per servizi per conto di terzi\""}],"value":"([1598050 \"1.6 million\"] [5048794 \"5.0 million\"] [682963 \"682963.0\"] 4503 \"Altre spese per servizi per conto di terzi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1904201</span>","value":"1904201"},{"type":"html","content":"<span class='clj-string'>&quot;1.9 million&quot;</span>","value":"\"1.9 million\""}],"value":"[1904201 \"1.9 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3801374</span>","value":"3801374"},{"type":"html","content":"<span class='clj-string'>&quot;3.8 million&quot;</span>","value":"\"3.8 million\""}],"value":"[3801374 \"3.8 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>4696817</span>","value":"4696817"},{"type":"html","content":"<span class='clj-string'>&quot;4.7 million&quot;</span>","value":"\"4.7 million\""}],"value":"[4696817 \"4.7 million\"]"},{"type":"html","content":"<span class='clj-long'>1552</span>","value":"1552"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti correnti ad altre imprese di pubblici servizi&quot;</span>","value":"\"Trasferimenti correnti ad altre imprese di pubblici servizi\""}],"value":"([1904201 \"1.9 million\"] [3801374 \"3.8 million\"] [4696817 \"4.7 million\"] 1552 \"Trasferimenti correnti ad altre imprese di pubblici servizi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2123055</span>","value":"2123055"},{"type":"html","content":"<span class='clj-string'>&quot;2.1 million&quot;</span>","value":"\"2.1 million\""}],"value":"[2123055 \"2.1 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3603957</span>","value":"3603957"},{"type":"html","content":"<span class='clj-string'>&quot;3.6 million&quot;</span>","value":"\"3.6 million\""}],"value":"[3603957 \"3.6 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>4347843</span>","value":"4347843"},{"type":"html","content":"<span class='clj-string'>&quot;4.3 million&quot;</span>","value":"\"4.3 million\""}],"value":"[4347843 \"4.3 million\"]"},{"type":"html","content":"<span class='clj-long'>4201</span>","value":"4201"},{"type":"html","content":"<span class='clj-string'>&quot;Ritenute erariali&quot;</span>","value":"\"Ritenute erariali\""}],"value":"([2123055 \"2.1 million\"] [3603957 \"3.6 million\"] [4347843 \"4.3 million\"] 4201 \"Ritenute erariali\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3360672</span>","value":"3360672"},{"type":"html","content":"<span class='clj-string'>&quot;3.4 million&quot;</span>","value":"\"3.4 million\""}],"value":"[3360672 \"3.4 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>8167483</span>","value":"8167483"},{"type":"html","content":"<span class='clj-string'>&quot;8.2 million&quot;</span>","value":"\"8.2 million\""}],"value":"[8167483 \"8.2 million\"]"},{"type":"html","content":"<span class='clj-long'>3302</span>","value":"3302"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa&quot;</span>","value":"\"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\""}],"value":"([0 \"zero\"] [3360672 \"3.4 million\"] [8167483 \"8.2 million\"] 3302 \"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>362212</span>","value":"362212"},{"type":"html","content":"<span class='clj-string'>&quot;362212.0&quot;</span>","value":"\"362212.0\""}],"value":"[362212 \"362212.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3349398</span>","value":"3349398"},{"type":"html","content":"<span class='clj-string'>&quot;3.3 million&quot;</span>","value":"\"3.3 million\""}],"value":"[3349398 \"3.3 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3615343</span>","value":"3615343"},{"type":"html","content":"<span class='clj-string'>&quot;3.6 million&quot;</span>","value":"\"3.6 million\""}],"value":"[3615343 \"3.6 million\"]"},{"type":"html","content":"<span class='clj-long'>1316</span>","value":"1316"},{"type":"html","content":"<span class='clj-string'>&quot;Utenze e canoni per energia elettrica&quot;</span>","value":"\"Utenze e canoni per energia elettrica\""}],"value":"([362212 \"362212.0\"] [3349398 \"3.3 million\"] [3615343 \"3.6 million\"] 1316 \"Utenze e canoni per energia elettrica\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1712341</span>","value":"1712341"},{"type":"html","content":"<span class='clj-string'>&quot;1.7 million&quot;</span>","value":"\"1.7 million\""}],"value":"[1712341 \"1.7 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3151229</span>","value":"3151229"},{"type":"html","content":"<span class='clj-string'>&quot;3.2 million&quot;</span>","value":"\"3.2 million\""}],"value":"[3151229 \"3.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>3037776</span>","value":"3037776"},{"type":"html","content":"<span class='clj-string'>&quot;3.0 million&quot;</span>","value":"\"3.0 million\""}],"value":"[3037776 \"3.0 million\"]"},{"type":"html","content":"<span class='clj-long'>3401</span>","value":"3401"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborso di BOC/BOP in euro&quot;</span>","value":"\"Rimborso di BOC/BOP in euro\""}],"value":"([1712341 \"1.7 million\"] [3151229 \"3.2 million\"] [3037776 \"3.0 million\"] 3401 \"Rimborso di BOC/BOP in euro\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>4996</span>","value":"4996"},{"type":"html","content":"<span class='clj-string'>&quot;4996.0&quot;</span>","value":"\"4996.0\""}],"value":"[4996 \"4996.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2847814</span>","value":"2847814"},{"type":"html","content":"<span class='clj-string'>&quot;2.8 million&quot;</span>","value":"\"2.8 million\""}],"value":"[2847814 \"2.8 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1620418</span>","value":"1620418"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1620418 \"1.6 million\"]"},{"type":"html","content":"<span class='clj-long'>1334</span>","value":"1334"},{"type":"html","content":"<span class='clj-string'>&quot;Mense scolastiche&quot;</span>","value":"\"Mense scolastiche\""}],"value":"([4996 \"4996.0\"] [2847814 \"2.8 million\"] [1620418 \"1.6 million\"] 1334 \"Mense scolastiche\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>430870</span>","value":"430870"},{"type":"html","content":"<span class='clj-string'>&quot;430870.0&quot;</span>","value":"\"430870.0\""}],"value":"[430870 \"430870.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2423415</span>","value":"2423415"},{"type":"html","content":"<span class='clj-string'>&quot;2.4 million&quot;</span>","value":"\"2.4 million\""}],"value":"[2423415 \"2.4 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1642020</span>","value":"1642020"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1642020 \"1.6 million\"]"},{"type":"html","content":"<span class='clj-long'>1583</span>","value":"1583"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti correnti ad altri&quot;</span>","value":"\"Trasferimenti correnti ad altri\""}],"value":"([430870 \"430870.0\"] [2423415 \"2.4 million\"] [1642020 \"1.6 million\"] 1583 \"Trasferimenti correnti ad altri\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1209522</span>","value":"1209522"},{"type":"html","content":"<span class='clj-string'>&quot;1.2 million&quot;</span>","value":"\"1.2 million\""}],"value":"[1209522 \"1.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2241028</span>","value":"2241028"},{"type":"html","content":"<span class='clj-string'>&quot;2.2 million&quot;</span>","value":"\"2.2 million\""}],"value":"[2241028 \"2.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2466736</span>","value":"2466736"},{"type":"html","content":"<span class='clj-string'>&quot;2.5 million&quot;</span>","value":"\"2.5 million\""}],"value":"[2466736 \"2.5 million\"]"},{"type":"html","content":"<span class='clj-long'>4101</span>","value":"4101"},{"type":"html","content":"<span class='clj-string'>&quot;Ritenute previdenziali e assistenziali al personale&quot;</span>","value":"\"Ritenute previdenziali e assistenziali al personale\""}],"value":"([1209522 \"1.2 million\"] [2241028 \"2.2 million\"] [2466736 \"2.5 million\"] 4101 \"Ritenute previdenziali e assistenziali al personale\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1649578</span>","value":"1649578"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1649578 \"1.6 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1928964</span>","value":"1928964"},{"type":"html","content":"<span class='clj-string'>&quot;1.9 million&quot;</span>","value":"\"1.9 million\""}],"value":"[1928964 \"1.9 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1783453</span>","value":"1783453"},{"type":"html","content":"<span class='clj-string'>&quot;1.8 million&quot;</span>","value":"\"1.8 million\""}],"value":"[1783453 \"1.8 million\"]"},{"type":"html","content":"<span class='clj-long'>1323</span>","value":"1323"},{"type":"html","content":"<span class='clj-string'>&quot;Assicurazioni&quot;</span>","value":"\"Assicurazioni\""}],"value":"([1649578 \"1.6 million\"] [1928964 \"1.9 million\"] [1783453 \"1.8 million\"] 1323 \"Assicurazioni\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>597968</span>","value":"597968"},{"type":"html","content":"<span class='clj-string'>&quot;597968.0&quot;</span>","value":"\"597968.0\""}],"value":"[597968 \"597968.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1701936</span>","value":"1701936"},{"type":"html","content":"<span class='clj-string'>&quot;1.7 million&quot;</span>","value":"\"1.7 million\""}],"value":"[1701936 \"1.7 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1668864</span>","value":"1668864"},{"type":"html","content":"<span class='clj-string'>&quot;1.7 million&quot;</span>","value":"\"1.7 million\""}],"value":"[1668864 \"1.7 million\"]"},{"type":"html","content":"<span class='clj-long'>2109</span>","value":"2109"},{"type":"html","content":"<span class='clj-string'>&quot;Fabbricati civili ad uso abitativo, commerciale e istituzionale&quot;</span>","value":"\"Fabbricati civili ad uso abitativo, commerciale e istituzionale\""}],"value":"([597968 \"597968.0\"] [1701936 \"1.7 million\"] [1668864 \"1.7 million\"] 2109 \"Fabbricati civili ad uso abitativo, commerciale e istituzionale\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>798752</span>","value":"798752"},{"type":"html","content":"<span class='clj-string'>&quot;798752.0&quot;</span>","value":"\"798752.0\""}],"value":"[798752 \"798752.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1571861</span>","value":"1571861"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1571861 \"1.6 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1594209</span>","value":"1594209"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1594209 \"1.6 million\"]"},{"type":"html","content":"<span class='clj-long'>1802</span>","value":"1802"},{"type":"html","content":"<span class='clj-string'>&quot;Altri oneri  straordinari della gestione corrente&quot;</span>","value":"\"Altri oneri  straordinari della gestione corrente\""}],"value":"([798752 \"798752.0\"] [1571861 \"1.6 million\"] [1594209 \"1.6 million\"] 1802 \"Altri oneri  straordinari della gestione corrente\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>206806</span>","value":"206806"},{"type":"html","content":"<span class='clj-string'>&quot;206806.0&quot;</span>","value":"\"206806.0\""}],"value":"[206806 \"206806.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1547520</span>","value":"1547520"},{"type":"html","content":"<span class='clj-string'>&quot;1.5 million&quot;</span>","value":"\"1.5 million\""}],"value":"[1547520 \"1.5 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1056010</span>","value":"1056010"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1056010 \"1.1 million\"]"},{"type":"html","content":"<span class='clj-long'>1311</span>","value":"1311"},{"type":"html","content":"<span class='clj-string'>&quot;Manutenzione ordinaria e riparazioni di immobili&quot;</span>","value":"\"Manutenzione ordinaria e riparazioni di immobili\""}],"value":"([206806 \"206806.0\"] [1547520 \"1.5 million\"] [1056010 \"1.1 million\"] 1311 \"Manutenzione ordinaria e riparazioni di immobili\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>827387</span>","value":"827387"},{"type":"html","content":"<span class='clj-string'>&quot;827387.0&quot;</span>","value":"\"827387.0\""}],"value":"[827387 \"827387.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1536314</span>","value":"1536314"},{"type":"html","content":"<span class='clj-string'>&quot;1.5 million&quot;</span>","value":"\"1.5 million\""}],"value":"[1536314 \"1.5 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1645767</span>","value":"1645767"},{"type":"html","content":"<span class='clj-string'>&quot;1.6 million&quot;</span>","value":"\"1.6 million\""}],"value":"[1645767 \"1.6 million\"]"},{"type":"html","content":"<span class='clj-long'>1701</span>","value":"1701"},{"type":"html","content":"<span class='clj-string'>&quot;IRAP&quot;</span>","value":"\"IRAP\""}],"value":"([827387 \"827387.0\"] [1536314 \"1.5 million\"] [1645767 \"1.6 million\"] 1701 \"IRAP\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>259602</span>","value":"259602"},{"type":"html","content":"<span class='clj-string'>&quot;259602.0&quot;</span>","value":"\"259602.0\""}],"value":"[259602 \"259602.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1437841</span>","value":"1437841"},{"type":"html","content":"<span class='clj-string'>&quot;1.4 million&quot;</span>","value":"\"1.4 million\""}],"value":"[1437841 \"1.4 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>397103</span>","value":"397103"},{"type":"html","content":"<span class='clj-string'>&quot;397103.0&quot;</span>","value":"\"397103.0\""}],"value":"[397103 \"397103.0\"]"},{"type":"html","content":"<span class='clj-long'>1308</span>","value":"1308"},{"type":"html","content":"<span class='clj-string'>&quot;Organizzazione manifestazioni e convegni&quot;</span>","value":"\"Organizzazione manifestazioni e convegni\""}],"value":"([259602 \"259602.0\"] [1437841 \"1.4 million\"] [397103 \"397103.0\"] 1308 \"Organizzazione manifestazioni e convegni\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>372278</span>","value":"372278"},{"type":"html","content":"<span class='clj-string'>&quot;372278.0&quot;</span>","value":"\"372278.0\""}],"value":"[372278 \"372278.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1376746</span>","value":"1376746"},{"type":"html","content":"<span class='clj-string'>&quot;1.4 million&quot;</span>","value":"\"1.4 million\""}],"value":"[1376746 \"1.4 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>839000</span>","value":"839000"},{"type":"html","content":"<span class='clj-string'>&quot;839000.0&quot;</span>","value":"\"839000.0\""}],"value":"[839000 \"839000.0\"]"},{"type":"html","content":"<span class='clj-long'>2107</span>","value":"2107"},{"type":"html","content":"<span class='clj-string'>&quot;Altre infrastrutture&quot;</span>","value":"\"Altre infrastrutture\""}],"value":"([372278 \"372278.0\"] [1376746 \"1.4 million\"] [839000 \"839000.0\"] 2107 \"Altre infrastrutture\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>774810</span>","value":"774810"},{"type":"html","content":"<span class='clj-string'>&quot;774810.0&quot;</span>","value":"\"774810.0\""}],"value":"[774810 \"774810.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1226070</span>","value":"1226070"},{"type":"html","content":"<span class='clj-string'>&quot;1.2 million&quot;</span>","value":"\"1.2 million\""}],"value":"[1226070 \"1.2 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2021073</span>","value":"2021073"},{"type":"html","content":"<span class='clj-string'>&quot;2.0 million&quot;</span>","value":"\"2.0 million\""}],"value":"[2021073 \"2.0 million\"]"},{"type":"html","content":"<span class='clj-long'>1103</span>","value":"1103"},{"type":"html","content":"<span class='clj-string'>&quot;Altre competenze ed indennità accessorie per il personale a tempo indeterminato&quot;</span>","value":"\"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\""}],"value":"([774810 \"774810.0\"] [1226070 \"1.2 million\"] [2021073 \"2.0 million\"] 1103 \"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>466338</span>","value":"466338"},{"type":"html","content":"<span class='clj-string'>&quot;466338.0&quot;</span>","value":"\"466338.0\""}],"value":"[466338 \"466338.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1113640</span>","value":"1113640"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1113640 \"1.1 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>974441</span>","value":"974441"},{"type":"html","content":"<span class='clj-string'>&quot;974441.0&quot;</span>","value":"\"974441.0\""}],"value":"[974441 \"974441.0\"]"},{"type":"html","content":"<span class='clj-long'>4301</span>","value":"4301"},{"type":"html","content":"<span class='clj-string'>&quot;Altre ritenute al personale per conto di terzi&quot;</span>","value":"\"Altre ritenute al personale per conto di terzi\""}],"value":"([466338 \"466338.0\"] [1113640 \"1.1 million\"] [974441 \"974441.0\"] 4301 \"Altre ritenute al personale per conto di terzi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>579593</span>","value":"579593"},{"type":"html","content":"<span class='clj-string'>&quot;579593.0&quot;</span>","value":"\"579593.0\""}],"value":"[579593 \"579593.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1098115</span>","value":"1098115"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1098115 \"1.1 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1124897</span>","value":"1124897"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1124897 \"1.1 million\"]"},{"type":"html","content":"<span class='clj-long'>1325</span>","value":"1325"},{"type":"html","content":"<span class='clj-string'>&quot;Spese per gli organi istituzionali dell&#x27;ente - Indennità&quot;</span>","value":"\"Spese per gli organi istituzionali dell'ente - Indennità\""}],"value":"([579593 \"579593.0\"] [1098115 \"1.1 million\"] [1124897 \"1.1 million\"] 1325 \"Spese per gli organi istituzionali dell'ente - Indennità\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>794748</span>","value":"794748"},{"type":"html","content":"<span class='clj-string'>&quot;794748.0&quot;</span>","value":"\"794748.0\""}],"value":"[794748 \"794748.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1078700</span>","value":"1078700"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1078700 \"1.1 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>584976</span>","value":"584976"},{"type":"html","content":"<span class='clj-string'>&quot;584976.0&quot;</span>","value":"\"584976.0\""}],"value":"[584976 \"584976.0\"]"},{"type":"html","content":"<span class='clj-long'>1581</span>","value":"1581"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti correnti a famiglie&quot;</span>","value":"\"Trasferimenti correnti a famiglie\""}],"value":"([794748 \"794748.0\"] [1078700 \"1.1 million\"] [584976 \"584976.0\"] 1581 \"Trasferimenti correnti a famiglie\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1318100</span>","value":"1318100"},{"type":"html","content":"<span class='clj-string'>&quot;1.3 million&quot;</span>","value":"\"1.3 million\""}],"value":"[1318100 \"1.3 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>971973</span>","value":"971973"},{"type":"html","content":"<span class='clj-string'>&quot;971973.0&quot;</span>","value":"\"971973.0\""}],"value":"[971973 \"971973.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>279372</span>","value":"279372"},{"type":"html","content":"<span class='clj-string'>&quot;279372.0&quot;</span>","value":"\"279372.0\""}],"value":"[279372 \"279372.0\"]"},{"type":"html","content":"<span class='clj-long'>3311</span>","value":"3311"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborso mutui e prestiti ad enti del settore pubblico&quot;</span>","value":"\"Rimborso mutui e prestiti ad enti del settore pubblico\""}],"value":"([1318100 \"1.3 million\"] [971973 \"971973.0\"] [279372 \"279372.0\"] 3311 \"Rimborso mutui e prestiti ad enti del settore pubblico\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>403637</span>","value":"403637"},{"type":"html","content":"<span class='clj-string'>&quot;403637.0&quot;</span>","value":"\"403637.0\""}],"value":"[403637 \"403637.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>891619</span>","value":"891619"},{"type":"html","content":"<span class='clj-string'>&quot;891619.0&quot;</span>","value":"\"891619.0\""}],"value":"[891619 \"891619.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>866878</span>","value":"866878"},{"type":"html","content":"<span class='clj-string'>&quot;866878.0&quot;</span>","value":"\"866878.0\""}],"value":"[866878 \"866878.0\"]"},{"type":"html","content":"<span class='clj-long'>1211</span>","value":"1211"},{"type":"html","content":"<span class='clj-string'>&quot;Acquisto di derrate alimentari&quot;</span>","value":"\"Acquisto di derrate alimentari\""}],"value":"([403637 \"403637.0\"] [891619 \"891619.0\"] [866878 \"866878.0\"] 1211 \"Acquisto di derrate alimentari\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2543819</span>","value":"2543819"},{"type":"html","content":"<span class='clj-string'>&quot;2.5 million&quot;</span>","value":"\"2.5 million\""}],"value":"[2543819 \"2.5 million\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>883392</span>","value":"883392"},{"type":"html","content":"<span class='clj-string'>&quot;883392.0&quot;</span>","value":"\"883392.0\""}],"value":"[883392 \"883392.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>836041</span>","value":"836041"},{"type":"html","content":"<span class='clj-string'>&quot;836041.0&quot;</span>","value":"\"836041.0\""}],"value":"[836041 \"836041.0\"]"},{"type":"html","content":"<span class='clj-long'>2116</span>","value":"2116"},{"type":"html","content":"<span class='clj-string'>&quot;Altri beni immobili&quot;</span>","value":"\"Altri beni immobili\""}],"value":"([2543819 \"2.5 million\"] [883392 \"883392.0\"] [836041 \"836041.0\"] 2116 \"Altri beni immobili\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>581942</span>","value":"581942"},{"type":"html","content":"<span class='clj-string'>&quot;581942.0&quot;</span>","value":"\"581942.0\""}],"value":"[581942 \"581942.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>880481</span>","value":"880481"},{"type":"html","content":"<span class='clj-string'>&quot;880481.0&quot;</span>","value":"\"880481.0\""}],"value":"[880481 \"880481.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>441509</span>","value":"441509"},{"type":"html","content":"<span class='clj-string'>&quot;441509.0&quot;</span>","value":"\"441509.0\""}],"value":"[441509 \"441509.0\"]"},{"type":"html","content":"<span class='clj-long'>2115</span>","value":"2115"},{"type":"html","content":"<span class='clj-string'>&quot;Impianti sportivi&quot;</span>","value":"\"Impianti sportivi\""}],"value":"([581942 \"581942.0\"] [880481 \"880481.0\"] [441509 \"441509.0\"] 2115 \"Impianti sportivi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>839700</span>","value":"839700"},{"type":"html","content":"<span class='clj-string'>&quot;839700.0&quot;</span>","value":"\"839700.0\""}],"value":"[839700 \"839700.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>5241</span>","value":"5241"},{"type":"html","content":"<span class='clj-string'>&quot;5241.0&quot;</span>","value":"\"5241.0\""}],"value":"[5241 \"5241.0\"]"},{"type":"html","content":"<span class='clj-long'>2902</span>","value":"2902"},{"type":"html","content":"<span class='clj-string'>&quot; Conferimenti di capitali in altre imprese&quot;</span>","value":"\" Conferimenti di capitali in altre imprese\""}],"value":"([0 \"zero\"] [839700 \"839700.0\"] [5241 \"5241.0\"] 2902 \" Conferimenti di capitali in altre imprese\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>717726</span>","value":"717726"},{"type":"html","content":"<span class='clj-string'>&quot;717726.0&quot;</span>","value":"\"717726.0\""}],"value":"[717726 \"717726.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>777010</span>","value":"777010"},{"type":"html","content":"<span class='clj-string'>&quot;777010.0&quot;</span>","value":"\"777010.0\""}],"value":"[777010 \"777010.0\"]"},{"type":"html","content":"<span class='clj-long'>1302</span>","value":"1302"},{"type":"html","content":"<span class='clj-string'>&quot;Contratti di servizio per trasporto&quot;</span>","value":"\"Contratti di servizio per trasporto\""}],"value":"([0 \"zero\"] [717726 \"717726.0\"] [777010 \"777010.0\"] 1302 \"Contratti di servizio per trasporto\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>247890</span>","value":"247890"},{"type":"html","content":"<span class='clj-string'>&quot;247890.0&quot;</span>","value":"\"247890.0\""}],"value":"[247890 \"247890.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>592307</span>","value":"592307"},{"type":"html","content":"<span class='clj-string'>&quot;592307.0&quot;</span>","value":"\"592307.0\""}],"value":"[592307 \"592307.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1150043</span>","value":"1150043"},{"type":"html","content":"<span class='clj-string'>&quot;1.2 million&quot;</span>","value":"\"1.2 million\""}],"value":"[1150043 \"1.2 million\"]"},{"type":"html","content":"<span class='clj-long'>1314</span>","value":"1314"},{"type":"html","content":"<span class='clj-string'>&quot;Servizi ausiliari e spese di pulizia&quot;</span>","value":"\"Servizi ausiliari e spese di pulizia\""}],"value":"([247890 \"247890.0\"] [592307 \"592307.0\"] [1150043 \"1.2 million\"] 1314 \"Servizi ausiliari e spese di pulizia\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>40000</span>","value":"40000"},{"type":"html","content":"<span class='clj-string'>&quot;40000.0&quot;</span>","value":"\"40000.0\""}],"value":"[40000 \"40000.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>565634</span>","value":"565634"},{"type":"html","content":"<span class='clj-string'>&quot;565634.0&quot;</span>","value":"\"565634.0\""}],"value":"[565634 \"565634.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>940970</span>","value":"940970"},{"type":"html","content":"<span class='clj-string'>&quot;940970.0&quot;</span>","value":"\"940970.0\""}],"value":"[940970 \"940970.0\"]"},{"type":"html","content":"<span class='clj-long'>1569</span>","value":"1569"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti correnti a altri enti del settore pubblico&quot;</span>","value":"\"Trasferimenti correnti a altri enti del settore pubblico\""}],"value":"([40000 \"40000.0\"] [565634 \"565634.0\"] [940970 \"940970.0\"] 1569 \"Trasferimenti correnti a altri enti del settore pubblico\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>25160</span>","value":"25160"},{"type":"html","content":"<span class='clj-string'>&quot;25160.0&quot;</span>","value":"\"25160.0\""}],"value":"[25160 \"25160.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>560593</span>","value":"560593"},{"type":"html","content":"<span class='clj-string'>&quot;560593.0&quot;</span>","value":"\"560593.0\""}],"value":"[560593 \"560593.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1677442</span>","value":"1677442"},{"type":"html","content":"<span class='clj-string'>&quot;1.7 million&quot;</span>","value":"\"1.7 million\""}],"value":"[1677442 \"1.7 million\"]"},{"type":"html","content":"<span class='clj-long'>1318</span>","value":"1318"},{"type":"html","content":"<span class='clj-string'>&quot;Utenze e canoni per riscaldamento&quot;</span>","value":"\"Utenze e canoni per riscaldamento\""}],"value":"([25160 \"25160.0\"] [560593 \"560593.0\"] [1677442 \"1.7 million\"] 1318 \"Utenze e canoni per riscaldamento\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>101402</span>","value":"101402"},{"type":"html","content":"<span class='clj-string'>&quot;101402.0&quot;</span>","value":"\"101402.0\""}],"value":"[101402 \"101402.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>513791</span>","value":"513791"},{"type":"html","content":"<span class='clj-string'>&quot;513791.0&quot;</span>","value":"\"513791.0\""}],"value":"[513791 \"513791.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>488156</span>","value":"488156"},{"type":"html","content":"<span class='clj-string'>&quot;488156.0&quot;</span>","value":"\"488156.0\""}],"value":"[488156 \"488156.0\"]"},{"type":"html","content":"<span class='clj-long'>1210</span>","value":"1210"},{"type":"html","content":"<span class='clj-string'>&quot;Altri materiali di consumo&quot;</span>","value":"\"Altri materiali di consumo\""}],"value":"([101402 \"101402.0\"] [513791 \"513791.0\"] [488156 \"488156.0\"] 1210 \"Altri materiali di consumo\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>147727</span>","value":"147727"},{"type":"html","content":"<span class='clj-string'>&quot;147727.0&quot;</span>","value":"\"147727.0\""}],"value":"[147727 \"147727.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>479258</span>","value":"479258"},{"type":"html","content":"<span class='clj-string'>&quot;479258.0&quot;</span>","value":"\"479258.0\""}],"value":"[479258 \"479258.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>181851</span>","value":"181851"},{"type":"html","content":"<span class='clj-string'>&quot;181851.0&quot;</span>","value":"\"181851.0\""}],"value":"[181851 \"181851.0\"]"},{"type":"html","content":"<span class='clj-long'>2113</span>","value":"2113"},{"type":"html","content":"<span class='clj-string'>&quot;Beni di valore culturale, storico, archeologico, ed artistico&quot;</span>","value":"\"Beni di valore culturale, storico, archeologico, ed artistico\""}],"value":"([147727 \"147727.0\"] [479258 \"479258.0\"] [181851 \"181851.0\"] 2113 \"Beni di valore culturale, storico, archeologico, ed artistico\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>90942</span>","value":"90942"},{"type":"html","content":"<span class='clj-string'>&quot;90942.0&quot;</span>","value":"\"90942.0\""}],"value":"[90942 \"90942.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>427338</span>","value":"427338"},{"type":"html","content":"<span class='clj-string'>&quot;427338.0&quot;</span>","value":"\"427338.0\""}],"value":"[427338 \"427338.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>258238</span>","value":"258238"},{"type":"html","content":"<span class='clj-string'>&quot;258238.0&quot;</span>","value":"\"258238.0\""}],"value":"[258238 \"258238.0\"]"},{"type":"html","content":"<span class='clj-long'>1623</span>","value":"1623"},{"type":"html","content":"<span class='clj-string'>&quot;Interessi passivi ad altri soggetti per anticipazioni&quot;</span>","value":"\"Interessi passivi ad altri soggetti per anticipazioni\""}],"value":"([90942 \"90942.0\"] [427338 \"427338.0\"] [258238 \"258238.0\"] 1623 \"Interessi passivi ad altri soggetti per anticipazioni\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>400000</span>","value":"400000"},{"type":"html","content":"<span class='clj-string'>&quot;400000.0&quot;</span>","value":"\"400000.0\""}],"value":"[400000 \"400000.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"html","content":"<span class='clj-long'>2093</span>","value":"2093"},{"type":"html","content":"<span class='clj-string'>&quot;Concessione di crediti a Istituzioni sociali private&quot;</span>","value":"\"Concessione di crediti a Istituzioni sociali private\""}],"value":"([0 \"zero\"] [400000 \"400000.0\"] [0 \"zero\"] 2093 \"Concessione di crediti a Istituzioni sociali private\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>146778</span>","value":"146778"},{"type":"html","content":"<span class='clj-string'>&quot;146778.0&quot;</span>","value":"\"146778.0\""}],"value":"[146778 \"146778.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>391990</span>","value":"391990"},{"type":"html","content":"<span class='clj-string'>&quot;391990.0&quot;</span>","value":"\"391990.0\""}],"value":"[391990 \"391990.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>482923</span>","value":"482923"},{"type":"html","content":"<span class='clj-string'>&quot;482923.0&quot;</span>","value":"\"482923.0\""}],"value":"[482923 \"482923.0\"]"},{"type":"html","content":"<span class='clj-long'>1104</span>","value":"1104"},{"type":"html","content":"<span class='clj-string'>&quot;Competenze fisse ed accessorie per il personale a tempo determinato&quot;</span>","value":"\"Competenze fisse ed accessorie per il personale a tempo determinato\""}],"value":"([146778 \"146778.0\"] [391990 \"391990.0\"] [482923 \"482923.0\"] 1104 \"Competenze fisse ed accessorie per il personale a tempo determinato\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>402538</span>","value":"402538"},{"type":"html","content":"<span class='clj-string'>&quot;402538.0&quot;</span>","value":"\"402538.0\""}],"value":"[402538 \"402538.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>371188</span>","value":"371188"},{"type":"html","content":"<span class='clj-string'>&quot;371188.0&quot;</span>","value":"\"371188.0\""}],"value":"[371188 \"371188.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1064110</span>","value":"1064110"},{"type":"html","content":"<span class='clj-string'>&quot;1.1 million&quot;</span>","value":"\"1.1 million\""}],"value":"[1064110 \"1.1 million\"]"},{"type":"html","content":"<span class='clj-long'>2102</span>","value":"2102"},{"type":"html","content":"<span class='clj-string'>&quot;Vie di comunicazione ed infrastrutture connesse&quot;</span>","value":"\"Vie di comunicazione ed infrastrutture connesse\""}],"value":"([402538 \"402538.0\"] [371188 \"371188.0\"] [1064110 \"1.1 million\"] 2102 \"Vie di comunicazione ed infrastrutture connesse\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>39771</span>","value":"39771"},{"type":"html","content":"<span class='clj-string'>&quot;39771.0&quot;</span>","value":"\"39771.0\""}],"value":"[39771 \"39771.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>369602</span>","value":"369602"},{"type":"html","content":"<span class='clj-string'>&quot;369602.0&quot;</span>","value":"\"369602.0\""}],"value":"[369602 \"369602.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>110865</span>","value":"110865"},{"type":"html","content":"<span class='clj-string'>&quot;110865.0&quot;</span>","value":"\"110865.0\""}],"value":"[110865 \"110865.0\"]"},{"type":"html","content":"<span class='clj-long'>1106</span>","value":"1106"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborsi spese per personale comandato&quot;</span>","value":"\"Rimborsi spese per personale comandato\""}],"value":"([39771 \"39771.0\"] [369602 \"369602.0\"] [110865 \"110865.0\"] 1106 \"Rimborsi spese per personale comandato\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>210381</span>","value":"210381"},{"type":"html","content":"<span class='clj-string'>&quot;210381.0&quot;</span>","value":"\"210381.0\""}],"value":"[210381 \"210381.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>346201</span>","value":"346201"},{"type":"html","content":"<span class='clj-string'>&quot;346201.0&quot;</span>","value":"\"346201.0\""}],"value":"[346201 \"346201.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>436106</span>","value":"436106"},{"type":"html","content":"<span class='clj-string'>&quot;436106.0&quot;</span>","value":"\"436106.0\""}],"value":"[436106 \"436106.0\"]"},{"type":"html","content":"<span class='clj-long'>1327</span>","value":"1327"},{"type":"html","content":"<span class='clj-string'>&quot;Buoni pasto e mensa per il personale&quot;</span>","value":"\"Buoni pasto e mensa per il personale\""}],"value":"([210381 \"210381.0\"] [346201 \"346201.0\"] [436106 \"436106.0\"] 1327 \"Buoni pasto e mensa per il personale\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>343683</span>","value":"343683"},{"type":"html","content":"<span class='clj-string'>&quot;343683.0&quot;</span>","value":"\"343683.0\""}],"value":"[343683 \"343683.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>330920</span>","value":"330920"},{"type":"html","content":"<span class='clj-string'>&quot;330920.0&quot;</span>","value":"\"330920.0\""}],"value":"[330920 \"330920.0\"]"},{"type":"html","content":"<span class='clj-long'>3324</span>","value":"3324"},{"type":"html","content":"<span class='clj-string'>&quot;Rimborso mutui e prestiti ad altri - in euro&quot;</span>","value":"\"Rimborso mutui e prestiti ad altri - in euro\""}],"value":"([0 \"zero\"] [343683 \"343683.0\"] [330920 \"330920.0\"] 3324 \"Rimborso mutui e prestiti ad altri - in euro\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>49341</span>","value":"49341"},{"type":"html","content":"<span class='clj-string'>&quot;49341.0&quot;</span>","value":"\"49341.0\""}],"value":"[49341 \"49341.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>335374</span>","value":"335374"},{"type":"html","content":"<span class='clj-string'>&quot;335374.0&quot;</span>","value":"\"335374.0\""}],"value":"[335374 \"335374.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>264125</span>","value":"264125"},{"type":"html","content":"<span class='clj-string'>&quot;264125.0&quot;</span>","value":"\"264125.0\""}],"value":"[264125 \"264125.0\"]"},{"type":"html","content":"<span class='clj-long'>1313</span>","value":"1313"},{"type":"html","content":"<span class='clj-string'>&quot;Altre spese di manutenzione ordinaria e riparazioni&quot;</span>","value":"\"Altre spese di manutenzione ordinaria e riparazioni\""}],"value":"([49341 \"49341.0\"] [335374 \"335374.0\"] [264125 \"264125.0\"] 1313 \"Altre spese di manutenzione ordinaria e riparazioni\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>330610</span>","value":"330610"},{"type":"html","content":"<span class='clj-string'>&quot;330610.0&quot;</span>","value":"\"330610.0\""}],"value":"[330610 \"330610.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>313092</span>","value":"313092"},{"type":"html","content":"<span class='clj-string'>&quot;313092.0&quot;</span>","value":"\"313092.0\""}],"value":"[313092 \"313092.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>222855</span>","value":"222855"},{"type":"html","content":"<span class='clj-string'>&quot;222855.0&quot;</span>","value":"\"222855.0\""}],"value":"[222855 \"222855.0\"]"},{"type":"html","content":"<span class='clj-long'>2601</span>","value":"2601"},{"type":"html","content":"<span class='clj-string'>&quot;INCARICHI PROFESSIONALI ESTERNI&quot;</span>","value":"\"INCARICHI PROFESSIONALI ESTERNI\""}],"value":"([330610 \"330610.0\"] [313092 \"313092.0\"] [222855 \"222855.0\"] 2601 \"INCARICHI PROFESSIONALI ESTERNI\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>40347</span>","value":"40347"},{"type":"html","content":"<span class='clj-string'>&quot;40347.0&quot;</span>","value":"\"40347.0\""}],"value":"[40347 \"40347.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>263685</span>","value":"263685"},{"type":"html","content":"<span class='clj-string'>&quot;263685.0&quot;</span>","value":"\"263685.0\""}],"value":"[263685 \"263685.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>352503</span>","value":"352503"},{"type":"html","content":"<span class='clj-string'>&quot;352503.0&quot;</span>","value":"\"352503.0\""}],"value":"[352503 \"352503.0\"]"},{"type":"html","content":"<span class='clj-long'>1307</span>","value":"1307"},{"type":"html","content":"<span class='clj-string'>&quot;Incarichi professionali&quot;</span>","value":"\"Incarichi professionali\""}],"value":"([40347 \"40347.0\"] [263685 \"263685.0\"] [352503 \"352503.0\"] 1307 \"Incarichi professionali\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>35722</span>","value":"35722"},{"type":"html","content":"<span class='clj-string'>&quot;35722.0&quot;</span>","value":"\"35722.0\""}],"value":"[35722 \"35722.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>246081</span>","value":"246081"},{"type":"html","content":"<span class='clj-string'>&quot;246081.0&quot;</span>","value":"\"246081.0\""}],"value":"[246081 \"246081.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>234692</span>","value":"234692"},{"type":"html","content":"<span class='clj-string'>&quot;234692.0&quot;</span>","value":"\"234692.0\""}],"value":"[234692 \"234692.0\"]"},{"type":"html","content":"<span class='clj-long'>1331</span>","value":"1331"},{"type":"html","content":"<span class='clj-string'>&quot;Spese per liti (patrocinio legale)&quot;</span>","value":"\"Spese per liti (patrocinio legale)\""}],"value":"([35722 \"35722.0\"] [246081 \"246081.0\"] [234692 \"234692.0\"] 1331 \"Spese per liti (patrocinio legale)\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>97484</span>","value":"97484"},{"type":"html","content":"<span class='clj-string'>&quot;97484.0&quot;</span>","value":"\"97484.0\""}],"value":"[97484 \"97484.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>220476</span>","value":"220476"},{"type":"html","content":"<span class='clj-string'>&quot;220476.0&quot;</span>","value":"\"220476.0\""}],"value":"[220476 \"220476.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1457920</span>","value":"1457920"},{"type":"html","content":"<span class='clj-string'>&quot;1.5 million&quot;</span>","value":"\"1.5 million\""}],"value":"[1457920 \"1.5 million\"]"},{"type":"html","content":"<span class='clj-long'>1333</span>","value":"1333"},{"type":"html","content":"<span class='clj-string'>&quot;Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi&quot;</span>","value":"\"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\""}],"value":"([97484 \"97484.0\"] [220476 \"220476.0\"] [1457920 \"1.5 million\"] 1333 \"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1089</span>","value":"1089"},{"type":"html","content":"<span class='clj-string'>&quot;1089.0&quot;</span>","value":"\"1089.0\""}],"value":"[1089 \"1089.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>213139</span>","value":"213139"},{"type":"html","content":"<span class='clj-string'>&quot;213139.0&quot;</span>","value":"\"213139.0\""}],"value":"[213139 \"213139.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>170611</span>","value":"170611"},{"type":"html","content":"<span class='clj-string'>&quot;170611.0&quot;</span>","value":"\"170611.0\""}],"value":"[170611 \"170611.0\"]"},{"type":"html","content":"<span class='clj-long'>1112</span>","value":"1112"},{"type":"html","content":"<span class='clj-string'>&quot;Contributi previdenza complementare&quot;</span>","value":"\"Contributi previdenza complementare\""}],"value":"([1089 \"1089.0\"] [213139 \"213139.0\"] [170611 \"170611.0\"] 1112 \"Contributi previdenza complementare\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>149737</span>","value":"149737"},{"type":"html","content":"<span class='clj-string'>&quot;149737.0&quot;</span>","value":"\"149737.0\""}],"value":"[149737 \"149737.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>211803</span>","value":"211803"},{"type":"html","content":"<span class='clj-string'>&quot;211803.0&quot;</span>","value":"\"211803.0\""}],"value":"[211803 \"211803.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>561332</span>","value":"561332"},{"type":"html","content":"<span class='clj-string'>&quot;561332.0&quot;</span>","value":"\"561332.0\""}],"value":"[561332 \"561332.0\"]"},{"type":"html","content":"<span class='clj-long'>1315</span>","value":"1315"},{"type":"html","content":"<span class='clj-string'>&quot;Utenze e canoni per telefonia e reti di trasmissione&quot;</span>","value":"\"Utenze e canoni per telefonia e reti di trasmissione\""}],"value":"([149737 \"149737.0\"] [211803 \"211803.0\"] [561332 \"561332.0\"] 1315 \"Utenze e canoni per telefonia e reti di trasmissione\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>9600</span>","value":"9600"},{"type":"html","content":"<span class='clj-string'>&quot;9600.0&quot;</span>","value":"\"9600.0\""}],"value":"[9600 \"9600.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>207856</span>","value":"207856"},{"type":"html","content":"<span class='clj-string'>&quot;207856.0&quot;</span>","value":"\"207856.0\""}],"value":"[207856 \"207856.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"html","content":"<span class='clj-long'>2501</span>","value":"2501"},{"type":"html","content":"<span class='clj-string'>&quot;Mezzi di trasporto&quot;</span>","value":"\"Mezzi di trasporto\""}],"value":"([9600 \"9600.0\"] [207856 \"207856.0\"] [0 \"zero\"] 2501 \"Mezzi di trasporto\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>65316</span>","value":"65316"},{"type":"html","content":"<span class='clj-string'>&quot;65316.0&quot;</span>","value":"\"65316.0\""}],"value":"[65316 \"65316.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>206308</span>","value":"206308"},{"type":"html","content":"<span class='clj-string'>&quot;206308.0&quot;</span>","value":"\"206308.0\""}],"value":"[206308 \"206308.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>268013</span>","value":"268013"},{"type":"html","content":"<span class='clj-string'>&quot;268013.0&quot;</span>","value":"\"268013.0\""}],"value":"[268013 \"268013.0\"]"},{"type":"html","content":"<span class='clj-long'>1212</span>","value":"1212"},{"type":"html","content":"<span class='clj-string'>&quot;Materiali e strumenti per manutenzione&quot;</span>","value":"\"Materiali e strumenti per manutenzione\""}],"value":"([65316 \"65316.0\"] [206308 \"206308.0\"] [268013 \"268013.0\"] 1212 \"Materiali e strumenti per manutenzione\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>62731</span>","value":"62731"},{"type":"html","content":"<span class='clj-string'>&quot;62731.0&quot;</span>","value":"\"62731.0\""}],"value":"[62731 \"62731.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>205219</span>","value":"205219"},{"type":"html","content":"<span class='clj-string'>&quot;205219.0&quot;</span>","value":"\"205219.0\""}],"value":"[205219 \"205219.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>229384</span>","value":"229384"},{"type":"html","content":"<span class='clj-string'>&quot;229384.0&quot;</span>","value":"\"229384.0\""}],"value":"[229384 \"229384.0\"]"},{"type":"html","content":"<span class='clj-long'>1803</span>","value":"1803"},{"type":"html","content":"<span class='clj-string'>&quot;Transazioni (esclusa obbligazione principale)&quot;</span>","value":"\"Transazioni (esclusa obbligazione principale)\""}],"value":"([62731 \"62731.0\"] [205219 \"205219.0\"] [229384 \"229384.0\"] 1803 \"Transazioni (esclusa obbligazione principale)\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>118333</span>","value":"118333"},{"type":"html","content":"<span class='clj-string'>&quot;118333.0&quot;</span>","value":"\"118333.0\""}],"value":"[118333 \"118333.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>199750</span>","value":"199750"},{"type":"html","content":"<span class='clj-string'>&quot;199750.0&quot;</span>","value":"\"199750.0\""}],"value":"[199750 \"199750.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>346844</span>","value":"346844"},{"type":"html","content":"<span class='clj-string'>&quot;346844.0&quot;</span>","value":"\"346844.0\""}],"value":"[346844 \"346844.0\"]"},{"type":"html","content":"<span class='clj-long'>1582</span>","value":"1582"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti correnti a istituzioni sociali private&quot;</span>","value":"\"Trasferimenti correnti a istituzioni sociali private\""}],"value":"([118333 \"118333.0\"] [199750 \"199750.0\"] [346844 \"346844.0\"] 1582 \"Trasferimenti correnti a istituzioni sociali private\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>189791</span>","value":"189791"},{"type":"html","content":"<span class='clj-string'>&quot;189791.0&quot;</span>","value":"\"189791.0\""}],"value":"[189791 \"189791.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"html","content":"<span class='clj-long'>2507</span>","value":"2507"},{"type":"html","content":"<span class='clj-string'>&quot;Acquisizione o realizzazione software&quot;</span>","value":"\"Acquisizione o realizzazione software\""}],"value":"([0 \"zero\"] [189791 \"189791.0\"] [0 \"zero\"] 2507 \"Acquisizione o realizzazione software\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>183430</span>","value":"183430"},{"type":"html","content":"<span class='clj-string'>&quot;183430.0&quot;</span>","value":"\"183430.0\""}],"value":"[183430 \"183430.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"html","content":"<span class='clj-long'>1499</span>","value":"1499"},{"type":"html","content":"<span class='clj-string'>&quot;Altri utilizzi di beni di terzi&quot;</span>","value":"\"Altri utilizzi di beni di terzi\""}],"value":"([0 \"zero\"] [183430 \"183430.0\"] [0 \"zero\"] 1499 \"Altri utilizzi di beni di terzi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>53723</span>","value":"53723"},{"type":"html","content":"<span class='clj-string'>&quot;53723.0&quot;</span>","value":"\"53723.0\""}],"value":"[53723 \"53723.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>153599</span>","value":"153599"},{"type":"html","content":"<span class='clj-string'>&quot;153599.0&quot;</span>","value":"\"153599.0\""}],"value":"[153599 \"153599.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>76432</span>","value":"76432"},{"type":"html","content":"<span class='clj-string'>&quot;76432.0&quot;</span>","value":"\"76432.0\""}],"value":"[76432 \"76432.0\"]"},{"type":"html","content":"<span class='clj-long'>1329</span>","value":"1329"},{"type":"html","content":"<span class='clj-string'>&quot;Assistenza informatica e manutenzione software&quot;</span>","value":"\"Assistenza informatica e manutenzione software\""}],"value":"([53723 \"53723.0\"] [153599 \"153599.0\"] [76432 \"76432.0\"] 1329 \"Assistenza informatica e manutenzione software\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>24190</span>","value":"24190"},{"type":"html","content":"<span class='clj-string'>&quot;24190.0&quot;</span>","value":"\"24190.0\""}],"value":"[24190 \"24190.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>150536</span>","value":"150536"},{"type":"html","content":"<span class='clj-string'>&quot;150536.0&quot;</span>","value":"\"150536.0\""}],"value":"[150536 \"150536.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>355677</span>","value":"355677"},{"type":"html","content":"<span class='clj-string'>&quot;355677.0&quot;</span>","value":"\"355677.0\""}],"value":"[355677 \"355677.0\"]"},{"type":"html","content":"<span class='clj-long'>1322</span>","value":"1322"},{"type":"html","content":"<span class='clj-string'>&quot;Spese postali&quot;</span>","value":"\"Spese postali\""}],"value":"([24190 \"24190.0\"] [150536 \"150536.0\"] [355677 \"355677.0\"] 1322 \"Spese postali\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>711530</span>","value":"711530"},{"type":"html","content":"<span class='clj-string'>&quot;711530.0&quot;</span>","value":"\"711530.0\""}],"value":"[711530 \"711530.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>146167</span>","value":"146167"},{"type":"html","content":"<span class='clj-string'>&quot;146167.0&quot;</span>","value":"\"146167.0\""}],"value":"[146167 \"146167.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>1047899</span>","value":"1047899"},{"type":"html","content":"<span class='clj-string'>&quot;1.0 million&quot;</span>","value":"\"1.0 million\""}],"value":"[1047899 \"1.0 million\"]"},{"type":"html","content":"<span class='clj-long'>1304</span>","value":"1304"},{"type":"html","content":"<span class='clj-string'>&quot;Contratti di servizio per riscossione tributi&quot;</span>","value":"\"Contratti di servizio per riscossione tributi\""}],"value":"([711530 \"711530.0\"] [146167 \"146167.0\"] [1047899 \"1.0 million\"] 1304 \"Contratti di servizio per riscossione tributi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>2785</span>","value":"2785"},{"type":"html","content":"<span class='clj-string'>&quot;2785.0&quot;</span>","value":"\"2785.0\""}],"value":"[2785 \"2785.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>127762</span>","value":"127762"},{"type":"html","content":"<span class='clj-string'>&quot;127762.0&quot;</span>","value":"\"127762.0\""}],"value":"[127762 \"127762.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>76489</span>","value":"76489"},{"type":"html","content":"<span class='clj-string'>&quot;76489.0&quot;</span>","value":"\"76489.0\""}],"value":"[76489 \"76489.0\"]"},{"type":"html","content":"<span class='clj-long'>2791</span>","value":"2791"},{"type":"html","content":"<span class='clj-string'>&quot;Trasferimenti in conto capitale a famiglie&quot;</span>","value":"\"Trasferimenti in conto capitale a famiglie\""}],"value":"([2785 \"2785.0\"] [127762 \"127762.0\"] [76489 \"76489.0\"] 2791 \"Trasferimenti in conto capitale a famiglie\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>102177</span>","value":"102177"},{"type":"html","content":"<span class='clj-string'>&quot;102177.0&quot;</span>","value":"\"102177.0\""}],"value":"[102177 \"102177.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>110107</span>","value":"110107"},{"type":"html","content":"<span class='clj-string'>&quot;110107.0&quot;</span>","value":"\"110107.0\""}],"value":"[110107 \"110107.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>281931</span>","value":"281931"},{"type":"html","content":"<span class='clj-string'>&quot;281931.0&quot;</span>","value":"\"281931.0\""}],"value":"[281931 \"281931.0\"]"},{"type":"html","content":"<span class='clj-long'>1401</span>","value":"1401"},{"type":"html","content":"<span class='clj-string'>&quot;Noleggi&quot;</span>","value":"\"Noleggi\""}],"value":"([102177 \"102177.0\"] [110107 \"110107.0\"] [281931 \"281931.0\"] 1401 \"Noleggi\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>15161</span>","value":"15161"},{"type":"html","content":"<span class='clj-string'>&quot;15161.0&quot;</span>","value":"\"15161.0\""}],"value":"[15161 \"15161.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>109979</span>","value":"109979"},{"type":"html","content":"<span class='clj-string'>&quot;109979.0&quot;</span>","value":"\"109979.0\""}],"value":"[109979 \"109979.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>0</span>","value":"0"},{"type":"html","content":"<span class='clj-string'>&quot;zero&quot;</span>","value":"\"zero\""}],"value":"[0 \"zero\"]"},{"type":"html","content":"<span class='clj-long'>1317</span>","value":"1317"},{"type":"html","content":"<span class='clj-string'>&quot;Utenze e canoni per acqua&quot;</span>","value":"\"Utenze e canoni per acqua\""}],"value":"([15161 \"15161.0\"] [109979 \"109979.0\"] [0 \"zero\"] 1317 \"Utenze e canoni per acqua\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>59819</span>","value":"59819"},{"type":"html","content":"<span class='clj-string'>&quot;59819.0&quot;</span>","value":"\"59819.0\""}],"value":"[59819 \"59819.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>107269</span>","value":"107269"},{"type":"html","content":"<span class='clj-string'>&quot;107269.0&quot;</span>","value":"\"107269.0\""}],"value":"[107269 \"107269.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>153149</span>","value":"153149"},{"type":"html","content":"<span class='clj-string'>&quot;153149.0&quot;</span>","value":"\"153149.0\""}],"value":"[153149 \"153149.0\"]"},{"type":"html","content":"<span class='clj-long'>1202</span>","value":"1202"},{"type":"html","content":"<span class='clj-string'>&quot;Carburanti, combustibili e lubrificanti&quot;</span>","value":"\"Carburanti, combustibili e lubrificanti\""}],"value":"([59819 \"59819.0\"] [107269 \"107269.0\"] [153149 \"153149.0\"] 1202 \"Carburanti, combustibili e lubrificanti\")"},{"type":"list-like","open":"<tr><td>","close":"</td></tr>","separator":"</td><td>","items":[{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>138291</span>","value":"138291"},{"type":"html","content":"<span class='clj-string'>&quot;138291.0&quot;</span>","value":"\"138291.0\""}],"value":"[138291 \"138291.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>103291</span>","value":"103291"},{"type":"html","content":"<span class='clj-string'>&quot;103291.0&quot;</span>","value":"\"103291.0\""}],"value":"[103291 \"103291.0\"]"},{"type":"list-like","open":"<span class='clj-vector'>[</span>","close":"<span class='clj-vector'>]</span>","separator":" ","items":[{"type":"html","content":"<span class='clj-long'>206591</span>","value":"206591"},{"type":"html","content":"<span class='clj-string'>&quot;206591.0&quot;</span>","value":"\"206591.0\""}],"value":"[206591 \"206591.0\"]"},{"type":"html","content":"<span class='clj-long'>4601</span>","value":"4601"},{"type":"html","content":"<span class='clj-string'>&quot;Anticipazione di fondi per il servizio economato&quot;</span>","value":"\"Anticipazione di fondi per il servizio economato\""}],"value":"([138291 \"138291.0\"] [103291 \"103291.0\"] [206591 \"206591.0\"] 4601 \"Anticipazione di fondi per il servizio economato\")"}],"value":"#gorilla_repl.table.TableView{:contents (([0 \"zero\"] [133165276 \"133.2 million\"] [85276623 \"85.3 million\"] 3101 \"Rimborso anticipazioni di cassa\") ([4869893 \"4.9 million\"] [27365173 \"27.4 million\"] [35085279 \"35.1 million\"] 1303 \"Contratti di servizio per smaltimento rifiuti\") ([7545300 \"7.5 million\"] [19349104 \"19.3 million\"] [19708165 \"19.7 million\"] 1101 \"Competenze fisse per il personale a tempo indeterminato\") ([6113806 \"6.1 million\"] [12308306 \"12.3 million\"] [11428189 \"11.4 million\"] 2108 \"Opere per la sistemazione del suolo\") ([546559 \"546559.0\"] [8996734 \"9.0 million\"] [6859493 \"6.9 million\"] 1332 \"Altre spese per servizi\") ([2009416 \"2.0 million\"] [7585789 \"7.6 million\"] [4815155 \"4.8 million\"] 1306 \"Altri contratti di servizio\") ([2048254 \"2.0 million\"] [6507892 \"6.5 million\"] [6818473 \"6.8 million\"] 1602 \" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\") ([3156639 \"3.2 million\"] [6044042 \"6.0 million\"] [6329841 \"6.3 million\"] 1111 \"Contributi obbligatori per il personale\") ([1598050 \"1.6 million\"] [5048794 \"5.0 million\"] [682963 \"682963.0\"] 4503 \"Altre spese per servizi per conto di terzi\") ([1904201 \"1.9 million\"] [3801374 \"3.8 million\"] [4696817 \"4.7 million\"] 1552 \"Trasferimenti correnti ad altre imprese di pubblici servizi\") ([2123055 \"2.1 million\"] [3603957 \"3.6 million\"] [4347843 \"4.3 million\"] 4201 \"Ritenute erariali\") ([0 \"zero\"] [3360672 \"3.4 million\"] [8167483 \"8.2 million\"] 3302 \"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\") ([362212 \"362212.0\"] [3349398 \"3.3 million\"] [3615343 \"3.6 million\"] 1316 \"Utenze e canoni per energia elettrica\") ([1712341 \"1.7 million\"] [3151229 \"3.2 million\"] [3037776 \"3.0 million\"] 3401 \"Rimborso di BOC/BOP in euro\") ([4996 \"4996.0\"] [2847814 \"2.8 million\"] [1620418 \"1.6 million\"] 1334 \"Mense scolastiche\") ([430870 \"430870.0\"] [2423415 \"2.4 million\"] [1642020 \"1.6 million\"] 1583 \"Trasferimenti correnti ad altri\") ([1209522 \"1.2 million\"] [2241028 \"2.2 million\"] [2466736 \"2.5 million\"] 4101 \"Ritenute previdenziali e assistenziali al personale\") ([1649578 \"1.6 million\"] [1928964 \"1.9 million\"] [1783453 \"1.8 million\"] 1323 \"Assicurazioni\") ([597968 \"597968.0\"] [1701936 \"1.7 million\"] [1668864 \"1.7 million\"] 2109 \"Fabbricati civili ad uso abitativo, commerciale e istituzionale\") ([798752 \"798752.0\"] [1571861 \"1.6 million\"] [1594209 \"1.6 million\"] 1802 \"Altri oneri  straordinari della gestione corrente\") ([206806 \"206806.0\"] [1547520 \"1.5 million\"] [1056010 \"1.1 million\"] 1311 \"Manutenzione ordinaria e riparazioni di immobili\") ([827387 \"827387.0\"] [1536314 \"1.5 million\"] [1645767 \"1.6 million\"] 1701 \"IRAP\") ([259602 \"259602.0\"] [1437841 \"1.4 million\"] [397103 \"397103.0\"] 1308 \"Organizzazione manifestazioni e convegni\") ([372278 \"372278.0\"] [1376746 \"1.4 million\"] [839000 \"839000.0\"] 2107 \"Altre infrastrutture\") ([774810 \"774810.0\"] [1226070 \"1.2 million\"] [2021073 \"2.0 million\"] 1103 \"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\") ([466338 \"466338.0\"] [1113640 \"1.1 million\"] [974441 \"974441.0\"] 4301 \"Altre ritenute al personale per conto di terzi\") ([579593 \"579593.0\"] [1098115 \"1.1 million\"] [1124897 \"1.1 million\"] 1325 \"Spese per gli organi istituzionali dell'ente - Indennità\") ([794748 \"794748.0\"] [1078700 \"1.1 million\"] [584976 \"584976.0\"] 1581 \"Trasferimenti correnti a famiglie\") ([1318100 \"1.3 million\"] [971973 \"971973.0\"] [279372 \"279372.0\"] 3311 \"Rimborso mutui e prestiti ad enti del settore pubblico\") ([403637 \"403637.0\"] [891619 \"891619.0\"] [866878 \"866878.0\"] 1211 \"Acquisto di derrate alimentari\") ([2543819 \"2.5 million\"] [883392 \"883392.0\"] [836041 \"836041.0\"] 2116 \"Altri beni immobili\") ([581942 \"581942.0\"] [880481 \"880481.0\"] [441509 \"441509.0\"] 2115 \"Impianti sportivi\") ([0 \"zero\"] [839700 \"839700.0\"] [5241 \"5241.0\"] 2902 \" Conferimenti di capitali in altre imprese\") ([0 \"zero\"] [717726 \"717726.0\"] [777010 \"777010.0\"] 1302 \"Contratti di servizio per trasporto\") ([247890 \"247890.0\"] [592307 \"592307.0\"] [1150043 \"1.2 million\"] 1314 \"Servizi ausiliari e spese di pulizia\") ([40000 \"40000.0\"] [565634 \"565634.0\"] [940970 \"940970.0\"] 1569 \"Trasferimenti correnti a altri enti del settore pubblico\") ([25160 \"25160.0\"] [560593 \"560593.0\"] [1677442 \"1.7 million\"] 1318 \"Utenze e canoni per riscaldamento\") ([101402 \"101402.0\"] [513791 \"513791.0\"] [488156 \"488156.0\"] 1210 \"Altri materiali di consumo\") ([147727 \"147727.0\"] [479258 \"479258.0\"] [181851 \"181851.0\"] 2113 \"Beni di valore culturale, storico, archeologico, ed artistico\") ([90942 \"90942.0\"] [427338 \"427338.0\"] [258238 \"258238.0\"] 1623 \"Interessi passivi ad altri soggetti per anticipazioni\") ([0 \"zero\"] [400000 \"400000.0\"] [0 \"zero\"] 2093 \"Concessione di crediti a Istituzioni sociali private\") ([146778 \"146778.0\"] [391990 \"391990.0\"] [482923 \"482923.0\"] 1104 \"Competenze fisse ed accessorie per il personale a tempo determinato\") ([402538 \"402538.0\"] [371188 \"371188.0\"] [1064110 \"1.1 million\"] 2102 \"Vie di comunicazione ed infrastrutture connesse\") ([39771 \"39771.0\"] [369602 \"369602.0\"] [110865 \"110865.0\"] 1106 \"Rimborsi spese per personale comandato\") ([210381 \"210381.0\"] [346201 \"346201.0\"] [436106 \"436106.0\"] 1327 \"Buoni pasto e mensa per il personale\") ([0 \"zero\"] [343683 \"343683.0\"] [330920 \"330920.0\"] 3324 \"Rimborso mutui e prestiti ad altri - in euro\") ([49341 \"49341.0\"] [335374 \"335374.0\"] [264125 \"264125.0\"] 1313 \"Altre spese di manutenzione ordinaria e riparazioni\") ([330610 \"330610.0\"] [313092 \"313092.0\"] [222855 \"222855.0\"] 2601 \"INCARICHI PROFESSIONALI ESTERNI\") ([40347 \"40347.0\"] [263685 \"263685.0\"] [352503 \"352503.0\"] 1307 \"Incarichi professionali\") ([35722 \"35722.0\"] [246081 \"246081.0\"] [234692 \"234692.0\"] 1331 \"Spese per liti (patrocinio legale)\") ([97484 \"97484.0\"] [220476 \"220476.0\"] [1457920 \"1.5 million\"] 1333 \"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\") ([1089 \"1089.0\"] [213139 \"213139.0\"] [170611 \"170611.0\"] 1112 \"Contributi previdenza complementare\") ([149737 \"149737.0\"] [211803 \"211803.0\"] [561332 \"561332.0\"] 1315 \"Utenze e canoni per telefonia e reti di trasmissione\") ([9600 \"9600.0\"] [207856 \"207856.0\"] [0 \"zero\"] 2501 \"Mezzi di trasporto\") ([65316 \"65316.0\"] [206308 \"206308.0\"] [268013 \"268013.0\"] 1212 \"Materiali e strumenti per manutenzione\") ([62731 \"62731.0\"] [205219 \"205219.0\"] [229384 \"229384.0\"] 1803 \"Transazioni (esclusa obbligazione principale)\") ([118333 \"118333.0\"] [199750 \"199750.0\"] [346844 \"346844.0\"] 1582 \"Trasferimenti correnti a istituzioni sociali private\") ([0 \"zero\"] [189791 \"189791.0\"] [0 \"zero\"] 2507 \"Acquisizione o realizzazione software\") ([0 \"zero\"] [183430 \"183430.0\"] [0 \"zero\"] 1499 \"Altri utilizzi di beni di terzi\") ([53723 \"53723.0\"] [153599 \"153599.0\"] [76432 \"76432.0\"] 1329 \"Assistenza informatica e manutenzione software\") ([24190 \"24190.0\"] [150536 \"150536.0\"] [355677 \"355677.0\"] 1322 \"Spese postali\") ([711530 \"711530.0\"] [146167 \"146167.0\"] [1047899 \"1.0 million\"] 1304 \"Contratti di servizio per riscossione tributi\") ([2785 \"2785.0\"] [127762 \"127762.0\"] [76489 \"76489.0\"] 2791 \"Trasferimenti in conto capitale a famiglie\") ([102177 \"102177.0\"] [110107 \"110107.0\"] [281931 \"281931.0\"] 1401 \"Noleggi\") ([15161 \"15161.0\"] [109979 \"109979.0\"] [0 \"zero\"] 1317 \"Utenze e canoni per acqua\") ([59819 \"59819.0\"] [107269 \"107269.0\"] [153149 \"153149.0\"] 1202 \"Carburanti, combustibili e lubrificanti\") ([138291 \"138291.0\"] [103291 \"103291.0\"] [206591 \"206591.0\"] 4601 \"Anticipazione di fondi per il servizio economato\")), :opts (:columns (:2016 :2015 :2014 :siope :desc))}"}
;; <=

;; @@
(bar-chart :desc
           [:2016 :2015 :2014] {:flip? true :height 12}
           (where {:2015 [> 100000]}
                  (rest rilievo)))

;; @@
;; =>
;;; {"type":"html","content":"<?xml version='1.0' encoding='UTF-8'?>\n<svg viewBox='0 0 648.00 864.00' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns='http://www.w3.org/2000/svg'>\n<defs>\n<style type='text/css'>\n\n    line, polyline, path, rect, circle {\n      fill: none;\n      stroke: #000000;\n      stroke-linecap: round;\n      stroke-linejoin: round;\n      stroke-miterlimit: 10.00;\n    }\n  \n</style>\n</defs>\n<rect style='stroke: none; fill: #FFFFFF;' height='100%' width='100%'/>\n<rect style='stroke-width: 1.07; stroke: #F0F0F0; fill: #F0F0F0;' height='864.00' width='648.00' y='0.00' x='0.00'/>\n<defs>\n<clipPath id='ad491621-62d1-4bb7-a5a7-97d55172656a'>\n<rect height='807.86' width='214.79' y='24.47' x='361.83'/>\n</clipPath>\n</defs>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: #F0F0F0; fill: #F0F0F0;' height='807.86' width='214.79' y='24.47' x='361.83'/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,825.12 576.62,825.12 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,813.10 576.62,813.10 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,801.07 576.62,801.07 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,789.05 576.62,789.05 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,777.03 576.62,777.03 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,765.01 576.62,765.01 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,752.99 576.62,752.99 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,740.97 576.62,740.97 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,728.94 576.62,728.94 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,716.92 576.62,716.92 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,704.90 576.62,704.90 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,692.88 576.62,692.88 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,680.86 576.62,680.86 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,668.84 576.62,668.84 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,656.81 576.62,656.81 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,644.79 576.62,644.79 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,632.77 576.62,632.77 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,620.75 576.62,620.75 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,608.73 576.62,608.73 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,596.70 576.62,596.70 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,584.68 576.62,584.68 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,572.66 576.62,572.66 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,560.64 576.62,560.64 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,548.62 576.62,548.62 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,536.60 576.62,536.60 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,524.57 576.62,524.57 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,512.55 576.62,512.55 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,500.53 576.62,500.53 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,488.51 576.62,488.51 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,476.49 576.62,476.49 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,464.46 576.62,464.46 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,452.44 576.62,452.44 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,440.42 576.62,440.42 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,428.40 576.62,428.40 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,416.38 576.62,416.38 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,404.36 576.62,404.36 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,392.33 576.62,392.33 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,380.31 576.62,380.31 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,368.29 576.62,368.29 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,356.27 576.62,356.27 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,344.25 576.62,344.25 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,332.23 576.62,332.23 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,320.20 576.62,320.20 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,308.18 576.62,308.18 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,296.16 576.62,296.16 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,284.14 576.62,284.14 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,272.12 576.62,272.12 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,260.09 576.62,260.09 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,248.07 576.62,248.07 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,236.05 576.62,236.05 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,224.03 576.62,224.03 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,212.01 576.62,212.01 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,199.99 576.62,199.99 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,187.96 576.62,187.96 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,175.94 576.62,175.94 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,163.92 576.62,163.92 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,151.90 576.62,151.90 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,139.88 576.62,139.88 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,127.86 576.62,127.86 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,115.83 576.62,115.83 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,103.81 576.62,103.81 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,91.79 576.62,91.79 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,79.77 576.62,79.77 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,67.75 576.62,67.75 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,55.72 576.62,55.72 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,43.70 576.62,43.70 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='361.83,31.68 576.62,31.68 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='371.59,832.33 371.59,24.47 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='444.91,832.33 444.91,24.47 '/>\n<polyline clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 0.53; stroke: #D9D9D9; stroke-linecap: butt;' points='518.22,832.33 518.22,24.47 '/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.02' y='819.71' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.16' y='823.32' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.00' y='826.92' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='807.69' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.27' y='811.29' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.00' y='814.90' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='795.66' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.28' y='799.27' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.00' y='802.88' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='783.64' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.19' y='787.25' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.11' y='790.86' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.01' y='771.62' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.30' y='775.23' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.00' y='778.83' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.08' y='759.60' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.23' y='763.21' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.11' y='766.81' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.09' y='747.58' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.16' y='751.18' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.22' y='754.79' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='735.56' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.31' y='739.16' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.25' y='742.77' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='723.53' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.59' y='727.14' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.00' y='730.75' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.20' y='711.51' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.15' y='715.12' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.30' y='718.73' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.15' y='699.49' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.16' y='703.10' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.41' y='706.70' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.09' y='687.47' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.30' y='691.08' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.34' y='694.68' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.05' y='675.45' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.36' y='679.05' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.34' y='682.66' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.06' y='663.43' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.54' y='667.03' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.16' y='670.64' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.04' y='651.40' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.22' y='655.01' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.52' y='658.62' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.10' y='639.38' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.30' y='642.99' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.39' y='646.59' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.07' y='627.36' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.49' y='630.97' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.39' y='634.57' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.06' y='615.34' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.39' y='618.94' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.52' y='622.55' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.17' y='603.32' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.29' y='606.92' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.51' y='610.53' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='591.29' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.50' y='594.90' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.49' y='598.51' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.13' y='579.27' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.63' y='582.88' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.38' y='586.49' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.22' y='567.25' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.70' y='570.86' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.27' y='574.46' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='555.23' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.23' y='558.84' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.01' y='562.44' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.48' y='543.21' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.46' y='546.81' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.33' y='550.42' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.22' y='531.19' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.31' y='534.79' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.82' y='538.40' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.31' y='519.16' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.51' y='522.77' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.64' y='526.38' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.22' y='507.14' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.57' y='510.75' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.71' y='514.36' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.15' y='495.12' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.75' y='498.73' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.72' y='502.33' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='483.10' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.05' y='486.71' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.14' y='490.31' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.06' y='471.08' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.83' y='474.68' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.38' y='478.29' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.14' y='459.06' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.32' y='462.66' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.14' y='466.27' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.59' y='447.03' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.54' y='450.64' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.56' y='454.25' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.85' y='435.01' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.29' y='438.62' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.65' y='442.22' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.04' y='422.99' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.21' y='426.60' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.54' y='430.20' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.36' y='410.97' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.87' y='414.57' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.69' y='418.18' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.38' y='398.95' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.11' y='402.55' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.58' y='406.16' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.59' y='386.92' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.31' y='390.53' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.27' y='394.14' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.04' y='374.90' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='0.82' y='378.51' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.46' y='382.12' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.17' y='362.88' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.58' y='366.49' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.86' y='370.09' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.68' y='350.86' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.63' y='354.47' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.43' y='358.07' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.93' y='338.84' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.43' y='342.44' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='0.41' y='346.05' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.55' y='326.82' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.02' y='330.42' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.23' y='334.03' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.85' y='314.79' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.61' y='318.40' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.65' y='322.01' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.30' y='302.77' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.27' y='306.38' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.55' y='309.99' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.17' y='290.75' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.30' y='294.36' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.34' y='297.96' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.88' y='278.73' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.50' y='282.33' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.45' y='285.94' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.21' y='266.71' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.25' y='270.31' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.41' y='273.92' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.14' y='254.68' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.80' y='258.29' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.96' y='261.90' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='3.73' y='242.66' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='1.30' y='246.27' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.23' y='249.88' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.01' y='230.64' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='4.18' y='234.25' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.38' y='237.85' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.63' y='218.62' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='3.55' y='222.23' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.41' y='225.83' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='2.42' y='206.60' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='2.83' y='210.20' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='2.62' y='213.81' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='1.77' y='194.58' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='3.29' y='198.18' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='3.62' y='201.79' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.53' y='182.55' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='4.91' y='186.16' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='5.30' y='189.77' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='2.34' y='170.53' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='7.40' y='174.14' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='1.00' y='177.75' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='2.51' y='158.51' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='4.62' y='162.12' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='4.45' y='165.72' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='3.11' y='146.49' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='5.28' y='150.10' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='6.38' y='153.70' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='2.79' y='134.47' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='5.57' y='138.07' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='6.89' y='141.68' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='122.45' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='4.93' y='126.05' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='11.98' y='129.66' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='2.95' y='110.42' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='11.12' y='114.03' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='7.06' y='117.64' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='3.00' y='98.40' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='9.54' y='102.01' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='10.00' y='105.61' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='4.63' y='86.38' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='8.86' y='89.99' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='9.28' y='93.59' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.80' y='74.36' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='13.19' y='77.96' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='10.06' y='81.57' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='8.96' y='62.34' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='18.05' y='65.94' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='16.76' y='69.55' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='11.06' y='50.31' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='28.37' y='53.92' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='28.90' y='57.53' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='7.14' y='38.29' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='40.13' y='41.90' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='51.45' y='45.51' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #619CFF;' height='3.61' width='0.00' y='26.27' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #00BA38;' height='3.61' width='195.26' y='29.88' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: none; stroke-linecap: butt; fill: #F8766D;' height='3.61' width='125.04' y='33.48' x='371.59'/>\n<rect clip-path='url(#ad491621-62d1-4bb7-a5a7-97d55172656a)' style='stroke-width: 1.07; stroke: #F0F0F0;' height='807.86' width='214.79' y='24.47' x='361.83'/>\n<defs>\n<clipPath id='339ad31b-ed84-48a8-a67e-e379eb9916c7'>\n<rect height='864.00' width='648.00' y='0.00' x='0.00'/>\n</clipPath>\n</defs>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='828.33' x='246.23'>\nUtenze e canoni per acqua\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='816.30' x='253.53'>\nAltri utilizzi di beni di terzi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='804.28' x='202.67'>\nAcquisizione o realizzazione software\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='792.26' x='190.75'>\nTrasferimenti in conto capitale a famiglie\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='780.24' x='284.14'>\nMezzi di trasporto\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='768.22' x='157.54'>\nAssistenza informatica e manutenzione software\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='756.20' x='207.87'>\nCarburanti, combustibili e lubrificanti\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='744.17' x='202.67'>\nContributi previdenza complementare\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='732.15' x='158.07'>\nConcessione di crediti a Istituzioni sociali private\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='720.13' x='163.76'>\nAnticipazione di fondi per il servizio economato\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='708.11' x='326.14'>\nNoleggi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='696.09' x='171.54'>\nTransazioni (esclusa obbligazione principale)\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='684.07' x='227.06'>\nSpese per liti (patrocinio legale)\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='672.04' x='185.03'>\nRimborsi spese per personale comandato\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='660.02' x='301.75'>\nSpese postali\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='648.00' x='196.45'>\nMateriali e strumenti per manutenzione\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='635.98' x='147.67'>\nAltre spese di manutenzione ordinaria e riparazioni\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='623.96' x='268.04'>\nIncarichi professionali\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='611.93' x='161.72'>\nTrasferimenti correnti a istituzioni sociali private\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='599.91' x='187.13'>\nRimborso mutui e prestiti ad altri - in euro\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='587.89' x='155.47'>\nInteressi passivi ad altri soggetti per anticipazioni\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='575.87' x='122.27'>\nBeni di valore culturale, storico, archeologico, ed artistico\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='563.85' x='194.39'>\n Conferimenti di capitali in altre imprese\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='551.83' x='189.24'>\nINCARICHI PROFESSIONALI ESTERNI\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='539.80' x='148.20'>\nUtenze e canoni per telefonia e reti di trasmissione\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='527.78' x='203.70'>\nBuoni pasto e mensa per il personale\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='515.76' x='68.30'>\nCompetenze fisse ed accessorie per il personale a tempo determinato\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='503.74' x='253.53'>\nAltri materiali di consumo\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='491.72' x='222.92'>\nContratti di servizio per trasporto\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='479.70' x='143.03'>\nTrasferimenti correnti a altri enti del settore pubblico\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='467.67' x='27.34'>\nRette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='455.65' x='159.09'>\nVie di comunicazione ed infrastrutture connesse\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='443.63' x='292.95'>\nImpianti sportivi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='431.61' x='187.65'>\nContratti di servizio per riscossione tributi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='419.59' x='221.36'>\nServizi ausiliari e spese di pulizia\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='407.56' x='182.95'>\nOrganizzazione manifestazioni e convegni\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='395.54' x='236.92'>\nAcquisto di derrate alimentari\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='383.52' x='213.56'>\nUtenze e canoni per riscaldamento\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='371.50' x='227.08'>\nTrasferimenti correnti a famiglie\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='359.48' x='179.84'>\nAltre ritenute al personale per conto di terzi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='347.46' x='140.42'>\nRimborso mutui e prestiti ad enti del settore pubblico\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='335.43' x='283.62'>\nAltre infrastrutture\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='323.41' x='142.76'>\nSpese per gli organi istituzionali dell'ente - Indennità\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='311.39' x='160.14'>\nManutenzione ordinaria e riparazioni di immobili\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='299.37' x='169.47'>\nAltri oneri  straordinari della gestione corrente\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='287.35' x='111.39'>\nFabbricati civili ad uso abitativo, commerciale e istituzionale\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='275.32' x='336.01'>\nIRAP\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='263.30' x='22.63'>\nAltre competenze ed indennità accessorie per il personale a tempo indeterminato\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='251.28' x='284.66'>\nAltri beni immobili\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='239.26' x='281.01'>\nMense scolastiche\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='227.24' x='239.01'>\nTrasferimenti correnti ad altri\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='215.22' x='302.81'>\nAssicurazioni\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='203.19' x='154.42'>\nRitenute previdenziali e assistenziali al personale\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='191.17' x='205.25'>\nUtenze e canoni per energia elettrica\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='179.15' x='194.39'>\nAltre spese per servizi per conto di terzi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='167.13' x='231.75'>\nRimborso di BOC/BOP in euro\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='155.11' x='292.43'>\nRitenute erariali\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='143.09' x='126.97'>\nTrasferimenti correnti ad altre imprese di pubblici servizi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='131.06' x='96.86'>\nRimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='119.04' x='261.84'>\nAltri contratti di servizio\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='107.02' x='95.82'>\n Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='95.00' x='205.78'>\nContributi obbligatori per il personale\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='82.98' x='265.98'>\nAltre spese per servizi\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='70.95' x='208.90'>\nOpere per la sistemazione del suolo\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='58.93' x='121.22'>\nCompetenze fisse per il personale a tempo indeterminato\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='46.91' x='187.14'>\nContratti di servizio per smaltimento rifiuti\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='34.89' x='227.07'>\nRimborso anticipazioni di cassa\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='842.78' x='368.99'>\n0\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='842.78' x='421.55'>\n50,000,000\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #737373; font-family: Arial;' y='842.78' x='492.27'>\n100,000,000\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 8.00pt; fill: #525252; font-family: Arial;' transform='translate(19.05,439.67) rotate(-90)'>\ndesc\n</text>\n</g>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: none; fill: #F0F0F0;' height='64.66' width='48.71' y='396.07' x='585.12'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: #F0F0F0; fill: #F0F0F0;' height='17.28' width='17.28' y='404.64' x='589.37'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: none; stroke-linejoin: miter; fill: #F8766D;' height='15.86' width='15.86' y='405.35' x='590.08'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: #F0F0F0; fill: #F0F0F0;' height='17.28' width='17.28' y='421.92' x='589.37'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: none; stroke-linejoin: miter; fill: #00BA38;' height='15.86' width='15.86' y='422.63' x='590.08'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: #F0F0F0; fill: #F0F0F0;' height='17.28' width='17.28' y='439.20' x='589.37'/>\n<rect clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)' style='stroke-width: 1.07; stroke: none; stroke-linejoin: miter; fill: #619CFF;' height='15.86' width='15.86' y='439.91' x='590.08'/>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #525252; font-family: Arial;' y='416.49' x='608.81'>\n2014\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #525252; font-family: Arial;' y='433.77' x='608.81'>\n2015\n</text>\n</g>\n<g clip-path='url(#339ad31b-ed84-48a8-a67e-e379eb9916c7)'>\n<text style='font-size: 7.00pt; fill: #525252; font-family: Arial;' y='451.05' x='608.81'>\n2016\n</text>\n</g>\n</svg>\n","value":"#huri.plot.GGView{:plot-command [[:<- :g [:data.frame {:desc [:c \"Altre spese per servizi\" \"Contratti di servizio per trasporto\" \"Contratti di servizio per riscossione tributi\" \"Trasferimenti correnti a altri enti del settore pubblico\" \"Acquisizione o realizzazione software\" \"Interessi passivi ad altri soggetti per anticipazioni\" \"Vie di comunicazione ed infrastrutture connesse\" \" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\" \"Materiali e strumenti per manutenzione\" \"Rimborso anticipazioni di cassa\" \"Acquisto di derrate alimentari\" \"Competenze fisse per il personale a tempo indeterminato\" \"Rimborso di BOC/BOP in euro\" \"Beni di valore culturale, storico, archeologico, ed artistico\" \"Utenze e canoni per acqua\" \"Altre spese per servizi per conto di terzi\" \"Altri contratti di servizio\" \"Ritenute previdenziali e assistenziali al personale\" \"Altri materiali di consumo\" \"Rimborso mutui e prestiti ad altri - in euro\" \"Organizzazione manifestazioni e convegni\" \"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\" \"Mense scolastiche\" \"IRAP\" \"Incarichi professionali\" \"Assicurazioni\" \"Rimborsi spese per personale comandato\" \"Assistenza informatica e manutenzione software\" \"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\" \"Contributi obbligatori per il personale\" \"Utenze e canoni per energia elettrica\" \"Utenze e canoni per riscaldamento\" \"Noleggi\" \"Carburanti, combustibili e lubrificanti\" \"Altri utilizzi di beni di terzi\" \"Mezzi di trasporto\" \"Trasferimenti correnti a famiglie\" \"Anticipazione di fondi per il servizio economato\" \"Altri oneri  straordinari della gestione corrente\" \"Trasferimenti correnti a istituzioni sociali private\" \"INCARICHI PROFESSIONALI ESTERNI\" \"Impianti sportivi\" \"Contributi previdenza complementare\" \"Trasferimenti in conto capitale a famiglie\" \"Altre spese di manutenzione ordinaria e riparazioni\" \"Contratti di servizio per smaltimento rifiuti\" \"Concessione di crediti a Istituzioni sociali private\" \" Conferimenti di capitali in altre imprese\" \"Altre ritenute al personale per conto di terzi\" \"Ritenute erariali\" \"Altre infrastrutture\" \"Servizi ausiliari e spese di pulizia\" \"Altri beni immobili\" \"Trasferimenti correnti ad altre imprese di pubblici servizi\" \"Competenze fisse ed accessorie per il personale a tempo determinato\" \"Fabbricati civili ad uso abitativo, commerciale e istituzionale\" \"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\" \"Opere per la sistemazione del suolo\" \"Spese per liti (patrocinio legale)\" \"Utenze e canoni per telefonia e reti di trasmissione\" \"Buoni pasto e mensa per il personale\" \"Spese per gli organi istituzionali dell'ente - Indennità\" \"Manutenzione ordinaria e riparazioni di immobili\" \"Spese postali\" \"Trasferimenti correnti ad altri\" \"Transazioni (esclusa obbligazione principale)\" \"Rimborso mutui e prestiti ad enti del settore pubblico\" \"Altre spese per servizi\" \"Contratti di servizio per trasporto\" \"Contratti di servizio per riscossione tributi\" \"Trasferimenti correnti a altri enti del settore pubblico\" \"Acquisizione o realizzazione software\" \"Interessi passivi ad altri soggetti per anticipazioni\" \"Vie di comunicazione ed infrastrutture connesse\" \" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\" \"Materiali e strumenti per manutenzione\" \"Rimborso anticipazioni di cassa\" \"Acquisto di derrate alimentari\" \"Competenze fisse per il personale a tempo indeterminato\" \"Rimborso di BOC/BOP in euro\" \"Beni di valore culturale, storico, archeologico, ed artistico\" \"Utenze e canoni per acqua\" \"Altre spese per servizi per conto di terzi\" \"Altri contratti di servizio\" \"Ritenute previdenziali e assistenziali al personale\" \"Altri materiali di consumo\" \"Rimborso mutui e prestiti ad altri - in euro\" \"Organizzazione manifestazioni e convegni\" \"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\" \"Mense scolastiche\" \"IRAP\" \"Incarichi professionali\" \"Assicurazioni\" \"Rimborsi spese per personale comandato\" \"Assistenza informatica e manutenzione software\" \"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\" \"Contributi obbligatori per il personale\" \"Utenze e canoni per energia elettrica\" \"Utenze e canoni per riscaldamento\" \"Noleggi\" \"Carburanti, combustibili e lubrificanti\" \"Altri utilizzi di beni di terzi\" \"Mezzi di trasporto\" \"Trasferimenti correnti a famiglie\" \"Anticipazione di fondi per il servizio economato\" \"Altri oneri  straordinari della gestione corrente\" \"Trasferimenti correnti a istituzioni sociali private\" \"INCARICHI PROFESSIONALI ESTERNI\" \"Impianti sportivi\" \"Contributi previdenza complementare\" \"Trasferimenti in conto capitale a famiglie\" \"Altre spese di manutenzione ordinaria e riparazioni\" \"Contratti di servizio per smaltimento rifiuti\" \"Concessione di crediti a Istituzioni sociali private\" \" Conferimenti di capitali in altre imprese\" \"Altre ritenute al personale per conto di terzi\" \"Ritenute erariali\" \"Altre infrastrutture\" \"Servizi ausiliari e spese di pulizia\" \"Altri beni immobili\" \"Trasferimenti correnti ad altre imprese di pubblici servizi\" \"Competenze fisse ed accessorie per il personale a tempo determinato\" \"Fabbricati civili ad uso abitativo, commerciale e istituzionale\" \"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\" \"Opere per la sistemazione del suolo\" \"Spese per liti (patrocinio legale)\" \"Utenze e canoni per telefonia e reti di trasmissione\" \"Buoni pasto e mensa per il personale\" \"Spese per gli organi istituzionali dell'ente - Indennità\" \"Manutenzione ordinaria e riparazioni di immobili\" \"Spese postali\" \"Trasferimenti correnti ad altri\" \"Transazioni (esclusa obbligazione principale)\" \"Rimborso mutui e prestiti ad enti del settore pubblico\" \"Altre spese per servizi\" \"Contratti di servizio per trasporto\" \"Contratti di servizio per riscossione tributi\" \"Trasferimenti correnti a altri enti del settore pubblico\" \"Acquisizione o realizzazione software\" \"Interessi passivi ad altri soggetti per anticipazioni\" \"Vie di comunicazione ed infrastrutture connesse\" \" Interessi passivi a Cassa depositi e prestiti - gestione CDP spa\" \"Materiali e strumenti per manutenzione\" \"Rimborso anticipazioni di cassa\" \"Acquisto di derrate alimentari\" \"Competenze fisse per il personale a tempo indeterminato\" \"Rimborso di BOC/BOP in euro\" \"Beni di valore culturale, storico, archeologico, ed artistico\" \"Utenze e canoni per acqua\" \"Altre spese per servizi per conto di terzi\" \"Altri contratti di servizio\" \"Ritenute previdenziali e assistenziali al personale\" \"Altri materiali di consumo\" \"Rimborso mutui e prestiti ad altri - in euro\" \"Organizzazione manifestazioni e convegni\" \"Rimborso mutui  a Cassa depositi e prestiti - gestione CDP spa\" \"Mense scolastiche\" \"IRAP\" \"Incarichi professionali\" \"Assicurazioni\" \"Rimborsi spese per personale comandato\" \"Assistenza informatica e manutenzione software\" \"Altre competenze ed indennità accessorie per il personale a tempo indeterminato\" \"Contributi obbligatori per il personale\" \"Utenze e canoni per energia elettrica\" \"Utenze e canoni per riscaldamento\" \"Noleggi\" \"Carburanti, combustibili e lubrificanti\" \"Altri utilizzi di beni di terzi\" \"Mezzi di trasporto\" \"Trasferimenti correnti a famiglie\" \"Anticipazione di fondi per il servizio economato\" \"Altri oneri  straordinari della gestione corrente\" \"Trasferimenti correnti a istituzioni sociali private\" \"INCARICHI PROFESSIONALI ESTERNI\" \"Impianti sportivi\" \"Contributi previdenza complementare\" \"Trasferimenti in conto capitale a famiglie\" \"Altre spese di manutenzione ordinaria e riparazioni\" \"Contratti di servizio per smaltimento rifiuti\" \"Concessione di crediti a Istituzioni sociali private\" \" Conferimenti di capitali in altre imprese\" \"Altre ritenute al personale per conto di terzi\" \"Ritenute erariali\" \"Altre infrastrutture\" \"Servizi ausiliari e spese di pulizia\" \"Altri beni immobili\" \"Trasferimenti correnti ad altre imprese di pubblici servizi\" \"Competenze fisse ed accessorie per il personale a tempo determinato\" \"Fabbricati civili ad uso abitativo, commerciale e istituzionale\" \"Rette di ricovero in strutture per anziani/minori/handicap ed altri servizi connessi\" \"Opere per la sistemazione del suolo\" \"Spese per liti (patrocinio legale)\" \"Utenze e canoni per telefonia e reti di trasmissione\" \"Buoni pasto e mensa per il personale\" \"Spese per gli organi istituzionali dell'ente - Indennità\" \"Manutenzione ordinaria e riparazioni di immobili\" \"Spese postali\" \"Trasferimenti correnti ad altri\" \"Transazioni (esclusa obbligazione principale)\" \"Rimborso mutui e prestiti ad enti del settore pubblico\"], :y__auto [:c 546559 0 711530 40000 0 90942 402538 2048254 65316 0 403637 7545300 1712341 147727 15161 1598050 2009416 1209522 101402 0 259602 0 4996 827387 40347 1649578 39771 53723 774810 3156639 362212 25160 102177 59819 0 9600 794748 138291 798752 118333 330610 581942 1089 2785 49341 4869893 0 0 466338 2123055 372278 247890 2543819 1904201 146778 597968 97484 6113806 35722 149737 210381 579593 206806 24190 430870 62731 1318100 8996734 717726 146167 565634 189791 427338 371188 6507892 206308 133165276 891619 19349104 3151229 479258 109979 5048794 7585789 2241028 513791 343683 1437841 3360672 2847814 1536314 263685 1928964 369602 153599 1226070 6044042 3349398 560593 110107 107269 183430 207856 1078700 103291 1571861 199750 313092 880481 213139 127762 335374 27365173 400000 839700 1113640 3603957 1376746 592307 883392 3801374 391990 1701936 220476 12308306 246081 211803 346201 1098115 1547520 150536 2423415 205219 971973 6859493 777010 1047899 940970 0 258238 1064110 6818473 268013 85276623 866878 19708165 3037776 181851 0 682963 4815155 2466736 488156 330920 397103 8167483 1620418 1645767 352503 1783453 110865 76432 2021073 6329841 3615343 1677442 281931 153149 0 0 584976 206591 1594209 346844 222855 441509 170611 76489 264125 35085279 0 5241 974441 4347843 839000 1150043 836041 4696817 482923 1668864 1457920 11428189 234692 561332 436106 1124897 1056010 355677 1642020 229384 279372], :series__auto [:c \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2016\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2015\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\" \"2014\"]}]] [[:library :ggplot2] [:library :scales] [:library :grid] [:library :RColorBrewer] [:library :ggrepel] [:<- :palette [:brewer.pal \"Greys\" {:n 9}]] {:color.background :palette[2]} {:color.grid.major :palette[3]} {:color.axis.text :palette[6]} {:color.axis.title :palette[7]} {:color.title :palette[9]}] [:+ [:+ [:+ [:+ [:+ [:ggplot :g [:aes {:x [:reorder :desc :y__auto], :y :y__auto, :fill :series__auto}]] [:geom_bar {:stat \"identity\", :position \"dodge\"}]] [:coord_flip]] [:scale_y_continuous {:labels :comma}]] [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:+ [:theme_bw {:base_size 9}] [:theme {:panel.background [:element_rect {:fill :color.background, :color :color.background}]}]] [:theme {:plot.background [:element_rect {:fill :color.background, :color :color.background}]}]] [:theme {:panel.border [:element_rect {:color :color.background}]}]] [:theme {:panel.grid.major [:element_line {:color :color.grid.major, :size 0.25}]}]] [:theme {:panel.grid.minor [:element_blank]}]] [:theme {:axis.ticks [:element_blank]}]] [:theme {:legend.background [:element_rect {:fill :color.background}]}]] [:theme {:legend.key [:element_rect {:fill :color.background, :color :color.background}]}]] [:theme {:legend.text [:element_text {:size 7, :color :color.axis.title}]}]] [:theme {:legend.title [:element_blank]}]] [:theme {:plot.title [:element_text {:size 10, :color :color.title, :vjust 1.25}]}]] [:theme {:axis.text.x [:element_text {:size 7, :color :color.axis.text}]}]] [:theme {:axis.text.y [:element_text {:size 7, :color :color.axis.text}]}]] [:theme {:axis.title.x [:element_text {:size 8, :color :color.axis.title, :vjust 0}]}]] [:theme {:axis.title.y [:element_text {:size 8, :color :color.axis.title, :vjust 1.25}]}]] [:theme {:plot.margin [:unit [:c 0.35 0.2 0.3 0.35] \"cm\"]}]]] [:labs {:y \"\", :title \"\", :x \"desc\"}]]], :options {:width 9, :height 12}}"}
;; <=

;; @@
 
;; @@
