/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class ETypeInfo {
    private int etype;
    private String salt = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE = 1;

    private ETypeInfo() {
    }

    public ETypeInfo(int n, String string) {
        this.etype = n;
        this.salt = string;
    }

    public Object clone() {
        return new ETypeInfo(this.etype, this.salt);
    }

    public ETypeInfo(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = derValue2.getData().getBigInteger().intValue();
        if (derValue.getData().available() > 0 && ((derValue2 = derValue.getData().getDerValue()).getTag() & 0x1F) == 1) {
            byte[] byArray = derValue2.getData().getOctetString();
            this.salt = KerberosString.MSNAME ? new String(byArray, "UTF8") : new String(byArray);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.etype);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        if (this.salt != null) {
            derOutputStream2 = new DerOutputStream();
            if (KerberosString.MSNAME) {
                derOutputStream2.putOctetString(this.salt.getBytes("UTF8"));
            } else {
                derOutputStream2.putOctetString(this.salt.getBytes());
            }
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public String getSalt() {
        return this.salt;
    }
}

