/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonToggleUI;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public abstract class AquaButtonLabeledUI
extends AquaButtonToggleUI
implements AquaUtilControlSize.Sizeable {
    protected static RecyclableSizingIcon regularIcon = new RecyclableSizingIcon(18);
    protected static RecyclableSizingIcon smallIcon = new RecyclableSizingIcon(16);
    protected static RecyclableSizingIcon miniIcon = new RecyclableSizingIcon(14);
    protected AquaButtonBorder widgetBorder = this.getPainter();

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
        super.applySizeFor(jComponent, size);
        this.widgetBorder = (AquaButtonBorder)this.widgetBorder.deriveBorderForSize(size);
    }

    public Icon getDefaultIcon(JComponent jComponent) {
        JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(jComponent);
        if (size == JRSUIConstants.Size.REGULAR) {
            return (Icon)regularIcon.get();
        }
        if (size == JRSUIConstants.Size.SMALL) {
            return (Icon)smallIcon.get();
        }
        if (size == JRSUIConstants.Size.MINI) {
            return (Icon)miniIcon.get();
        }
        return (Icon)regularIcon.get();
    }

    @Override
    protected void setThemeBorder(AbstractButton abstractButton) {
        super.setThemeBorder(abstractButton);
        Border border = abstractButton.getBorder();
        if (border == null || border instanceof UIResource) {
            abstractButton.setBorder(AquaButtonBorder.getBevelButtonBorder());
        }
    }

    protected abstract AquaButtonBorder getPainter();

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Dimension dimension = abstractButton.getSize();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(abstractButton.getWidth(), abstractButton.getHeight());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        boolean bl = jComponent.getParent() instanceof CellRendererPane;
        if (abstractButton.isOpaque() || bl) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (((AbstractButton)jComponent).isBorderPainted() && !bl && (object = jComponent.getBorder()) instanceof AquaButtonBorder) {
            ((AquaButtonBorder)object).paintButton(jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        object = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(abstractButton), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (icon == null) {
            this.widgetBorder.paintButton(jComponent, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (object != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, abstractButton, rectangle3, (String)object);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(abstractButton);
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(rectangle2.x, rectangle3.x);
        int n2 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width);
        int n3 = Math.min(rectangle2.y, rectangle3.y);
        int n4 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        Insets insets = abstractButton.getInsets();
        return new Dimension(n5 += insets.left + insets.right, n6 += insets.top + insets.bottom);
    }

    public static abstract class LabeledButtonBorder
    extends AquaButtonBorder {
        public LabeledButtonBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(sizeDescriptor);
        }

        public LabeledButtonBorder(LabeledButtonBorder labeledButtonBorder) {
            super(labeledButtonBorder);
        }

        @Override
        protected AquaPainter<? extends JRSUIState> createPainter() {
            AquaPainter<JRSUIState.ValueState> aquaPainter = AquaPainter.create(JRSUIStateFactory.getLabeledButton());
            ((JRSUIState.ValueState)aquaPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            ((JRSUIState.ValueState)aquaPainter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
            return aquaPainter;
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            ((JRSUIState)this.painter.state).set(AquaUtilControlSize.getUserSizeFrom(abstractButton));
            ((JRSUIState.ValueState)this.painter.state).setValue(buttonModel.isSelected() ? (LabeledButtonBorder.isIndeterminate(abstractButton) ? 2.0 : 1.0) : 0.0);
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
        }

        @Override
        protected JRSUIConstants.State getButtonState(AbstractButton abstractButton, ButtonModel buttonModel) {
            JRSUIConstants.State state = super.getButtonState(abstractButton, buttonModel);
            if (state == JRSUIConstants.State.INACTIVE) {
                return JRSUIConstants.State.INACTIVE;
            }
            if (state == JRSUIConstants.State.DISABLED) {
                return JRSUIConstants.State.DISABLED;
            }
            if (buttonModel.isArmed() && buttonModel.isPressed()) {
                return JRSUIConstants.State.PRESSED;
            }
            if (buttonModel.isSelected()) {
                return JRSUIConstants.State.ACTIVE;
            }
            return state;
        }

        static boolean isIndeterminate(AbstractButton abstractButton) {
            return "indeterminate".equals(abstractButton.getClientProperty("JButton.selectedState"));
        }
    }

    protected static class RecyclableSizingIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final int iconSize;

        public RecyclableSizingIcon(int n) {
            this.iconSize = n;
        }

        @Override
        protected Icon getInstance() {
            return new ImageIcon(new BufferedImage(this.iconSize, this.iconSize, 3));
        }
    }
}

