/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public void add(double d) {
        long l;
        Striped64.Cell[] cellArray = this.cells;
        if (this.cells != null || !this.casBase(l = this.base, Double.doubleToRawLongBits(Double.longBitsToDouble(l) + d))) {
            long l2;
            Striped64.Cell cell;
            int n;
            boolean bl = true;
            if (cellArray == null || (n = cellArray.length - 1) < 0 || (cell = cellArray[DoubleAdder.getProbe() & n]) == null || !(bl = cell.cas(l2 = cell.value, Double.doubleToRawLongBits(Double.longBitsToDouble(l2) + d)))) {
                this.doubleAccumulate(d, null, bl);
            }
        }
    }

    public double sum() {
        Striped64.Cell[] cellArray = this.cells;
        double d = Double.longBitsToDouble(this.base);
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                d += Double.longBitsToDouble(cell.value);
            }
        }
        return d;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = 0L;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                cell.value = 0L;
            }
        }
    }

    public double sumThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        double d = Double.longBitsToDouble(this.base);
        this.base = 0L;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                long l = cell.value;
                cell.value = 0L;
                d += Double.longBitsToDouble(l);
            }
        }
        return d;
    }

    public String toString() {
        return Double.toString(this.sum());
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public long longValue() {
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return (float)this.sum();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;

        SerializationProxy(DoubleAdder doubleAdder) {
            this.value = doubleAdder.sum();
        }

        private Object readResolve() {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.base = Double.doubleToRawLongBits(this.value);
            return doubleAdder;
        }
    }
}

