/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PBKDF2Core;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBMAC1Core
extends HmacCore {
    private final String kdfAlgo;
    private final String hashAlgo;
    private final int blockLength;

    PBMAC1Core(String string, String string2, int n) throws NoSuchAlgorithmException {
        super(string2, n);
        this.kdfAlgo = string;
        this.hashAlgo = string2;
        this.blockLength = n;
    }

    private static PBKDF2Core getKDFImpl(String string) {
        PBKDF2Core pBKDF2Core = null;
        switch (string) {
            case "HmacSHA1": {
                pBKDF2Core = new PBKDF2Core.HmacSHA1();
                break;
            }
            case "HmacSHA224": {
                pBKDF2Core = new PBKDF2Core.HmacSHA224();
                break;
            }
            case "HmacSHA256": {
                pBKDF2Core = new PBKDF2Core.HmacSHA256();
                break;
            }
            case "HmacSHA384": {
                pBKDF2Core = new PBKDF2Core.HmacSHA384();
                break;
            }
            case "HmacSHA512": {
                pBKDF2Core = new PBKDF2Core.HmacSHA512();
                break;
            }
            default: {
                throw new ProviderException("No MAC implementation for " + string);
            }
        }
        return pBKDF2Core;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] cArray;
        Object object;
        byte[] byArray = null;
        int n = 0;
        if (key instanceof PBEKey) {
            object = (PBEKey)key;
            cArray = object.getPassword();
            byArray = object.getSalt();
            n = object.getIterationCount();
        } else if (key instanceof SecretKey) {
            object = key.getEncoded();
            if (object == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            cArray = new char[((Object)object).length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(object[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (algorithmParameterSpec == null) {
            if (byArray == null || n == 0) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
            }
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            object = (PBEParameterSpec)algorithmParameterSpec;
            if (byArray != null) {
                if (!Arrays.equals(byArray, ((PBEParameterSpec)object).getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                byArray = ((PBEParameterSpec)object).getSalt();
            }
            if (n != 0) {
                if (n != ((PBEParameterSpec)object).getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                n = ((PBEParameterSpec)object).getIterationCount();
            }
        }
        if (byArray.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (n <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        object = new PBEKeySpec(cArray, byArray, n, this.blockLength);
        Arrays.fill(cArray, ' ');
        SecretKey secretKey = null;
        PBKDF2Core pBKDF2Core = PBMAC1Core.getKDFImpl(this.kdfAlgo);
        try {
            secretKey = pBKDF2Core.engineGenerateSecret((KeySpec)object);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Cannot construct PBE key");
            invalidKeyException.initCause(invalidKeySpecException);
            throw invalidKeyException;
        }
        byte[] byArray2 = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, this.kdfAlgo);
        super.engineInit(secretKeySpec, null);
    }

    public static final class HmacSHA512
    extends PBMAC1Core {
        public HmacSHA512() throws NoSuchAlgorithmException {
            super("HmacSHA512", "SHA-512", 128);
        }
    }

    public static final class HmacSHA384
    extends PBMAC1Core {
        public HmacSHA384() throws NoSuchAlgorithmException {
            super("HmacSHA384", "SHA-384", 128);
        }
    }

    public static final class HmacSHA256
    extends PBMAC1Core {
        public HmacSHA256() throws NoSuchAlgorithmException {
            super("HmacSHA256", "SHA-256", 64);
        }
    }

    public static final class HmacSHA224
    extends PBMAC1Core {
        public HmacSHA224() throws NoSuchAlgorithmException {
            super("HmacSHA224", "SHA-224", 64);
        }
    }

    public static final class HmacSHA1
    extends PBMAC1Core {
        public HmacSHA1() throws NoSuchAlgorithmException {
            super("HmacSHA1", "SHA1", 64);
        }
    }
}

