/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.WeakReference;
import java.security.Key;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.security.pkcs11.P11Key;
import sun.security.util.Cache;

final class KeyCache {
    private final Cache strongCache = Cache.newHardMemoryCache(16);
    private WeakReference<Map<Key, P11Key>> cacheReference;

    KeyCache() {
    }

    synchronized P11Key get(Key key) {
        Map map;
        P11Key p11Key = (P11Key)this.strongCache.get(new IdentityWrapper(key));
        if (p11Key != null) {
            return p11Key;
        }
        Map map2 = map = this.cacheReference == null ? null : (Map)this.cacheReference.get();
        if (map == null) {
            return null;
        }
        return (P11Key)map.get(key);
    }

    synchronized void put(Key key, P11Key p11Key) {
        IdentityHashMap<Key, P11Key> identityHashMap;
        this.strongCache.put(new IdentityWrapper(key), p11Key);
        IdentityHashMap<Key, P11Key> identityHashMap2 = identityHashMap = this.cacheReference == null ? null : (IdentityHashMap<Key, P11Key>)this.cacheReference.get();
        if (identityHashMap == null) {
            identityHashMap = new IdentityHashMap<Key, P11Key>();
            this.cacheReference = new WeakReference(identityHashMap);
        }
        identityHashMap.put(key, p11Key);
    }

    private static final class IdentityWrapper {
        final Object obj;

        IdentityWrapper(Object object) {
            this.obj = object;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWrapper)) {
                return false;
            }
            IdentityWrapper identityWrapper = (IdentityWrapper)object;
            return this.obj == identityWrapper.obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

