/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import java.util.Map;

public final class PolicyUtils {
    public static final int NOPLAINTEXT = 1;
    public static final int NOACTIVE = 2;
    public static final int NODICTIONARY = 4;
    public static final int FORWARD_SECRECY = 8;
    public static final int NOANONYMOUS = 16;
    public static final int PASS_CREDENTIALS = 512;

    private PolicyUtils() {
    }

    public static boolean checkPolicy(int n, Map map) {
        if (map == null) {
            return true;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noplaintext")) && (n & 1) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noactive")) && (n & 2) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.nodictionary")) && (n & 4) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.noanonymous")) && (n & 0x10) == 0) {
            return false;
        }
        if ("true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.forward")) && (n & 8) == 0) {
            return false;
        }
        return !"true".equalsIgnoreCase((String)map.get("javax.security.sasl.policy.credentials")) || (n & 0x200) != 0;
    }

    public static String[] filterMechs(String[] stringArray, int[] nArray, Map map) {
        if (map == null) {
            return (String[])stringArray.clone();
        }
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = PolicyUtils.checkPolicy(nArray[i], map);
            if (!blArray[i]) continue;
            ++n;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray2;
    }
}

