/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import sun.misc.Unsafe;

public class StampedLock
implements Serializable {
    private static final long serialVersionUID = -6001602636862214147L;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int SPINS = NCPU > 1 ? 64 : 0;
    private static final int HEAD_SPINS = NCPU > 1 ? 1024 : 0;
    private static final int MAX_HEAD_SPINS = NCPU > 1 ? 65536 : 0;
    private static final int OVERFLOW_YIELD_RATE = 7;
    private static final int LG_READERS = 7;
    private static final long RUNIT = 1L;
    private static final long WBIT = 128L;
    private static final long RBITS = 127L;
    private static final long RFULL = 126L;
    private static final long ABITS = 255L;
    private static final long SBITS = -128L;
    private static final long ORIGIN = 256L;
    private static final long INTERRUPTED = 1L;
    private static final int WAITING = -1;
    private static final int CANCELLED = 1;
    private static final int RMODE = 0;
    private static final int WMODE = 1;
    private volatile transient WNode whead;
    private volatile transient WNode wtail;
    transient ReadLockView readLockView;
    transient WriteLockView writeLockView;
    transient ReadWriteLockView readWriteLockView;
    private volatile transient long state = 256L;
    private transient int readerOverflow;
    private static final Unsafe U;
    private static final long STATE;
    private static final long WHEAD;
    private static final long WTAIL;
    private static final long WNEXT;
    private static final long WSTATUS;
    private static final long WCOWAIT;
    private static final long PARKBLOCKER;

    public long writeLock() {
        long l;
        long l2 = this.state;
        return (l2 & 0xFFL) == 0L && U.compareAndSwapLong(this, STATE, l2, l = l2 + 128L) ? l : this.acquireWrite(false, 0L);
    }

    public long tryWriteLock() {
        long l;
        long l2 = this.state;
        return (l2 & 0xFFL) == 0L && U.compareAndSwapLong(this, STATE, l2, l = l2 + 128L) ? l : 0L;
    }

    public long tryWriteLock(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        if (!Thread.interrupted()) {
            long l3 = this.tryWriteLock();
            if (l3 != 0L) {
                return l3;
            }
            if (l2 <= 0L) {
                return 0L;
            }
            long l4 = System.nanoTime() + l2;
            if (l4 == 0L) {
                l4 = 1L;
            }
            if ((l3 = this.acquireWrite(true, l4)) != 1L) {
                return l3;
            }
        }
        throw new InterruptedException();
    }

    public long writeLockInterruptibly() throws InterruptedException {
        long l;
        if (!Thread.interrupted() && (l = this.acquireWrite(true, 0L)) != 1L) {
            return l;
        }
        throw new InterruptedException();
    }

    public long readLock() {
        long l;
        long l2 = this.state;
        return this.whead == this.wtail && (l2 & 0xFFL) < 126L && U.compareAndSwapLong(this, STATE, l2, l = l2 + 1L) ? l : this.acquireRead(false, 0L);
    }

    public long tryReadLock() {
        long l;
        long l2;
        long l3;
        do {
            if ((l3 = (l2 = this.state) & 0xFFL) != 128L) continue;
            return 0L;
        } while (!(l3 < 126L ? U.compareAndSwapLong(this, STATE, l2, l = l2 + 1L) : (l = this.tryIncReaderOverflow(l2)) != 0L));
        return l;
    }

    public long tryReadLock(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        if (!Thread.interrupted()) {
            long l3;
            long l4 = this.state;
            long l5 = l4 & 0xFFL;
            if (l5 != 128L && (l5 < 126L ? U.compareAndSwapLong(this, STATE, l4, l3 = l4 + 1L) : (l3 = this.tryIncReaderOverflow(l4)) != 0L)) {
                return l3;
            }
            if (l2 <= 0L) {
                return 0L;
            }
            long l6 = System.nanoTime() + l2;
            if (l6 == 0L) {
                l6 = 1L;
            }
            if ((l3 = this.acquireRead(true, l6)) != 1L) {
                return l3;
            }
        }
        throw new InterruptedException();
    }

    public long readLockInterruptibly() throws InterruptedException {
        long l;
        if (!Thread.interrupted() && (l = this.acquireRead(true, 0L)) != 1L) {
            return l;
        }
        throw new InterruptedException();
    }

    public long tryOptimisticRead() {
        long l = this.state;
        return (l & 0x80L) == 0L ? l & 0xFFFFFFFFFFFFFF80L : 0L;
    }

    public boolean validate(long l) {
        U.loadFence();
        return (l & 0xFFFFFFFFFFFFFF80L) == (this.state & 0xFFFFFFFFFFFFFF80L);
    }

    public void unlockWrite(long l) {
        if (this.state != l || (l & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (l += 128L) == 0L ? 256L : l;
        WNode wNode = this.whead;
        if (wNode != null && wNode.status != 0) {
            this.release(wNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlockRead(long l) {
        while (true) {
            long l2;
            long l3;
            if (((l3 = this.state) & 0xFFFFFFFFFFFFFF80L) != (l & 0xFFFFFFFFFFFFFF80L) || (l & 0xFFL) == 0L || (l2 = l3 & 0xFFL) == 0L || l2 == 128L) {
                throw new IllegalMonitorStateException();
            }
            if (l2 < 126L) {
                WNode wNode;
                if (!U.compareAndSwapLong(this, STATE, l3, l3 - 1L)) continue;
                if (l2 != 1L || (wNode = this.whead) == null || wNode.status == 0) return;
                this.release(wNode);
                return;
            }
            if (this.tryDecReaderOverflow(l3) != 0L) return;
        }
    }

    public void unlock(long l) {
        long l2;
        long l3;
        long l4 = l & 0xFFL;
        while (((l3 = this.state) & 0xFFFFFFFFFFFFFF80L) == (l & 0xFFFFFFFFFFFFFF80L) && (l2 = l3 & 0xFFL) != 0L) {
            if (l2 == 128L) {
                if (l4 != l2) break;
                this.state = (l3 += 128L) == 0L ? 256L : l3;
                WNode wNode = this.whead;
                if (wNode != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return;
            }
            if (l4 == 0L || l4 >= 128L) break;
            if (l2 < 126L) {
                WNode wNode;
                if (!U.compareAndSwapLong(this, STATE, l3, l3 - 1L)) continue;
                if (l2 == 1L && (wNode = this.whead) != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return;
            }
            if (this.tryDecReaderOverflow(l3) == 0L) continue;
            return;
        }
        throw new IllegalMonitorStateException();
    }

    public long tryConvertToWriteLock(long l) {
        long l2;
        long l3 = l & 0xFFL;
        while (((l2 = this.state) & 0xFFFFFFFFFFFFFF80L) == (l & 0xFFFFFFFFFFFFFF80L)) {
            long l4;
            long l5 = l2 & 0xFFL;
            if (l5 == 0L) {
                if (l3 != 0L) break;
                l4 = l2 + 128L;
                if (!U.compareAndSwapLong(this, STATE, l2, l4)) continue;
                return l4;
            }
            if (l5 == 128L) {
                if (l3 != l5) break;
                return l;
            }
            if (l5 != 1L || l3 == 0L) break;
            l4 = l2 - 1L + 128L;
            if (!U.compareAndSwapLong(this, STATE, l2, l4)) continue;
            return l4;
        }
        return 0L;
    }

    public long tryConvertToReadLock(long l) {
        long l2;
        long l3 = l & 0xFFL;
        while (((l2 = this.state) & 0xFFFFFFFFFFFFFF80L) == (l & 0xFFFFFFFFFFFFFF80L)) {
            long l4;
            long l5 = l2 & 0xFFL;
            if (l5 == 0L) {
                if (l3 != 0L) break;
                if (!(l5 < 126L ? U.compareAndSwapLong(this, STATE, l2, l4 = l2 + 1L) : (l4 = this.tryIncReaderOverflow(l2)) != 0L)) continue;
                return l4;
            }
            if (l5 == 128L) {
                if (l3 != l5) break;
                this.state = l4 = l2 + 129L;
                WNode wNode = this.whead;
                if (wNode != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return l4;
            }
            if (l3 == 0L || l3 >= 128L) break;
            return l;
        }
        return 0L;
    }

    public long tryConvertToOptimisticRead(long l) {
        long l2;
        long l3 = l & 0xFFL;
        U.loadFence();
        while (((l2 = this.state) & 0xFFFFFFFFFFFFFF80L) == (l & 0xFFFFFFFFFFFFFF80L)) {
            long l4;
            long l5 = l2 & 0xFFL;
            if (l5 == 0L) {
                if (l3 != 0L) break;
                return l2;
            }
            if (l5 == 128L) {
                if (l3 != l5) break;
                l4 = (l2 += 128L) == 0L ? 256L : l2;
                this.state = l4;
                WNode wNode = this.whead;
                if (wNode != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return l4;
            }
            if (l3 == 0L || l3 >= 128L) break;
            if (l5 < 126L) {
                WNode wNode;
                l4 = l2 - 1L;
                if (!U.compareAndSwapLong(this, STATE, l2, l4)) continue;
                if (l5 == 1L && (wNode = this.whead) != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return l4 & 0xFFFFFFFFFFFFFF80L;
            }
            l4 = this.tryDecReaderOverflow(l2);
            if (l4 == 0L) continue;
            return l4 & 0xFFFFFFFFFFFFFF80L;
        }
        return 0L;
    }

    public boolean tryUnlockWrite() {
        long l = this.state;
        if ((l & 0x80L) != 0L) {
            this.state = (l += 128L) == 0L ? 256L : l;
            WNode wNode = this.whead;
            if (wNode != null && wNode.status != 0) {
                this.release(wNode);
            }
            return true;
        }
        return false;
    }

    public boolean tryUnlockRead() {
        long l;
        long l2;
        while ((l2 = (l = this.state) & 0xFFL) != 0L && l2 < 128L) {
            if (l2 < 126L) {
                WNode wNode;
                if (!U.compareAndSwapLong(this, STATE, l, l - 1L)) continue;
                if (l2 == 1L && (wNode = this.whead) != null && wNode.status != 0) {
                    this.release(wNode);
                }
                return true;
            }
            if (this.tryDecReaderOverflow(l) == 0L) continue;
            return true;
        }
        return false;
    }

    private int getReadLockCount(long l) {
        long l2 = l & 0x7FL;
        if (l2 >= 126L) {
            l2 = 126L + (long)this.readerOverflow;
        }
        return (int)l2;
    }

    public boolean isWriteLocked() {
        return (this.state & 0x80L) != 0L;
    }

    public boolean isReadLocked() {
        return (this.state & 0x7FL) != 0L;
    }

    public int getReadLockCount() {
        return this.getReadLockCount(this.state);
    }

    public String toString() {
        long l = this.state;
        return super.toString() + ((l & 0xFFL) == 0L ? "[Unlocked]" : ((l & 0x80L) != 0L ? "[Write-locked]" : "[Read-locks:" + this.getReadLockCount(l) + "]"));
    }

    public Lock asReadLock() {
        ReadLockView readLockView = this.readLockView;
        return readLockView != null ? readLockView : (this.readLockView = new ReadLockView());
    }

    public Lock asWriteLock() {
        WriteLockView writeLockView = this.writeLockView;
        return writeLockView != null ? writeLockView : (this.writeLockView = new WriteLockView());
    }

    public ReadWriteLock asReadWriteLock() {
        ReadWriteLockView readWriteLockView = this.readWriteLockView;
        return readWriteLockView != null ? readWriteLockView : (this.readWriteLockView = new ReadWriteLockView());
    }

    final void unstampedUnlockWrite() {
        long l = this.state;
        if ((l & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (l += 128L) == 0L ? 256L : l;
        WNode wNode = this.whead;
        if (wNode != null && wNode.status != 0) {
            this.release(wNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void unstampedUnlockRead() {
        while (true) {
            long l;
            long l2;
            if ((l2 = (l = this.state) & 0xFFL) == 0L || l2 >= 128L) {
                throw new IllegalMonitorStateException();
            }
            if (l2 < 126L) {
                WNode wNode;
                if (!U.compareAndSwapLong(this, STATE, l, l - 1L)) continue;
                if (l2 != 1L || (wNode = this.whead) == null || wNode.status == 0) return;
                this.release(wNode);
                return;
            }
            if (this.tryDecReaderOverflow(l) != 0L) return;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.state = 256L;
    }

    private long tryIncReaderOverflow(long l) {
        if ((l & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, l, l | 0x7FL)) {
                ++this.readerOverflow;
                this.state = l;
                return l;
            }
        } else if ((LockSupport.nextSecondarySeed() & 7) == 0) {
            Thread.yield();
        }
        return 0L;
    }

    private long tryDecReaderOverflow(long l) {
        if ((l & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, l, l | 0x7FL)) {
                long l2;
                int n = this.readerOverflow;
                if (n > 0) {
                    this.readerOverflow = n - 1;
                    l2 = l;
                } else {
                    l2 = l - 1L;
                }
                this.state = l2;
                return l2;
            }
        } else if ((LockSupport.nextSecondarySeed() & 7) == 0) {
            Thread.yield();
        }
        return 0L;
    }

    private void release(WNode wNode) {
        if (wNode != null) {
            Thread thread;
            U.compareAndSwapInt(wNode, WSTATUS, -1, 0);
            WNode wNode2 = wNode.next;
            if (wNode2 == null || wNode2.status == 1) {
                WNode wNode3 = this.wtail;
                while (wNode3 != null && wNode3 != wNode) {
                    if (wNode3.status <= 0) {
                        wNode2 = wNode3;
                    }
                    wNode3 = wNode3.prev;
                }
            }
            if (wNode2 != null && (thread = wNode2.thread) != null) {
                U.unpark(thread);
            }
        }
    }

    private long acquireWrite(boolean bl, long l) {
        Object object;
        WNode wNode;
        WNode wNode2 = null;
        int n = -1;
        while (true) {
            long l2;
            long l3;
            if ((l3 = (l2 = this.state) & 0xFFL) == 0L) {
                long l4 = l2 + 128L;
                if (!U.compareAndSwapLong(this, STATE, l2, l4)) continue;
                return l4;
            }
            if (n < 0) {
                n = l3 == 128L && this.wtail == this.whead ? SPINS : 0;
                continue;
            }
            if (n > 0) {
                if (LockSupport.nextSecondarySeed() < 0) continue;
                --n;
                continue;
            }
            wNode = this.wtail;
            if (wNode == null) {
                object = new WNode(1, null);
                if (!U.compareAndSwapObject(this, WHEAD, null, object)) continue;
                this.wtail = object;
                continue;
            }
            if (wNode2 == null) {
                wNode2 = new WNode(1, wNode);
                continue;
            }
            if (wNode2.prev != wNode) {
                wNode2.prev = wNode;
                continue;
            }
            if (U.compareAndSwapObject(this, WTAIL, wNode, wNode2)) break;
        }
        wNode.next = wNode2;
        n = -1;
        while (true) {
            long l5;
            WNode wNode3;
            if ((wNode3 = this.whead) == wNode) {
                if (n < 0) {
                    n = HEAD_SPINS;
                } else if (n < MAX_HEAD_SPINS) {
                    n <<= 1;
                }
                int n2 = n;
                while (true) {
                    long l6;
                    if (((l6 = this.state) & 0xFFL) == 0L) {
                        long l7 = l6 + 128L;
                        if (!U.compareAndSwapLong(this, STATE, l6, l7)) continue;
                        this.whead = wNode2;
                        wNode2.prev = null;
                        return l7;
                    }
                    if (LockSupport.nextSecondarySeed() >= 0 && --n2 <= 0) break;
                }
            } else if (wNode3 != null) {
                WNode wNode4;
                while ((wNode4 = wNode3.cowait) != null) {
                    Thread thread;
                    if (!U.compareAndSwapObject(wNode3, WCOWAIT, wNode4, wNode4.cowait) || (thread = wNode4.thread) == null) continue;
                    U.unpark(thread);
                }
            }
            if (this.whead != wNode3) continue;
            WNode wNode5 = wNode2.prev;
            if (wNode5 != wNode) {
                if (wNode5 == null) continue;
                wNode = wNode5;
                wNode5.next = wNode2;
                continue;
            }
            int n3 = wNode.status;
            if (n3 == 0) {
                U.compareAndSwapInt(wNode, WSTATUS, 0, -1);
                continue;
            }
            if (n3 == 1) {
                WNode wNode6 = wNode.prev;
                if (wNode6 == null) continue;
                wNode2.prev = wNode6;
                wNode6.next = wNode2;
                continue;
            }
            if (l == 0L) {
                l5 = 0L;
            } else {
                l5 = l - System.nanoTime();
                if (l5 <= 0L) {
                    return this.cancelWaiter(wNode2, wNode2, false);
                }
            }
            object = Thread.currentThread();
            U.putObject(object, PARKBLOCKER, (Object)this);
            wNode2.thread = object;
            if (wNode.status < 0 && (wNode != wNode3 || (this.state & 0xFFL) != 0L) && this.whead == wNode3 && wNode2.prev == wNode) {
                U.park(false, l5);
            }
            wNode2.thread = null;
            U.putObject(object, PARKBLOCKER, null);
            if (bl && Thread.interrupted()) break;
        }
        return this.cancelWaiter(wNode2, wNode2, true);
    }

    private long acquireRead(boolean bl, long l) {
        WNode wNode;
        WNode wNode2;
        WNode wNode3;
        int n;
        WNode wNode4;
        block37: {
            wNode4 = null;
            n = -1;
            block0: while (true) {
                if ((wNode3 = this.whead) == (wNode2 = this.wtail)) {
                    while (true) {
                        long l2;
                        long l3;
                        long l4;
                        if ((l4 = (l3 = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, l3, l2 = l3 + 1L) : l4 < 128L && (l2 = this.tryIncReaderOverflow(l3)) != 0L) {
                            return l2;
                        }
                        if (l4 < 128L) continue;
                        if (n > 0) {
                            if (LockSupport.nextSecondarySeed() < 0) continue;
                            --n;
                            continue;
                        }
                        if (n == 0) {
                            WNode wNode5 = this.whead;
                            WNode wNode6 = this.wtail;
                            if (wNode5 == wNode3 && wNode6 == wNode2 || (wNode3 = wNode5) != (wNode2 = wNode6)) break;
                        }
                        n = SPINS;
                    }
                }
                if (wNode2 == null) {
                    WNode wNode7 = new WNode(1, null);
                    if (!U.compareAndSwapObject(this, WHEAD, null, wNode7)) continue;
                    this.wtail = wNode7;
                    continue;
                }
                if (wNode4 == null) {
                    wNode4 = new WNode(0, wNode2);
                    continue;
                }
                if (wNode3 == wNode2 || wNode2.mode != 0) {
                    if (wNode4.prev != wNode2) {
                        wNode4.prev = wNode2;
                        continue;
                    }
                    if (!U.compareAndSwapObject(this, WTAIL, wNode2, wNode4)) continue;
                    break block37;
                }
                wNode4.cowait = wNode2.cowait;
                if (!U.compareAndSwapObject(wNode2, WCOWAIT, wNode4.cowait, wNode4)) {
                    wNode4.cowait = null;
                    continue;
                }
                while (true) {
                    long l5;
                    WNode wNode8;
                    Thread thread;
                    if ((wNode3 = this.whead) != null && (wNode = wNode3.cowait) != null && U.compareAndSwapObject(wNode3, WCOWAIT, wNode, wNode.cowait) && (thread = wNode.thread) != null) {
                        U.unpark(thread);
                    }
                    if (wNode3 == (wNode8 = wNode2.prev) || wNode3 == wNode2 || wNode8 == null) {
                        do {
                            long l6;
                            long l7;
                            if (!((l5 = (l7 = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, l7, l6 = l7 + 1L) : l5 < 128L && (l6 = this.tryIncReaderOverflow(l7)) != 0L)) continue;
                            return l6;
                        } while (l5 < 128L);
                    }
                    if (this.whead != wNode3 || wNode2.prev != wNode8) continue;
                    if (wNode8 == null || wNode3 == wNode2 || wNode2.status > 0) {
                        wNode4 = null;
                        continue block0;
                    }
                    if (l == 0L) {
                        l5 = 0L;
                    } else {
                        l5 = l - System.nanoTime();
                        if (l5 <= 0L) {
                            return this.cancelWaiter(wNode4, wNode2, false);
                        }
                    }
                    Thread thread2 = Thread.currentThread();
                    U.putObject((Object)thread2, PARKBLOCKER, (Object)this);
                    wNode4.thread = thread2;
                    if ((wNode3 != wNode8 || (this.state & 0xFFL) == 128L) && this.whead == wNode3 && wNode2.prev == wNode8) {
                        U.park(false, l5);
                    }
                    wNode4.thread = null;
                    U.putObject((Object)thread2, PARKBLOCKER, null);
                    if (bl && Thread.interrupted()) break block0;
                }
                break;
            }
            return this.cancelWaiter(wNode4, wNode2, true);
        }
        wNode2.next = wNode4;
        n = -1;
        while (true) {
            long l8;
            if ((wNode3 = this.whead) == wNode2) {
                long l9;
                if (n < 0) {
                    n = HEAD_SPINS;
                } else if (n < MAX_HEAD_SPINS) {
                    n <<= 1;
                }
                int n2 = n;
                do {
                    WNode wNode9;
                    long l10;
                    long l11;
                    if (!((l9 = (l11 = this.state) & 0xFFL) < 126L ? U.compareAndSwapLong(this, STATE, l11, l10 = l11 + 1L) : l9 < 128L && (l10 = this.tryIncReaderOverflow(l11)) != 0L)) continue;
                    this.whead = wNode4;
                    wNode4.prev = null;
                    while ((wNode9 = wNode4.cowait) != null) {
                        Thread thread;
                        if (!U.compareAndSwapObject(wNode4, WCOWAIT, wNode9, wNode9.cowait) || (thread = wNode9.thread) == null) continue;
                        U.unpark(thread);
                    }
                    return l10;
                } while (l9 < 128L || LockSupport.nextSecondarySeed() < 0 || --n2 > 0);
            } else if (wNode3 != null) {
                WNode wNode10;
                while ((wNode10 = wNode3.cowait) != null) {
                    Thread thread;
                    if (!U.compareAndSwapObject(wNode3, WCOWAIT, wNode10, wNode10.cowait) || (thread = wNode10.thread) == null) continue;
                    U.unpark(thread);
                }
            }
            if (this.whead != wNode3) continue;
            WNode wNode11 = wNode4.prev;
            if (wNode11 != wNode2) {
                if (wNode11 == null) continue;
                wNode2 = wNode11;
                wNode11.next = wNode4;
                continue;
            }
            int n3 = wNode2.status;
            if (n3 == 0) {
                U.compareAndSwapInt(wNode2, WSTATUS, 0, -1);
                continue;
            }
            if (n3 == 1) {
                wNode = wNode2.prev;
                if (wNode == null) continue;
                wNode4.prev = wNode;
                wNode.next = wNode4;
                continue;
            }
            if (l == 0L) {
                l8 = 0L;
            } else {
                l8 = l - System.nanoTime();
                if (l8 <= 0L) {
                    return this.cancelWaiter(wNode4, wNode4, false);
                }
            }
            Thread thread = Thread.currentThread();
            U.putObject((Object)thread, PARKBLOCKER, (Object)this);
            wNode4.thread = thread;
            if (wNode2.status < 0 && (wNode2 != wNode3 || (this.state & 0xFFL) == 128L) && this.whead == wNode3 && wNode4.prev == wNode2) {
                U.park(false, l8);
            }
            wNode4.thread = null;
            U.putObject((Object)thread, PARKBLOCKER, null);
            if (bl && Thread.interrupted()) break;
        }
        return this.cancelWaiter(wNode4, wNode4, true);
    }

    private long cancelWaiter(WNode wNode, WNode wNode2, boolean bl) {
        WNode wNode3;
        WNode wNode4;
        Object object;
        if (wNode != null && wNode2 != null) {
            WNode wNode5;
            wNode.status = 1;
            WNode wNode6 = wNode2;
            while ((wNode5 = wNode6.cowait) != null) {
                if (wNode5.status == 1) {
                    U.compareAndSwapObject(wNode6, WCOWAIT, wNode5, wNode5.cowait);
                    wNode6 = wNode2;
                    continue;
                }
                wNode6 = wNode5;
            }
            if (wNode2 == wNode) {
                wNode6 = wNode2.cowait;
                while (wNode6 != null) {
                    object = wNode6.thread;
                    if (object != null) {
                        U.unpark(object);
                    }
                    wNode6 = wNode6.cowait;
                }
                wNode6 = wNode.prev;
                while (wNode6 != null) {
                    while ((wNode5 = wNode.next) == null || wNode5.status == 1) {
                        wNode4 = null;
                        WNode wNode7 = this.wtail;
                        while (wNode7 != null && wNode7 != wNode) {
                            if (wNode7.status != 1) {
                                wNode4 = wNode7;
                            }
                            wNode7 = wNode7.prev;
                        }
                        if (wNode5 != wNode4 && !U.compareAndSwapObject(wNode, WNEXT, wNode5, wNode5 = wNode4)) continue;
                        if (wNode5 != null || wNode != this.wtail) break;
                        U.compareAndSwapObject(this, WTAIL, wNode, wNode6);
                        break;
                    }
                    if (wNode6.next == wNode) {
                        U.compareAndSwapObject(wNode6, WNEXT, wNode, wNode5);
                    }
                    if (wNode5 != null && (object = wNode5.thread) != null) {
                        wNode5.thread = null;
                        U.unpark(object);
                    }
                    if (wNode6.status != 1 || (wNode3 = wNode6.prev) == null) break;
                    wNode.prev = wNode3;
                    U.compareAndSwapObject(wNode3, WNEXT, wNode6, wNode5);
                    wNode6 = wNode3;
                }
            }
        }
        while ((object = this.whead) != null) {
            long l;
            wNode3 = ((WNode)object).next;
            if (wNode3 == null || wNode3.status == 1) {
                wNode4 = this.wtail;
                while (wNode4 != null && wNode4 != object) {
                    if (wNode4.status <= 0) {
                        wNode3 = wNode4;
                    }
                    wNode4 = wNode4.prev;
                }
            }
            if (object != this.whead) continue;
            if (wNode3 == null || ((WNode)object).status != 0 || ((l = this.state) & 0xFFL) == 128L || l != 0L && wNode3.mode != 0) break;
            this.release((WNode)object);
            break;
        }
        return bl || Thread.interrupted() ? 1L : 0L;
    }

    static {
        try {
            U = Unsafe.getUnsafe();
            Class<StampedLock> clazz = StampedLock.class;
            Class<WNode> clazz2 = WNode.class;
            STATE = U.objectFieldOffset(clazz.getDeclaredField("state"));
            WHEAD = U.objectFieldOffset(clazz.getDeclaredField("whead"));
            WTAIL = U.objectFieldOffset(clazz.getDeclaredField("wtail"));
            WSTATUS = U.objectFieldOffset(clazz2.getDeclaredField("status"));
            WNEXT = U.objectFieldOffset(clazz2.getDeclaredField("next"));
            WCOWAIT = U.objectFieldOffset(clazz2.getDeclaredField("cowait"));
            Class<Thread> clazz3 = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(clazz3.getDeclaredField("parkBlocker"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    final class ReadWriteLockView
    implements ReadWriteLock {
        ReadWriteLockView() {
        }

        @Override
        public Lock readLock() {
            return StampedLock.this.asReadLock();
        }

        @Override
        public Lock writeLock() {
            return StampedLock.this.asWriteLock();
        }
    }

    final class WriteLockView
    implements Lock {
        WriteLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.writeLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.writeLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryWriteLock() != 0L;
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return StampedLock.this.tryWriteLock(l, timeUnit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockWrite();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    final class ReadLockView
    implements Lock {
        ReadLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.readLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.readLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryReadLock() != 0L;
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return StampedLock.this.tryReadLock(l, timeUnit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockRead();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    static final class WNode {
        volatile WNode prev;
        volatile WNode next;
        volatile WNode cowait;
        volatile Thread thread;
        volatile int status;
        final int mode;

        WNode(int n, WNode wNode) {
            this.mode = n;
            this.prev = wNode;
        }
    }
}

