/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CryptoPermissionCollection;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

class CryptoPermission
extends Permission {
    private static final long serialVersionUID = 8987399626114087514L;
    private String alg;
    private int maxKeySize = Integer.MAX_VALUE;
    private String exemptionMechanism = null;
    private AlgorithmParameterSpec algParamSpec = null;
    private boolean checkParam = false;
    static final String ALG_NAME_WILDCARD = "*";

    CryptoPermission(String string) {
        super(null);
        this.alg = string;
    }

    CryptoPermission(String string, int n) {
        super(null);
        this.alg = string;
        this.maxKeySize = n;
    }

    CryptoPermission(String string, int n, AlgorithmParameterSpec algorithmParameterSpec) {
        super(null);
        this.alg = string;
        this.maxKeySize = n;
        this.checkParam = true;
        this.algParamSpec = algorithmParameterSpec;
    }

    CryptoPermission(String string, String string2) {
        super(null);
        this.alg = string;
        this.exemptionMechanism = string2;
    }

    CryptoPermission(String string, int n, String string2) {
        super(null);
        this.alg = string;
        this.exemptionMechanism = string2;
        this.maxKeySize = n;
    }

    CryptoPermission(String string, int n, AlgorithmParameterSpec algorithmParameterSpec, String string2) {
        super(null);
        this.alg = string;
        this.exemptionMechanism = string2;
        this.maxKeySize = n;
        this.checkParam = true;
        this.algParamSpec = algorithmParameterSpec;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof CryptoPermission)) {
            return false;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)permission;
        if (!this.alg.equalsIgnoreCase(cryptoPermission.alg) && !this.alg.equalsIgnoreCase(ALG_NAME_WILDCARD)) {
            return false;
        }
        if (cryptoPermission.maxKeySize <= this.maxKeySize) {
            if (!this.impliesParameterSpec(cryptoPermission.checkParam, cryptoPermission.algParamSpec)) {
                return false;
            }
            if (this.impliesExemptionMechanism(cryptoPermission.exemptionMechanism)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CryptoPermission)) {
            return false;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)object;
        if (!this.alg.equalsIgnoreCase(cryptoPermission.alg) || this.maxKeySize != cryptoPermission.maxKeySize) {
            return false;
        }
        if (this.checkParam != cryptoPermission.checkParam) {
            return false;
        }
        return this.equalObjects(this.exemptionMechanism, cryptoPermission.exemptionMechanism) && this.equalObjects(this.algParamSpec, cryptoPermission.algParamSpec);
    }

    @Override
    public int hashCode() {
        int n = this.alg.hashCode();
        n ^= this.maxKeySize;
        if (this.exemptionMechanism != null) {
            n ^= this.exemptionMechanism.hashCode();
        }
        if (this.checkParam) {
            n ^= 0x64;
        }
        if (this.algParamSpec != null) {
            n ^= this.algParamSpec.hashCode();
        }
        return n;
    }

    @Override
    public String getActions() {
        return null;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new CryptoPermissionCollection();
    }

    final String getAlgorithm() {
        return this.alg;
    }

    final String getExemptionMechanism() {
        return this.exemptionMechanism;
    }

    final int getMaxKeySize() {
        return this.maxKeySize;
    }

    final boolean getCheckParam() {
        return this.checkParam;
    }

    final AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algParamSpec;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("(CryptoPermission " + this.alg + " " + this.maxKeySize);
        if (this.algParamSpec != null) {
            if (this.algParamSpec instanceof RC2ParameterSpec) {
                stringBuilder.append(" , effective " + ((RC2ParameterSpec)this.algParamSpec).getEffectiveKeyBits());
            } else if (this.algParamSpec instanceof RC5ParameterSpec) {
                stringBuilder.append(" , rounds " + ((RC5ParameterSpec)this.algParamSpec).getRounds());
            }
        }
        if (this.exemptionMechanism != null) {
            stringBuilder.append(" " + this.exemptionMechanism);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean impliesExemptionMechanism(String string) {
        if (this.exemptionMechanism == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return this.exemptionMechanism.equals(string);
    }

    private boolean impliesParameterSpec(boolean bl, AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.checkParam && bl) {
            if (algorithmParameterSpec == null) {
                return true;
            }
            if (this.algParamSpec == null) {
                return false;
            }
            if (this.algParamSpec.getClass() != algorithmParameterSpec.getClass()) {
                return false;
            }
            if (algorithmParameterSpec instanceof RC2ParameterSpec && ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits() <= ((RC2ParameterSpec)this.algParamSpec).getEffectiveKeyBits()) {
                return true;
            }
            if (algorithmParameterSpec instanceof RC5ParameterSpec && ((RC5ParameterSpec)algorithmParameterSpec).getRounds() <= ((RC5ParameterSpec)this.algParamSpec).getRounds()) {
                return true;
            }
            if (algorithmParameterSpec instanceof PBEParameterSpec && ((PBEParameterSpec)algorithmParameterSpec).getIterationCount() <= ((PBEParameterSpec)this.algParamSpec).getIterationCount()) {
                return true;
            }
            return this.algParamSpec.equals(algorithmParameterSpec);
        }
        return !this.checkParam;
    }

    private boolean equalObjects(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }
}

