/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;

class XPathFactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xpath.internal";
    private static SecuritySupport ss = new SecuritySupport();
    private static boolean debug = false;
    private static Properties cacheProps;
    private static volatile boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public XPathFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        XPathFactory f = this._newFactory(uri);
        if (f != null) {
            XPathFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + uri);
        } else {
            XPathFactoryFinder.debugPrintln("unable to find a factory for " + uri);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String uri) {
        XPathFactory xpathFactory;
        block19: {
            String propertyName;
            block18: {
                propertyName = SERVICE_CLASS.getName() + ":" + uri;
                try {
                    XPathFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    String r = ss.getSystemProperty(propertyName);
                    if (r != null) {
                        XPathFactoryFinder.debugPrintln("The value is '" + r + "'");
                        xpathFactory = this.createInstance(r, true);
                        if (xpathFactory != null) {
                            return xpathFactory;
                        }
                    } else {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block18;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = ss.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                XPathFactoryFinder.debugPrintln("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                XPathFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                if (factoryClassName != null && (xpathFactory = this.createInstance(factoryClassName, true)) != null) {
                    return xpathFactory;
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        Iterator sitr = this.createServiceFileIterator();
        while (sitr.hasNext()) {
            URL resource = (URL)sitr.next();
            XPathFactoryFinder.debugPrintln("looking into " + resource);
            try {
                xpathFactory = this.loadFromService(uri, resource.toExternalForm(), ss.getURLInputStream(resource));
                if (xpathFactory == null) continue;
                return xpathFactory;
            }
            catch (IOException e) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (uri.equals("http://java.sun.com/jaxp/xpath/dom")) {
            XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            return this.createInstance("com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", true);
        }
        XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class createClass(String className) {
        Class<?> clazz;
        boolean internal = false;
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            internal = true;
        }
        try {
            clazz = this.classLoader != null && !internal ? this.classLoader.loadClass(className) : Class.forName(className);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    XPathFactory createInstance(String className) {
        return this.createInstance(className, false);
    }

    XPathFactory createInstance(String className, boolean useServicesMechanism) {
        XPathFactory xPathFactory = null;
        XPathFactoryFinder.debugPrintln("createInstance(" + className + ")");
        Class clazz = this.createClass(className);
        if (clazz == null) {
            XPathFactoryFinder.debugPrintln("failed to getClass(" + className + ")");
            return null;
        }
        XPathFactoryFinder.debugPrintln("loaded " + className + " from " + XPathFactoryFinder.which(clazz));
        try {
            if (!useServicesMechanism) {
                xPathFactory = (XPathFactory)XPathFactoryFinder.newInstanceNoServiceLoader(clazz);
            }
            if (xPathFactory == null) {
                xPathFactory = (XPathFactory)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return xPathFactory;
    }

    private static Object newInstanceNoServiceLoader(Class<?> providerClass) {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method creationMethod = providerClass.getDeclaredMethod("newXPathFactoryNoServiceLoader", new Class[0]);
            return creationMethod.invoke(null, null);
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private XPathFactory loadFromService(String objectModel, String inputName, InputStream in) throws IOException {
        XPathFactory xPathFactory = null;
        Class[] stringClassArray = new Class[]{"".getClass()};
        Object[] objectModelObjectArray = new Object[]{objectModel};
        String isObjectModelSupportedMethod = "isObjectModelSupported";
        XPathFactoryFinder.debugPrintln("Reading " + inputName);
        BufferedReader configFile = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = configFile.readLine()) != null) {
            Class clazz;
            int comment = line.indexOf("#");
            switch (comment) {
                case -1: {
                    break;
                }
                case 0: {
                    line = "";
                    break;
                }
                default: {
                    line = line.substring(0, comment);
                }
            }
            if ((line = line.trim()).length() == 0 || (clazz = this.createClass(line)) == null) continue;
            try {
                xPathFactory = (XPathFactory)clazz.newInstance();
            }
            catch (ClassCastException classCastExcpetion) {
                xPathFactory = null;
                continue;
            }
            catch (InstantiationException instantiationException) {
                xPathFactory = null;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                xPathFactory = null;
                continue;
            }
            try {
                Method isObjectModelSupported = clazz.getMethod("isObjectModelSupported", stringClassArray);
                Boolean supported = (Boolean)isObjectModelSupported.invoke(xPathFactory, objectModelObjectArray);
                if (supported.booleanValue()) {
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            xPathFactory = null;
        }
        configFile.close();
        return xPathFactory;
    }

    private XPathFactory loadFromProperty(String keyName, String resourceName, InputStream in) throws IOException {
        XPathFactoryFinder.debugPrintln("Reading " + resourceName);
        Properties props = new Properties();
        props.load(in);
        in.close();
        String factoryClassName = props.getProperty(keyName);
        if (factoryClassName != null) {
            XPathFactoryFinder.debugPrintln("found " + keyName + " = " + factoryClassName);
            return this.createInstance(factoryClassName, true);
        }
        XPathFactoryFinder.debugPrintln(keyName + " is not in the property file");
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                @Override
                protected Object value() {
                    ClassLoader classLoader = XPathFactoryFinder.class.getClassLoader();
                    return ss.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration e = ss.getResources(this.classLoader, SERVICE_ID);
            if (!e.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                public Object next() {
                    return e.nextElement();
                }
            };
        }
        catch (IOException e) {
            XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                e.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = ss.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception _) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = XPathFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

