/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    public BandedSampleModel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, 1, n2, BandedSampleModel.createIndicesArray(n4), BandedSampleModel.createOffsetArray(n4));
    }

    public BandedSampleModel(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        super(n, n2, n3, 1, n4, nArray, nArray2);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = this.numBanks == 1 ? this.orderBands(this.bandOffsets, n * n2) : new int[this.bandOffsets.length];
        BandedSampleModel bandedSampleModel = new BandedSampleModel(this.dataType, n, n2, n, this.bankIndices, nArray);
        return bandedSampleModel;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.bankIndices[nArray[i]];
            nArray3[i] = this.bandOffsets[nArray[i]];
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2, nArray3);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n, this.numBanks);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataType is not one of the supported types.");
            }
        }
        return dataBuffer;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n4] : (float[])object;
                for (int i = 0; i < n4; ++i) {
                    fArray[i] = dataBuffer.getElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n4] : (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dArray[i] = dataBuffer.getElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = dArray;
            }
        }
        return object;
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = n2 * this.scanlineStride + n;
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = dataBuffer.getElem(this.bankIndices[i], n3 + this.bandOffsets[i]);
        }
        return nArray2;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            int n7 = n2 * this.scanlineStride + n + this.bandOffsets[i];
            int n8 = i;
            int n9 = this.bankIndices[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n7;
                for (int k = 0; k < n3; ++k) {
                    nArray2[n8] = dataBuffer.getElem(n9, n10++);
                    n8 += this.numBands;
                }
                n7 += this.scanlineStride;
            }
        }
        return nArray2;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = dataBuffer.getElem(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return n4;
    }

    @Override
    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return f;
    }

    @Override
    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return d;
    }

    @Override
    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = this.bankIndices[n5];
        for (int i = 0; i < n4; ++i) {
            int n9 = n6;
            for (int j = 0; j < n3; ++j) {
                nArray2[n7++] = dataBuffer.getElem(n8, n9++);
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], byArray[i] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], sArray[i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], nArray[i]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i], fArray[i]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i], dArray[i]);
                }
                break;
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = n2 * this.scanlineStride + n;
        for (int i = 0; i < this.numBands; ++i) {
            dataBuffer.setElem(this.bankIndices[i], n3 + this.bandOffsets[i], nArray[i]);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        for (int i = 0; i < this.numBands; ++i) {
            int n7 = n2 * this.scanlineStride + n + this.bandOffsets[i];
            int n8 = i;
            int n9 = this.bankIndices[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n7;
                for (int k = 0; k < n3; ++k) {
                    dataBuffer.setElem(n9, n10++, nArray[n8]);
                    n8 += this.numBands;
                }
                n7 += this.scanlineStride;
            }
        }
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], n4);
    }

    @Override
    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], f);
    }

    @Override
    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], d);
    }

    @Override
    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = this.bankIndices[n5];
        for (int i = 0; i < n4; ++i) {
            int n9 = n6;
            for (int j = 0; j < n3; ++j) {
                dataBuffer.setElem(n8, n9++, nArray[n7++]);
            }
            n6 += this.scanlineStride;
        }
    }

    private static int[] createOffsetArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
        return nArray;
    }

    private static int[] createIndicesArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 2;
    }
}

