/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

#include "arch.h"
#include "ecp_BLS381.h"

/* Curve BLS381 - Pairing friendly BLS curve */

#if CHUNK==16

#error Not supported

#endif

#if CHUNK==32

const int CURVE_Cof_I_BLS381= 0;
const int CURVE_A_BLS381= 0;
const int CURVE_B_I_BLS381= 4;
const BIG_384_29 CURVE_B_BLS381= {0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_384_29 CURVE_Order_BLS381= {0x1,0x1FFFFFF8,0x1F96FFBF,0x1B4805FF,0x1D80553B,0xC0404D0,0x1520CCE7,0xA6533AF,0x73EDA7,0x0,0x0,0x0,0x0,0x0};
const BIG_384_29 CURVE_Gx_BLS381= {0x1B22C6BB,0x19D78056,0x1E86BBFE,0xBD07FF2,0x1AC586C5,0x1D1F8B8D,0x4168538,0x9F2EE97,0xFC3688C,0x27D4D60,0x9A558E3,0x32FAF28,0x1F1D3A73,0xB};
const BIG_384_29 CURVE_Gy_BLS381= {0x6C5E7E1,0x551194A,0x222B903,0x198E8945,0xB3EDD03,0xC659602,0xBD8036C,0x12BABA01,0x4FCF5E0,0xBA0EC57,0x8278C3B,0x75541E3,0xB3F481E,0x4};


const BIG_384_29 CURVE_Bnx_BLS381= {0x10000,0x10080000,0x34,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_384_29 CURVE_Cof_BLS381= {0xAAAB,0x55558,0x157855A3,0x191800AA,0x396,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
const BIG_384_29 CURVE_Cru_BLS381= {0x1FFEFFFE,0x100FFFFF,0x280008B,0xFB026C4,0x9688DE1,0x149DF37C,0x1FAB76CE,0xED41EE,0x11BA69C6,0x1EFBB672,0x17C659CB,0x0,0x0,0x0};

const BIG_384_29 CURVE_Pxa_BLS381= {0x121BDB8,0x402B646,0x16EFBF5,0x18064D50,0x1D1770BA,0x5B23D71,0xC0AD144,0x1A9F4807,0x11C6E47A,0x196E2882,0x9820149,0x11E1522,0x4AA2B2F,0x1};
const BIG_384_29 CURVE_Pxb_BLS381= {0x1D042B7E,0xD63E82A,0x51755F9,0x19E22427,0x15049334,0x10DDEE3F,0x186AD769,0x1A132416,0x5596BD0,0x4413A7B,0x1F6B34E8,0x4E33EC0,0x1E02B605,0x9};
const BIG_384_29 CURVE_Pya_BLS381= {0x8B82801,0xC9AA430,0xB28A278,0x15939877,0xD12C923,0xD34A8B0,0xE9DB50A,0x155197BA,0x1AADFD9B,0x16D171A8,0x3327371,0x4FADC23,0xE5D5277,0x6};
const BIG_384_29 CURVE_Pyb_BLS381= {0x105F79BE,0x15483AFF,0x1B07686A,0xE1A4EB9,0x99AB3F3,0x955AB97,0xEBC99D2,0xFD0B4EC,0x19CB3E28,0x15E145C,0xCAB34AC,0x1D4E6998,0x6C4A02,0x3};
const BIG_384_29 CURVE_W_BLS381[2]= {{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}};
const BIG_384_29 CURVE_SB_BLS381[2][2]= {{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}};
const BIG_384_29 CURVE_WB_BLS381[4]= {{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}};
const BIG_384_29 CURVE_BB_BLS381[4][4]= {{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}},{{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}}};


#endif

#if CHUNK==64

const int CURVE_Cof_I_BLS381= 0;
const int CURVE_A_BLS381= 0;
const int CURVE_B_I_BLS381= 4;
const BIG_384_58 CURVE_B_BLS381= {0x4L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L};
const BIG_384_58 CURVE_Order_BLS381= {0x3FFFFFF00000001L,0x36900BFFF96FFBFL,0x180809A1D80553BL,0x14CA675F520CCE7L,0x73EDA7L,0x0L,0x0L};
const BIG_384_58 CURVE_Gx_BLS381= {0x33AF00ADB22C6BBL,0x17A0FFE5E86BBFEL,0x3A3F171BAC586C5L,0x13E5DD2E4168538L,0x4FA9AC0FC3688CL,0x65F5E509A558E3L,0x17F1D3A73L};
const BIG_384_58 CURVE_Gy_BLS381= {0xAA232946C5E7E1L,0x331D128A222B903L,0x18CB2C04B3EDD03L,0x25757402BD8036CL,0x1741D8AE4FCF5E0L,0xEAA83C68278C3BL,0x8B3F481EL};

const BIG_384_58 CURVE_Bnx_BLS381= {0x201000000010000L,0x34L,0x0L,0x0L,0x0L,0x0L,0x0L};
const BIG_384_58 CURVE_Cof_BLS381= {0xAAAB0000AAABL,0x3230015557855A3L,0x396L,0x0L,0x0L,0x0L,0x0L};
const BIG_384_58 CURVE_Cru_BLS381= {0x201FFFFFFFEFFFEL,0x1F604D88280008BL,0x293BE6F89688DE1L,0x1DA83DDFAB76CEL,0x3DF76CE51BA69C6L,0x17C659CBL,0x0L};

const BIG_384_58 CURVE_Pxa_BLS381= {0x8056C8C121BDB8L,0x300C9AA016EFBF5L,0xB647AE3D1770BAL,0x353E900EC0AD144L,0x32DC51051C6E47AL,0x23C2A449820149L,0x24AA2B2FL};
const BIG_384_58 CURVE_Pxb_BLS381= {0x1AC7D055D042B7EL,0x33C4484E51755F9L,0x21BBDC7F5049334L,0x3426482D86AD769L,0x88274F65596BD0L,0x9C67D81F6B34E8L,0x13E02B605L};
const BIG_384_58 CURVE_Pya_BLS381= {0x193548608B82801L,0x2B2730EEB28A278L,0x1A695160D12C923L,0x2AA32F74E9DB50AL,0x2DA2E351AADFD9BL,0x9F5B8463327371L,0xCE5D5277L};
const BIG_384_58 CURVE_Pyb_BLS381= {0x2A9075FF05F79BEL,0x1C349D73B07686AL,0x12AB572E99AB3F3L,0x1FA169D8EBC99D2L,0x2BC28B99CB3E28L,0x3A9CD330CAB34ACL,0x606C4A02L};
const BIG_384_58 CURVE_W_BLS381[2]= {{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}};
const BIG_384_58 CURVE_SB_BLS381[2][2]= {{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}}};
const BIG_384_58 CURVE_WB_BLS381[4]= {{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}};
const BIG_384_58 CURVE_BB_BLS381[4][4]= {{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}},{{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L},{0x0L,0x0L,0x0L,0x0L,0x0L,0x0L,0x0L}}};

#endif
