/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Objects;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNames;
import sun.security.x509.RDN;

public class DistributionPointName {
    private static final byte TAG_FULL_NAME = 0;
    private static final byte TAG_RELATIVE_NAME = 1;
    private GeneralNames fullName = null;
    private RDN relativeName = null;
    private volatile int hashCode;

    public DistributionPointName(GeneralNames generalNames) {
        if (generalNames == null) {
            throw new IllegalArgumentException("fullName must not be null");
        }
        this.fullName = generalNames;
    }

    public DistributionPointName(RDN rDN) {
        if (rDN == null) {
            throw new IllegalArgumentException("relativeName must not be null");
        }
        this.relativeName = rDN;
    }

    public DistributionPointName(DerValue derValue) throws IOException {
        if (derValue.isContextSpecific((byte)0) && derValue.isConstructed()) {
            derValue.resetTag((byte)48);
            this.fullName = new GeneralNames(derValue);
        } else if (derValue.isContextSpecific((byte)1) && derValue.isConstructed()) {
            derValue.resetTag((byte)49);
            this.relativeName = new RDN(derValue);
        } else {
            throw new IOException("Invalid encoding for DistributionPointName");
        }
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.fullName != null) {
            this.fullName.encode(derOutputStream2);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        } else {
            this.relativeName.encode(derOutputStream2);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DistributionPointName)) {
            return false;
        }
        DistributionPointName distributionPointName = (DistributionPointName)object;
        return Objects.equals(this.fullName, distributionPointName.fullName) && Objects.equals(this.relativeName, distributionPointName.relativeName);
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 1;
            n = this.fullName != null ? (n += this.fullName.hashCode()) : (n += this.relativeName.hashCode());
            this.hashCode = n;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fullName != null) {
            stringBuilder.append("DistributionPointName:\n     " + this.fullName + "\n");
        } else {
            stringBuilder.append("DistributionPointName:\n     " + this.relativeName + "\n");
        }
        return stringBuilder.toString();
    }
}

