/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class FileTime
implements Comparable<FileTime> {
    private final TimeUnit unit;
    private final long value;
    private Instant instant;
    private String valueAsString;
    private static final long HOURS_PER_DAY = 24L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final long DAYS_PER_10000_YEARS = 3652425L;
    private static final long SECONDS_PER_10000_YEARS = 315569520000L;
    private static final long SECONDS_0000_TO_1970 = 62167219200L;

    private FileTime(long l, TimeUnit timeUnit, Instant instant) {
        this.value = l;
        this.unit = timeUnit;
        this.instant = instant;
    }

    public static FileTime from(long l, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        return new FileTime(l, timeUnit, null);
    }

    public static FileTime fromMillis(long l) {
        return new FileTime(l, TimeUnit.MILLISECONDS, null);
    }

    public static FileTime from(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return new FileTime(0L, null, instant);
    }

    public long to(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        if (this.unit != null) {
            return timeUnit.convert(this.value, this.unit);
        }
        long l = timeUnit.convert(this.instant.getEpochSecond(), TimeUnit.SECONDS);
        if (l == Long.MIN_VALUE || l == Long.MAX_VALUE) {
            return l;
        }
        long l2 = timeUnit.convert(this.instant.getNano(), TimeUnit.NANOSECONDS);
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            return l < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return l3;
    }

    public long toMillis() {
        if (this.unit != null) {
            return this.unit.toMillis(this.value);
        }
        long l = this.instant.getEpochSecond();
        int n = this.instant.getNano();
        long l2 = l * 1000L;
        long l3 = Math.abs(l);
        if ((l3 | 0x3E8L) >>> 31 != 0L && l2 / 1000L != l) {
            return l < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return l2 + (long)(n / 1000000);
    }

    private static long scale(long l, long l2, long l3) {
        if (l > l3) {
            return Long.MAX_VALUE;
        }
        if (l < -l3) {
            return Long.MIN_VALUE;
        }
        return l * l2;
    }

    public Instant toInstant() {
        if (this.instant == null) {
            long l = 0L;
            int n = 0;
            switch (this.unit) {
                case DAYS: {
                    l = FileTime.scale(this.value, 86400L, 106751991167300L);
                    break;
                }
                case HOURS: {
                    l = FileTime.scale(this.value, 3600L, 2562047788015215L);
                    break;
                }
                case MINUTES: {
                    l = FileTime.scale(this.value, 60L, 0x222222222222222L);
                    break;
                }
                case SECONDS: {
                    l = this.value;
                    break;
                }
                case MILLISECONDS: {
                    l = Math.floorDiv(this.value, 1000L);
                    n = (int)Math.floorMod(this.value, 1000L) * 1000000;
                    break;
                }
                case MICROSECONDS: {
                    l = Math.floorDiv(this.value, 1000000L);
                    n = (int)Math.floorMod(this.value, 1000000L) * 1000;
                    break;
                }
                case NANOSECONDS: {
                    l = Math.floorDiv(this.value, 1000000000L);
                    n = (int)Math.floorMod(this.value, 1000000000L);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unit not handled");
                }
            }
            this.instant = l <= -31557014167219200L ? Instant.MIN : (l >= 31556889864403199L ? Instant.MAX : Instant.ofEpochSecond(l, n));
        }
        return this.instant;
    }

    public boolean equals(Object object) {
        return object instanceof FileTime ? this.compareTo((FileTime)object) == 0 : false;
    }

    public int hashCode() {
        return this.toInstant().hashCode();
    }

    private long toDays() {
        if (this.unit != null) {
            return this.unit.toDays(this.value);
        }
        return TimeUnit.SECONDS.toDays(this.toInstant().getEpochSecond());
    }

    private long toExcessNanos(long l) {
        if (this.unit != null) {
            return this.unit.toNanos(this.value - this.unit.convert(l, TimeUnit.DAYS));
        }
        return TimeUnit.SECONDS.toNanos(this.toInstant().getEpochSecond() - TimeUnit.DAYS.toSeconds(l));
    }

    @Override
    public int compareTo(FileTime fileTime) {
        long l;
        long l2;
        if (this.unit != null && this.unit == fileTime.unit) {
            return Long.compare(this.value, fileTime.value);
        }
        long l3 = this.toInstant().getEpochSecond();
        int n = Long.compare(l3, l2 = fileTime.toInstant().getEpochSecond());
        if (n != 0) {
            return n;
        }
        n = Long.compare(this.toInstant().getNano(), fileTime.toInstant().getNano());
        if (n != 0) {
            return n;
        }
        if (l3 != 31556889864403199L && l3 != -31557014167219200L) {
            return 0;
        }
        long l4 = this.toDays();
        if (l4 == (l = fileTime.toDays())) {
            return Long.compare(this.toExcessNanos(l4), fileTime.toExcessNanos(l));
        }
        return Long.compare(l4, l);
    }

    private StringBuilder append(StringBuilder stringBuilder, int n, int n2) {
        while (n > 0) {
            stringBuilder.append((char)(n2 / n + 48));
            n2 %= n;
            n /= 10;
        }
        return stringBuilder;
    }

    public String toString() {
        if (this.valueAsString == null) {
            LocalDateTime localDateTime;
            long l;
            long l2;
            long l3;
            long l4 = 0L;
            int n = 0;
            if (this.instant == null && this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                l4 = this.unit.toSeconds(this.value);
            } else {
                l4 = this.toInstant().getEpochSecond();
                n = this.toInstant().getNano();
            }
            int n2 = 0;
            if (l4 >= -62167219200L) {
                l3 = l4 - 315569520000L + 62167219200L;
                l2 = Math.floorDiv(l3, 315569520000L) + 1L;
                l = Math.floorMod(l3, 315569520000L);
                localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, n, ZoneOffset.UTC);
                n2 = localDateTime.getYear() + (int)l2 * 10000;
            } else {
                l3 = l4 + 62167219200L;
                l2 = l3 / 315569520000L;
                l = l3 % 315569520000L;
                localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, n, ZoneOffset.UTC);
                n2 = localDateTime.getYear() + (int)l2 * 10000;
            }
            if (n2 <= 0) {
                --n2;
            }
            int n3 = localDateTime.getNano();
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(n2 < 0 ? "-" : "");
            n2 = Math.abs(n2);
            if (n2 < 10000) {
                this.append(stringBuilder, 1000, Math.abs(n2));
            } else {
                stringBuilder.append(String.valueOf(n2));
            }
            stringBuilder.append('-');
            this.append(stringBuilder, 10, localDateTime.getMonthValue());
            stringBuilder.append('-');
            this.append(stringBuilder, 10, localDateTime.getDayOfMonth());
            stringBuilder.append('T');
            this.append(stringBuilder, 10, localDateTime.getHour());
            stringBuilder.append(':');
            this.append(stringBuilder, 10, localDateTime.getMinute());
            stringBuilder.append(':');
            this.append(stringBuilder, 10, localDateTime.getSecond());
            if (n3 != 0) {
                stringBuilder.append('.');
                int n4 = 100000000;
                while (n3 % 10 == 0) {
                    n3 /= 10;
                    n4 /= 10;
                }
                this.append(stringBuilder, n4, n3);
            }
            stringBuilder.append('Z');
            this.valueAsString = stringBuilder.toString();
        }
        return this.valueAsString;
    }
}

