/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class AdaptiveCoding
implements CodingMethod {
    CodingMethod headCoding;
    int headLength;
    CodingMethod tailCoding;
    public static final int KX_MIN = 0;
    public static final int KX_MAX = 3;
    public static final int KX_LG2BASE = 4;
    public static final int KX_BASE = 16;
    public static final int KB_MIN = 0;
    public static final int KB_MAX = 255;
    public static final int KB_OFFSET = 1;
    public static final int KB_DEFAULT = 3;

    public AdaptiveCoding(int n, CodingMethod codingMethod, CodingMethod codingMethod2) {
        assert (AdaptiveCoding.isCodableLength(n));
        this.headLength = n;
        this.headCoding = codingMethod;
        this.tailCoding = codingMethod2;
    }

    public void setHeadCoding(CodingMethod codingMethod) {
        this.headCoding = codingMethod;
    }

    public void setHeadLength(int n) {
        assert (AdaptiveCoding.isCodableLength(n));
        this.headLength = n;
    }

    public void setTailCoding(CodingMethod codingMethod) {
        this.tailCoding = codingMethod;
    }

    public boolean isTrivial() {
        return this.headCoding == this.tailCoding;
    }

    @Override
    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        AdaptiveCoding.writeArray(this, outputStream, nArray, n, n2);
    }

    private static void writeArray(AdaptiveCoding adaptiveCoding, OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        while (true) {
            int n3 = n + adaptiveCoding.headLength;
            assert (n3 <= n2);
            adaptiveCoding.headCoding.writeArrayTo(outputStream, nArray, n, n3);
            n = n3;
            if (!(adaptiveCoding.tailCoding instanceof AdaptiveCoding)) break;
            adaptiveCoding = (AdaptiveCoding)adaptiveCoding.tailCoding;
        }
        adaptiveCoding.tailCoding.writeArrayTo(outputStream, nArray, n, n2);
    }

    @Override
    public void readArrayFrom(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        AdaptiveCoding.readArray(this, inputStream, nArray, n, n2);
    }

    private static void readArray(AdaptiveCoding adaptiveCoding, InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        while (true) {
            int n3 = n + adaptiveCoding.headLength;
            assert (n3 <= n2);
            adaptiveCoding.headCoding.readArrayFrom(inputStream, nArray, n, n3);
            n = n3;
            if (!(adaptiveCoding.tailCoding instanceof AdaptiveCoding)) break;
            adaptiveCoding = (AdaptiveCoding)adaptiveCoding.tailCoding;
        }
        adaptiveCoding.tailCoding.readArrayFrom(inputStream, nArray, n, n2);
    }

    static int getKXOf(int n) {
        for (int i = 0; i <= 3; ++i) {
            if ((n - 1 & 0xFFFFFF00) == 0) {
                return i;
            }
            n >>>= 4;
        }
        return -1;
    }

    static int getKBOf(int n) {
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return -1;
        }
        return (n >>>= n2 * 4) - 1;
    }

    static int decodeK(int n, int n2) {
        assert (0 <= n && n <= 3);
        assert (0 <= n2 && n2 <= 255);
        return n2 + 1 << n * 4;
    }

    static int getNextK(int n) {
        if (n <= 0) {
            return 1;
        }
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return Integer.MAX_VALUE;
        }
        int n3 = 1 << n2 * 4;
        int n4 = 255 << n2 * 4;
        int n5 = n + n3;
        if (((n5 &= ~(n3 - 1)) - n3 & ~n4) == 0) {
            assert (AdaptiveCoding.getKXOf(n5) == n2);
            return n5;
        }
        if (n2 == 3) {
            return Integer.MAX_VALUE;
        }
        int n6 = 255 << ++n2 * 4;
        n5 |= n4 & ~n6;
        assert (AdaptiveCoding.getKXOf(n5 += n3) == n2);
        return n5;
    }

    public static boolean isCodableLength(int n) {
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = 1 << n2 * 4;
        int n4 = 255 << n2 * 4;
        return (n - n3 & ~n4) == 0;
    }

    @Override
    public byte[] getMetaCoding(Coding coding) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        try {
            AdaptiveCoding.makeMetaCoding(this, coding, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void makeMetaCoding(AdaptiveCoding adaptiveCoding, Coding coding, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        block7: {
            int n;
            CodingMethod codingMethod;
            while (true) {
                CodingMethod codingMethod2 = adaptiveCoding.headCoding;
                int n2 = adaptiveCoding.headLength;
                codingMethod = adaptiveCoding.tailCoding;
                int n3 = n2;
                assert (AdaptiveCoding.isCodableLength(n3));
                int n4 = codingMethod2 == coding ? 1 : 0;
                int n5 = n = codingMethod == coding ? 1 : 0;
                if (n4 + n > 1) {
                    n = 0;
                }
                int n6 = 1 * n4 + 2 * n;
                assert (n6 < 3);
                int n7 = AdaptiveCoding.getKXOf(n3);
                int n8 = AdaptiveCoding.getKBOf(n3);
                assert (AdaptiveCoding.decodeK(n7, n8) == n3);
                int n9 = n8 != 3 ? 1 : 0;
                byteArrayOutputStream.write(117 + n7 + 4 * n9 + 8 * n6);
                if (n9 != 0) {
                    byteArrayOutputStream.write(n8);
                }
                if (n4 == 0) {
                    byteArrayOutputStream.write(codingMethod2.getMetaCoding(coding));
                }
                if (!(codingMethod instanceof AdaptiveCoding)) break;
                adaptiveCoding = (AdaptiveCoding)codingMethod;
            }
            if (n != 0) break block7;
            byteArrayOutputStream.write(codingMethod.getMetaCoding(coding));
        }
    }

    public static int parseMetaCoding(byte[] byArray, int n, Coding coding, CodingMethod[] codingMethodArray) {
        int n2;
        if ((n2 = byArray[n++] & 0xFF) < 117 || n2 >= 141) {
            return n - 1;
        }
        AdaptiveCoding adaptiveCoding = null;
        boolean bl = true;
        while (bl) {
            bl = false;
            assert (n2 >= 117);
            int n3 = (n2 -= 117) % 4;
            int n4 = n2 / 4 % 2;
            int n5 = n2 / 8;
            assert (n5 < 3);
            int n6 = n5 & 1;
            int n7 = n5 & 2;
            CodingMethod[] codingMethodArray2 = new CodingMethod[]{coding};
            CodingMethod[] codingMethodArray3 = new CodingMethod[]{coding};
            int n8 = 3;
            if (n4 != 0) {
                n8 = byArray[n++] & 0xFF;
            }
            if (n6 == 0) {
                n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray2);
            }
            if (n7 == 0 && (n2 = byArray[n] & 0xFF) >= 117 && n2 < 141) {
                ++n;
                bl = true;
            } else if (n7 == 0) {
                n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray3);
            }
            AdaptiveCoding adaptiveCoding2 = new AdaptiveCoding(AdaptiveCoding.decodeK(n3, n8), codingMethodArray2[0], codingMethodArray3[0]);
            if (adaptiveCoding == null) {
                codingMethodArray[0] = adaptiveCoding2;
            } else {
                adaptiveCoding.tailCoding = adaptiveCoding2;
            }
            adaptiveCoding = adaptiveCoding2;
        }
        return n;
    }

    private String keyString(CodingMethod codingMethod) {
        if (codingMethod instanceof Coding) {
            return ((Coding)codingMethod).keyString();
        }
        return codingMethod.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        AdaptiveCoding adaptiveCoding = this;
        stringBuilder.append("run(");
        while (true) {
            stringBuilder.append(adaptiveCoding.headLength).append("*");
            stringBuilder.append(this.keyString(adaptiveCoding.headCoding));
            if (!(adaptiveCoding.tailCoding instanceof AdaptiveCoding)) break;
            adaptiveCoding = (AdaptiveCoding)adaptiveCoding.tailCoding;
            stringBuilder.append(" ");
        }
        stringBuilder.append(" **").append(this.keyString(adaptiveCoding.tailCoding));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

