/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class SupportedEllipticPointFormatsExtension
extends HelloExtension {
    static final int FMT_UNCOMPRESSED = 0;
    static final int FMT_ANSIX962_COMPRESSED_PRIME = 1;
    static final int FMT_ANSIX962_COMPRESSED_CHAR2 = 2;
    static final HelloExtension DEFAULT = new SupportedEllipticPointFormatsExtension(new byte[]{0});
    private final byte[] formats;

    private SupportedEllipticPointFormatsExtension(byte[] byArray) {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = byArray;
    }

    SupportedEllipticPointFormatsExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_EC_POINT_FORMATS);
        this.formats = handshakeInStream.getBytes8();
        boolean bl = false;
        for (byte by : this.formats) {
            if (by != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SSLProtocolException("Peer does not support uncompressed points");
        }
    }

    @Override
    int length() {
        return 5 + this.formats.length;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putInt16(this.formats.length + 1);
        handshakeOutStream.putBytes8(this.formats);
    }

    private static String toString(byte by) {
        int n = by & 0xFF;
        switch (n) {
            case 0: {
                return "uncompressed";
            }
            case 1: {
                return "ansiX962_compressed_prime";
            }
            case 2: {
                return "ansiX962_compressed_char2";
            }
        }
        return "unknown-" + n;
    }

    @Override
    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (byte by : this.formats) {
            arrayList.add(SupportedEllipticPointFormatsExtension.toString(by));
        }
        return "Extension " + this.type + ", formats: " + arrayList;
    }
}

