/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import sun.rmi.transport.Channel;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPEndpoint;

public class LiveRef
implements Cloneable {
    private final Endpoint ep;
    private final ObjID id;
    private transient Channel ch;
    private final boolean isLocal;

    public LiveRef(ObjID objID, Endpoint endpoint, boolean bl) {
        this.ep = endpoint;
        this.id = objID;
        this.isLocal = bl;
    }

    public LiveRef(int n) {
        this(new ObjID(), n);
    }

    public LiveRef(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this(new ObjID(), n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    public LiveRef(ObjID objID, int n) {
        this(objID, TCPEndpoint.getLocalEndpoint(n), true);
    }

    public LiveRef(ObjID objID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this(objID, TCPEndpoint.getLocalEndpoint(n, rMIClientSocketFactory, rMIServerSocketFactory), true);
    }

    public Object clone() {
        try {
            LiveRef liveRef = (LiveRef)super.clone();
            return liveRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int getPort() {
        return ((TCPEndpoint)this.ep).getPort();
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return ((TCPEndpoint)this.ep).getClientSocketFactory();
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return ((TCPEndpoint)this.ep).getServerSocketFactory();
    }

    public void exportObject(Target target) throws RemoteException {
        this.ep.exportObject(target);
    }

    public Channel getChannel() throws RemoteException {
        if (this.ch == null) {
            this.ch = this.ep.getChannel();
        }
        return this.ch;
    }

    public ObjID getObjID() {
        return this.id;
    }

    Endpoint getEndpoint() {
        return this.ep;
    }

    public String toString() {
        String string = this.isLocal ? "local" : "remote";
        return "[endpoint:" + this.ep + "(" + string + ")," + "objID:" + this.id + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            return this.ep.equals(liveRef.ep) && this.id.equals(liveRef.id) && this.isLocal == liveRef.isLocal;
        }
        return false;
    }

    public boolean remoteEquals(Object object) {
        if (object != null && object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            TCPEndpoint tCPEndpoint = (TCPEndpoint)this.ep;
            TCPEndpoint tCPEndpoint2 = (TCPEndpoint)liveRef.ep;
            RMIClientSocketFactory rMIClientSocketFactory = tCPEndpoint.getClientSocketFactory();
            RMIClientSocketFactory rMIClientSocketFactory2 = tCPEndpoint2.getClientSocketFactory();
            if (tCPEndpoint.getPort() != tCPEndpoint2.getPort() || !tCPEndpoint.getHost().equals(tCPEndpoint2.getHost())) {
                return false;
            }
            if (rMIClientSocketFactory == null ^ rMIClientSocketFactory2 == null) {
                return false;
            }
            if (!(rMIClientSocketFactory == null || rMIClientSocketFactory.getClass() == rMIClientSocketFactory2.getClass() && rMIClientSocketFactory.equals(rMIClientSocketFactory2))) {
                return false;
            }
            return this.id.equals(liveRef.id);
        }
        return false;
    }

    public void write(ObjectOutput objectOutput, boolean bl) throws IOException {
        boolean bl2 = false;
        if (objectOutput instanceof ConnectionOutputStream) {
            ConnectionOutputStream connectionOutputStream = (ConnectionOutputStream)objectOutput;
            bl2 = connectionOutputStream.isResultStream();
            if (this.isLocal) {
                Remote remote;
                ObjectEndpoint objectEndpoint = new ObjectEndpoint(this.id, this.ep.getInboundTransport());
                Target target = ObjectTable.getTarget(objectEndpoint);
                if (target != null && (remote = target.getImpl()) != null) {
                    connectionOutputStream.saveObject(remote);
                }
            } else {
                connectionOutputStream.saveObject(this);
            }
        }
        if (bl) {
            ((TCPEndpoint)this.ep).write(objectOutput);
        } else {
            ((TCPEndpoint)this.ep).writeHostPortFormat(objectOutput);
        }
        this.id.write(objectOutput);
        objectOutput.writeBoolean(bl2);
    }

    public static LiveRef read(ObjectInput objectInput, boolean bl) throws IOException, ClassNotFoundException {
        TCPEndpoint tCPEndpoint = bl ? TCPEndpoint.read(objectInput) : TCPEndpoint.readHostPortFormat(objectInput);
        ObjID objID = ObjID.read(objectInput);
        boolean bl2 = objectInput.readBoolean();
        LiveRef liveRef = new LiveRef(objID, tCPEndpoint, false);
        if (objectInput instanceof ConnectionInputStream) {
            ConnectionInputStream connectionInputStream = (ConnectionInputStream)objectInput;
            connectionInputStream.saveRef(liveRef);
            if (bl2) {
                connectionInputStream.setAckNeeded();
            }
        } else {
            DGCClient.registerRefs(tCPEndpoint, Arrays.asList(liveRef));
        }
        return liveRef;
    }
}

