/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class BasicSeparatorUI
extends SeparatorUI {
    protected Color shadow;
    protected Color highlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((JSeparator)jComponent);
        this.installListeners((JSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JSeparator)jComponent);
        this.uninstallListeners((JSeparator)jComponent);
    }

    protected void installDefaults(JSeparator jSeparator) {
        LookAndFeel.installColors(jSeparator, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(jSeparator, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JSeparator jSeparator) {
    }

    protected void installListeners(JSeparator jSeparator) {
    }

    protected void uninstallListeners(JSeparator jSeparator) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        if (((JSeparator)jComponent).getOrientation() == 1) {
            graphics.setColor(jComponent.getForeground());
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.setColor(jComponent.getBackground());
            graphics.drawLine(1, 0, 1, dimension.height);
        } else {
            graphics.setColor(jComponent.getForeground());
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.setColor(jComponent.getBackground());
            graphics.drawLine(0, 1, dimension.width, 1);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(2, 0);
        }
        return new Dimension(0, 2);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }
}

