/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import javax.management.openmbean.CompositeData;
import sun.management.MonitorInfoCompositeData;

public class MonitorInfo
extends LockInfo {
    private int stackDepth;
    private StackTraceElement stackFrame;

    public MonitorInfo(String string, int n, int n2, StackTraceElement stackTraceElement) {
        super(string, n);
        if (n2 >= 0 && stackTraceElement == null) {
            throw new IllegalArgumentException("Parameter stackDepth is " + n2 + " but stackFrame is null");
        }
        if (n2 < 0 && stackTraceElement != null) {
            throw new IllegalArgumentException("Parameter stackDepth is " + n2 + " but stackFrame is not null");
        }
        this.stackDepth = n2;
        this.stackFrame = stackTraceElement;
    }

    public int getLockedStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getLockedStackFrame() {
        return this.stackFrame;
    }

    public static MonitorInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof MonitorInfoCompositeData) {
            return ((MonitorInfoCompositeData)compositeData).getMonitorInfo();
        }
        MonitorInfoCompositeData.validateCompositeData(compositeData);
        String string = MonitorInfoCompositeData.getClassName(compositeData);
        int n = MonitorInfoCompositeData.getIdentityHashCode(compositeData);
        int n2 = MonitorInfoCompositeData.getLockedStackDepth(compositeData);
        StackTraceElement stackTraceElement = MonitorInfoCompositeData.getLockedStackFrame(compositeData);
        return new MonitorInfo(string, n, n2, stackTraceElement);
    }
}

