/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import com.sun.tracing.ProbeName;
import com.sun.tracing.Provider;
import com.sun.tracing.dtrace.Attributes;
import com.sun.tracing.dtrace.DependencyClass;
import com.sun.tracing.dtrace.FunctionName;
import com.sun.tracing.dtrace.ModuleName;
import com.sun.tracing.dtrace.StabilityLevel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.misc.ProxyGenerator;
import sun.tracing.ProbeSkeleton;
import sun.tracing.ProviderSkeleton;
import sun.tracing.dtrace.Activation;
import sun.tracing.dtrace.DTraceProbe;
import sun.tracing.dtrace.JVM;

class DTraceProvider
extends ProviderSkeleton {
    private Activation activation;
    private Object proxy;
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private final String proxyClassNamePrefix = "$DTraceTracingProxy";
    static final String DEFAULT_MODULE = "java_tracing";
    static final String DEFAULT_FUNCTION = "unspecified";
    private static long nextUniqueNumber = 0L;

    private static synchronized long getUniqueNumber() {
        return nextUniqueNumber++;
    }

    @Override
    protected ProbeSkeleton createProbe(Method method) {
        return new DTraceProbe(this.proxy, method);
    }

    DTraceProvider(Class<? extends Provider> clazz) {
        super(clazz);
    }

    void setProxy(Object object) {
        this.proxy = object;
    }

    void setActivation(Activation activation) {
        this.activation = activation;
    }

    @Override
    public void dispose() {
        if (this.activation != null) {
            this.activation.disposeProvider(this);
            this.activation = null;
        }
        super.dispose();
    }

    @Override
    public <T extends Provider> T newProxyInstance() {
        String string;
        long l = DTraceProvider.getUniqueNumber();
        String string2 = "";
        if (!Modifier.isPublic(this.providerType.getModifiers())) {
            string = this.providerType.getName();
            int n = string.lastIndexOf(46);
            string2 = n == -1 ? "" : string.substring(0, n + 1);
        }
        string = string2 + "$DTraceTracingProxy" + l;
        Class<?> clazz = null;
        byte[] byArray = ProxyGenerator.generateProxyClass(string, new Class[]{this.providerType});
        try {
            clazz = JVM.defineClass(this.providerType.getClassLoader(), string, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {
            throw new IllegalArgumentException(classFormatError.toString());
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(constructorParams);
            return (T)((Provider)constructor.newInstance(this));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }

    @Override
    protected void triggerProbe(Method method, Object[] objectArray) {
        assert (false) : "This method should have been overridden by the JVM";
    }

    @Override
    public String getProviderName() {
        return super.getProviderName();
    }

    String getModuleName() {
        return DTraceProvider.getAnnotationString(this.providerType, ModuleName.class, DEFAULT_MODULE);
    }

    static String getProbeName(Method method) {
        return DTraceProvider.getAnnotationString(method, ProbeName.class, method.getName());
    }

    static String getFunctionName(Method method) {
        return DTraceProvider.getAnnotationString(method, FunctionName.class, DEFAULT_FUNCTION);
    }

    DTraceProbe[] getProbes() {
        return this.probes.values().toArray(new DTraceProbe[0]);
    }

    StabilityLevel getNameStabilityFor(Class<? extends Annotation> clazz) {
        Attributes attributes = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, clazz, "value", null);
        if (attributes == null) {
            return StabilityLevel.PRIVATE;
        }
        return attributes.name();
    }

    StabilityLevel getDataStabilityFor(Class<? extends Annotation> clazz) {
        Attributes attributes = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, clazz, "value", null);
        if (attributes == null) {
            return StabilityLevel.PRIVATE;
        }
        return attributes.data();
    }

    DependencyClass getDependencyClassFor(Class<? extends Annotation> clazz) {
        Attributes attributes = (Attributes)DTraceProvider.getAnnotationValue(this.providerType, clazz, "value", null);
        if (attributes == null) {
            return DependencyClass.UNKNOWN;
        }
        return attributes.dependency();
    }
}

