/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermission;
import javax.crypto.CryptoPermissions;
import javax.crypto.ExemptionMechanism;
import javax.crypto.JceSecurity;

final class JceSecurityManager
extends SecurityManager {
    private static final CryptoPermissions defaultPolicy;
    private static final CryptoPermissions exemptPolicy;
    private static final CryptoAllPermission allPerm;
    private static final Vector TrustedCallersCache;
    private static final ConcurrentMap<URL, CryptoPermissions> exemptCache;
    private static final CryptoPermissions CACHE_NULL_MARK;
    static final JceSecurityManager INSTANCE;

    private JceSecurityManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CryptoPermission getCryptoPermission(String string) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        int n;
        CryptoPermission cryptoPermission = this.getDefaultPermission(string = string.toUpperCase(Locale.ENGLISH));
        if (cryptoPermission == CryptoAllPermission.INSTANCE) {
            return cryptoPermission;
        }
        Class<?>[] classArray = this.getClassContext();
        URL uRL = null;
        for (n = 0; n < classArray.length && (uRL = JceSecurity.getCodeBase(serializable3 = classArray[n])) == null; ++n) {
            if (((Class)serializable3).getName().startsWith("javax.crypto.")) continue;
            return cryptoPermission;
        }
        if (n == classArray.length) {
            return cryptoPermission;
        }
        serializable3 = (CryptoPermissions)exemptCache.get(uRL);
        if (serializable3 == null) {
            serializable2 = this.getClass();
            synchronized (serializable2) {
                serializable3 = (CryptoPermissions)exemptCache.get(uRL);
                if (serializable3 == null) {
                    serializable3 = JceSecurityManager.getAppPermissions(uRL);
                    exemptCache.putIfAbsent(uRL, (CryptoPermissions)(serializable3 == null ? CACHE_NULL_MARK : serializable3));
                }
            }
        }
        if (serializable3 == null || serializable3 == CACHE_NULL_MARK) {
            return cryptoPermission;
        }
        if (((CryptoPermissions)serializable3).implies(allPerm)) {
            return allPerm;
        }
        serializable2 = ((CryptoPermissions)serializable3).getPermissionCollection(string);
        if (serializable2 == null) {
            return cryptoPermission;
        }
        Enumeration<Permission> enumeration = ((PermissionCollection)serializable2).elements();
        while (enumeration.hasMoreElements()) {
            serializable = (CryptoPermission)enumeration.nextElement();
            if (((CryptoPermission)serializable).getExemptionMechanism() != null) continue;
            return serializable;
        }
        serializable = exemptPolicy.getPermissionCollection(string);
        if (serializable == null) {
            return cryptoPermission;
        }
        enumeration = ((PermissionCollection)serializable).elements();
        while (enumeration.hasMoreElements()) {
            CryptoPermission cryptoPermission2 = (CryptoPermission)enumeration.nextElement();
            try {
                CryptoPermission cryptoPermission3;
                ExemptionMechanism.getInstance(cryptoPermission2.getExemptionMechanism());
                if (cryptoPermission2.getAlgorithm().equals("*") && ((CryptoPermissions)serializable3).implies(cryptoPermission3 = cryptoPermission2.getCheckParam() ? new CryptoPermission(string, cryptoPermission2.getMaxKeySize(), cryptoPermission2.getAlgorithmParameterSpec(), cryptoPermission2.getExemptionMechanism()) : new CryptoPermission(string, cryptoPermission2.getMaxKeySize(), cryptoPermission2.getExemptionMechanism()))) {
                    return cryptoPermission3;
                }
                if (!((CryptoPermissions)serializable3).implies(cryptoPermission2)) continue;
                return cryptoPermission2;
            }
            catch (Exception exception) {
            }
        }
        return cryptoPermission;
    }

    private static CryptoPermissions getAppPermissions(URL uRL) {
        try {
            return JceSecurity.verifyExemptJar(uRL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CryptoPermission getDefaultPermission(String string) {
        Enumeration<Permission> enumeration = defaultPolicy.getPermissionCollection(string).elements();
        return (CryptoPermission)enumeration.nextElement();
    }

    boolean isCallerTrusted() {
        int n;
        Class<?>[] classArray = this.getClassContext();
        URL uRL = null;
        for (n = 0; n < classArray.length && (uRL = JceSecurity.getCodeBase(classArray[n])) == null; ++n) {
        }
        if (n == classArray.length) {
            return true;
        }
        if (TrustedCallersCache.contains(classArray[n])) {
            return true;
        }
        try {
            JceSecurity.verifyProviderJar(uRL);
        }
        catch (Exception exception) {
            return false;
        }
        TrustedCallersCache.addElement(classArray[n]);
        return true;
    }

    static {
        TrustedCallersCache = new Vector(2);
        exemptCache = new ConcurrentHashMap<URL, CryptoPermissions>();
        CACHE_NULL_MARK = new CryptoPermissions();
        defaultPolicy = JceSecurity.getDefaultPolicy();
        exemptPolicy = JceSecurity.getExemptPolicy();
        allPerm = CryptoAllPermission.INSTANCE;
        INSTANCE = (JceSecurityManager)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new JceSecurityManager();
            }
        });
    }
}

