/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import com.sun.imageio.plugins.common.BitFile;
import com.sun.imageio.plugins.common.LZWStringTable;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.stream.ImageOutputStream;

public class LZWCompressor {
    int codeSize;
    int clearCode;
    int endOfInfo;
    int numBits;
    int limit;
    short prefix;
    BitFile bf;
    LZWStringTable lzss;
    boolean tiffFudge;

    public LZWCompressor(ImageOutputStream imageOutputStream, int n, boolean bl) throws IOException {
        this.bf = new BitFile(imageOutputStream, !bl);
        this.codeSize = n;
        this.tiffFudge = bl;
        this.clearCode = 1 << n;
        this.endOfInfo = this.clearCode + 1;
        this.numBits = n + 1;
        this.limit = (1 << this.numBits) - 1;
        if (this.tiffFudge) {
            --this.limit;
        }
        this.prefix = (short)-1;
        this.lzss = new LZWStringTable();
        this.lzss.clearTable(n);
        this.bf.writeBits(this.clearCode, this.numBits);
    }

    public void compress(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byte by = byArray[i];
            short s = this.lzss.findCharString(this.prefix, by);
            if (s != -1) {
                this.prefix = s;
                continue;
            }
            this.bf.writeBits(this.prefix, this.numBits);
            if (this.lzss.addCharString(this.prefix, by) > this.limit) {
                if (this.numBits == 12) {
                    this.bf.writeBits(this.clearCode, this.numBits);
                    this.lzss.clearTable(this.codeSize);
                    this.numBits = this.codeSize + 1;
                } else {
                    ++this.numBits;
                }
                this.limit = (1 << this.numBits) - 1;
                if (this.tiffFudge) {
                    --this.limit;
                }
            }
            this.prefix = (short)((short)by & 0xFF);
        }
    }

    public void flush() throws IOException {
        if (this.prefix != -1) {
            this.bf.writeBits(this.prefix, this.numBits);
        }
        this.bf.writeBits(this.endOfInfo, this.numBits);
        this.bf.flush();
    }

    public void dump(PrintStream printStream) {
        this.lzss.dump(printStream);
    }
}

