/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(n >>> 8);
            this.byteBuf[1] = (byte)(n >>> 0);
        } else {
            this.byteBuf[0] = (byte)(n >>> 0);
            this.byteBuf[1] = (byte)(n >>> 8);
        }
        this.write(this.byteBuf, 0, 2);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(n >>> 24);
            this.byteBuf[1] = (byte)(n >>> 16);
            this.byteBuf[2] = (byte)(n >>> 8);
            this.byteBuf[3] = (byte)(n >>> 0);
        } else {
            this.byteBuf[0] = (byte)(n >>> 0);
            this.byteBuf[1] = (byte)(n >>> 8);
            this.byteBuf[2] = (byte)(n >>> 16);
            this.byteBuf[3] = (byte)(n >>> 24);
        }
        this.write(this.byteBuf, 0, 4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.byteBuf[0] = (byte)(l >>> 56);
            this.byteBuf[1] = (byte)(l >>> 48);
            this.byteBuf[2] = (byte)(l >>> 40);
            this.byteBuf[3] = (byte)(l >>> 32);
            this.byteBuf[4] = (byte)(l >>> 24);
            this.byteBuf[5] = (byte)(l >>> 16);
            this.byteBuf[6] = (byte)(l >>> 8);
            this.byteBuf[7] = (byte)(l >>> 0);
        } else {
            this.byteBuf[0] = (byte)(l >>> 0);
            this.byteBuf[1] = (byte)(l >>> 8);
            this.byteBuf[2] = (byte)(l >>> 16);
            this.byteBuf[3] = (byte)(l >>> 24);
            this.byteBuf[4] = (byte)(l >>> 32);
            this.byteBuf[5] = (byte)(l >>> 40);
            this.byteBuf[6] = (byte)(l >>> 48);
            this.byteBuf[7] = (byte)(l >>> 56);
        }
        this.write(this.byteBuf, 0, 4);
        this.write(this.byteBuf, 4, 4);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write((byte)string.charAt(i));
        }
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                byArray[n2++] = (byte)(c >>> 8);
                byArray[n2++] = (byte)(c >>> 0);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                byArray[n2++] = (byte)(c >>> 0);
                byArray[n2++] = (byte)(c >>> 8);
            }
        }
        this.write(byArray, 0, n * 2);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException("utflen > 65536!");
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.write(byArray, 0, n2 + 2);
    }

    @Override
    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                short s = sArray[n + i];
                byArray[n3++] = (byte)(s >>> 8);
                byArray[n3++] = (byte)(s >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                short s = sArray[n + i];
                byArray[n3++] = (byte)(s >>> 0);
                byArray[n3++] = (byte)(s >>> 8);
            }
        }
        this.write(byArray, 0, n2 * 2);
    }

    @Override
    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                byArray[n3++] = (byte)(c >>> 8);
                byArray[n3++] = (byte)(c >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                byArray[n3++] = (byte)(c >>> 0);
                byArray[n3++] = (byte)(c >>> 8);
            }
        }
        this.write(byArray, 0, n2 * 2);
    }

    @Override
    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[n + i];
                byArray[n3++] = (byte)(n4 >>> 24);
                byArray[n3++] = (byte)(n4 >>> 16);
                byArray[n3++] = (byte)(n4 >>> 8);
                byArray[n3++] = (byte)(n4 >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n5 = nArray[n + i];
                byArray[n3++] = (byte)(n5 >>> 0);
                byArray[n3++] = (byte)(n5 >>> 8);
                byArray[n3++] = (byte)(n5 >>> 16);
                byArray[n3++] = (byte)(n5 >>> 24);
            }
        }
        this.write(byArray, 0, n2 * 4);
    }

    @Override
    public void writeLongs(long[] lArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        byte[] byArray = new byte[n2 * 8];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                long l = lArray[n + i];
                byArray[n3++] = (byte)(l >>> 56);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                long l = lArray[n + i];
                byArray[n3++] = (byte)(l >>> 0);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 56);
            }
        }
        this.write(byArray, 0, n2 * 8);
    }

    @Override
    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                int n4 = Float.floatToIntBits(fArray[n + i]);
                byArray[n3++] = (byte)(n4 >>> 24);
                byArray[n3++] = (byte)(n4 >>> 16);
                byArray[n3++] = (byte)(n4 >>> 8);
                byArray[n3++] = (byte)(n4 >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n5 = Float.floatToIntBits(fArray[n + i]);
                byArray[n3++] = (byte)(n5 >>> 0);
                byArray[n3++] = (byte)(n5 >>> 8);
                byArray[n3++] = (byte)(n5 >>> 16);
                byArray[n3++] = (byte)(n5 >>> 24);
            }
        }
        this.write(byArray, 0, n2 * 4);
    }

    @Override
    public void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        byte[] byArray = new byte[n2 * 8];
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                long l = Double.doubleToLongBits(dArray[n + i]);
                byArray[n3++] = (byte)(l >>> 56);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 0);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                long l = Double.doubleToLongBits(dArray[n + i]);
                byArray[n3++] = (byte)(l >>> 0);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 56);
            }
        }
        this.write(byArray, 0, n2 * 8);
    }

    @Override
    public void writeBit(int n) throws IOException {
        this.writeBits(1L & (long)n, 1);
    }

    @Override
    public void writeBits(long l, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException("Bad value for numBits!");
        }
        if (n == 0) {
            return;
        }
        if (this.getStreamPosition() > 0L || this.bitOffset > 0) {
            n5 = this.bitOffset;
            n4 = this.read();
            if (n4 != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                n4 = 0;
            }
            if (n + n5 < 8) {
                n3 = 8 - (n5 + n);
                n2 = -1 >>> 32 - n;
                n4 &= ~(n2 << n3);
                n4 = (int)((long)n4 | (l & (long)n2) << n3);
                this.write(n4);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = n5 + n;
                n = 0;
            } else {
                n3 = 8 - n5;
                n2 = -1 >>> 32 - n3;
                n4 &= ~n2;
                n4 = (int)((long)n4 | l >> n - n3 & (long)n2);
                this.write(n4);
                n -= n3;
            }
        }
        if (n > 7) {
            n5 = n % 8;
            for (n4 = n / 8; n4 > 0; --n4) {
                n3 = (n4 - 1) * 8 + n5;
                n2 = (int)(n3 == 0 ? l & 0xFFL : l >> n3 & 0xFFL);
                this.write(n2);
            }
            n = n5;
        }
        if (n != 0) {
            n5 = 0;
            n5 = this.read();
            if (n5 != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                n5 = 0;
            }
            n4 = 8 - n;
            n3 = -1 >>> 32 - n;
            n5 &= ~(n3 << n4);
            n5 = (int)((long)n5 | (l & (long)n3) << n4);
            this.write(n5);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = n;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int n = this.bitOffset;
            int n2 = this.read();
            if (n2 < 0) {
                n2 = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                n2 &= -1 << 8 - n;
            }
            this.write(n2);
        }
    }
}

