/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Compiler {
    private Compiler() {
    }

    private static native void initialize();

    private static native void registerNatives();

    public static native boolean compileClass(Class<?> var0);

    public static native boolean compileClasses(String var0);

    public static native Object command(Object var0);

    public static native void enable();

    public static native void disable();

    static {
        Compiler.registerNatives();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                boolean bl = false;
                String string = System.getProperty("java.compiler");
                if (string != null && !string.equals("NONE") && !string.equals("")) {
                    try {
                        System.loadLibrary(string);
                        Compiler.initialize();
                        bl = true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        System.err.println("Warning: JIT compiler \"" + string + "\" not found. Will use interpreter.");
                    }
                }
                String string2 = System.getProperty("java.vm.info");
                if (bl) {
                    System.setProperty("java.vm.info", string2 + ", " + string);
                } else {
                    System.setProperty("java.vm.info", string2 + ", nojit");
                }
                return null;
            }
        });
    }
}

