/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jdk.Exported;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

@Exported
public class Krb5LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private boolean debug = false;
    private boolean storeKey = false;
    private boolean doNotPrompt = false;
    private boolean useTicketCache = false;
    private boolean useKeyTab = false;
    private String ticketCacheName = null;
    private String keyTabName = null;
    private String princName = null;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean refreshKrb5Config = false;
    private boolean renewTGT = false;
    private boolean isInitiator = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private EncryptionKey[] encKeys = null;
    KeyTab ktab = null;
    private Credentials cred = null;
    private PrincipalName principal = null;
    private KerberosPrincipal kerbClientPrinc = null;
    private KerberosTicket kerbTicket = null;
    private KerberosKey[] kerbKeys = null;
    private StringBuffer krb5PrincName = null;
    private boolean unboundServer = false;
    private char[] password = null;
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.storeKey = "true".equalsIgnoreCase((String)map2.get("storeKey"));
        this.doNotPrompt = "true".equalsIgnoreCase((String)map2.get("doNotPrompt"));
        this.useTicketCache = "true".equalsIgnoreCase((String)map2.get("useTicketCache"));
        this.useKeyTab = "true".equalsIgnoreCase((String)map2.get("useKeyTab"));
        this.ticketCacheName = (String)map2.get("ticketCache");
        this.keyTabName = (String)map2.get("keyTab");
        if (this.keyTabName != null) {
            this.keyTabName = sun.security.krb5.internal.ktab.KeyTab.normalize(this.keyTabName);
        }
        this.princName = (String)map2.get("principal");
        this.refreshKrb5Config = "true".equalsIgnoreCase((String)map2.get("refreshKrb5Config"));
        this.renewTGT = "true".equalsIgnoreCase((String)map2.get("renewTGT"));
        String string = (String)map2.get("isInitiator");
        if (string != null) {
            this.isInitiator = "true".equalsIgnoreCase(string);
        }
        this.tryFirstPass = "true".equalsIgnoreCase((String)map2.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)map2.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)map2.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)map2.get("clearPass"));
        if (this.debug) {
            System.out.print("Debug is  " + this.debug + " storeKey " + this.storeKey + " useTicketCache " + this.useTicketCache + " useKeyTab " + this.useKeyTab + " doNotPrompt " + this.doNotPrompt + " ticketCache is " + this.ticketCacheName + " isInitiator " + this.isInitiator + " KeyTab is " + this.keyTabName + " refreshKrb5Config is " + this.refreshKrb5Config + " principal is " + this.princName + " tryFirstPass is " + this.tryFirstPass + " useFirstPass is " + this.useFirstPass + " storePass is " + this.storePass + " clearPass is " + this.clearPass + "\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (this.refreshKrb5Config) {
            try {
                if (this.debug) {
                    System.out.println("Refreshing Kerberos configuration");
                }
                Config.refresh();
            }
            catch (KrbException var1_1) {
                var2_3 = new LoginException(var1_1.getMessage());
                var2_3.initCause(var1_1);
                throw var2_3;
            }
        }
        if ((var1_2 = System.getProperty("sun.security.krb5.principal")) != null) {
            this.krb5PrincName = new StringBuffer(var1_2);
        } else if (this.princName != null) {
            this.krb5PrincName = new StringBuffer(this.princName);
        }
        this.validateConfiguration();
        if (this.krb5PrincName != null && this.krb5PrincName.toString().equals("*")) {
            this.unboundServer = true;
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication succeeded");
                }
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException var2_4) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl45
                System.out.println("\t\t[Krb5LoginModule] tryFirstPass failed with:" + var2_4.getMessage());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException var2_5) {
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + var2_5.getMessage());
                }
                this.succeeded = false;
                this.cleanState();
                throw var2_5;
            }
        }
lbl45:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            this.cleanState();
            return true;
        }
        catch (LoginException var2_6) {
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + var2_6.getMessage());
            }
            this.succeeded = false;
            this.cleanState();
            throw var2_6;
        }
    }

    private void attemptAuthentication(boolean bl) throws LoginException {
        if (this.krb5PrincName != null) {
            try {
                this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
            }
            catch (KrbException krbException) {
                LoginException loginException = new LoginException(krbException.getMessage());
                loginException.initCause(krbException);
                throw loginException;
            }
        }
        try {
            if (this.useTicketCache) {
                if (this.debug) {
                    System.out.println("Acquire TGT from Cache");
                }
                this.cred = Credentials.acquireTGTFromCache(this.principal, this.ticketCacheName);
                if (this.cred != null && !this.isCurrent(this.cred)) {
                    if (this.renewTGT) {
                        this.cred = this.renewCredentials(this.cred);
                    } else {
                        this.cred = null;
                        if (this.debug) {
                            System.out.println("Credentials are no longer valid");
                        }
                    }
                }
                if (this.cred != null && this.principal == null) {
                    this.principal = this.cred.getClient();
                }
                if (this.debug) {
                    System.out.println("Principal is " + this.principal);
                    if (this.cred == null) {
                        System.out.println("null credentials from Ticket Cache");
                    }
                }
            }
            if (this.cred == null) {
                Object object;
                if (this.principal == null) {
                    this.promptForName(bl);
                    this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
                }
                if (this.useKeyTab) {
                    if (!this.unboundServer) {
                        object = new KerberosPrincipal(this.principal.getName());
                        this.ktab = this.keyTabName == null ? KeyTab.getInstance((KerberosPrincipal)object) : KeyTab.getInstance((KerberosPrincipal)object, new File(this.keyTabName));
                    } else {
                        KeyTab keyTab = this.ktab = this.keyTabName == null ? KeyTab.getUnboundInstance() : KeyTab.getUnboundInstance(new File(this.keyTabName));
                    }
                    if (this.isInitiator && Krb5Util.keysFromJavaxKeyTab(this.ktab, this.principal).length == 0) {
                        this.ktab = null;
                        if (this.debug) {
                            System.out.println("Key for the principal " + this.principal + " not available in " + (this.keyTabName == null ? "default key tab" : this.keyTabName));
                        }
                    }
                }
                if (this.ktab == null) {
                    this.promptForPass(bl);
                    object = new KrbAsReqBuilder(this.principal, this.password);
                    if (this.isInitiator) {
                        this.cred = ((KrbAsReqBuilder)object).action().getCreds();
                    }
                    if (this.storeKey) {
                        this.encKeys = ((KrbAsReqBuilder)object).getKeys(this.isInitiator);
                    }
                } else {
                    object = new KrbAsReqBuilder(this.principal, this.ktab);
                    if (this.isInitiator) {
                        this.cred = ((KrbAsReqBuilder)object).action().getCreds();
                    }
                }
                ((KrbAsReqBuilder)object).destroy();
                if (this.debug) {
                    System.out.println("principal is " + this.principal);
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    if (this.ktab != null) {
                        System.out.println("Will use keytab");
                    } else if (this.storeKey) {
                        for (int i = 0; i < this.encKeys.length; ++i) {
                            System.out.println("EncryptionKey: keyType=" + this.encKeys[i].getEType() + " keyBytes (hex dump)=" + hexDumpEncoder.encodeBuffer(this.encKeys[i].getBytes()));
                        }
                    }
                }
                if (this.isInitiator && this.cred == null) {
                    throw new LoginException("TGT Can not be obtained from the KDC ");
                }
            }
        }
        catch (KrbException krbException) {
            LoginException loginException = new LoginException(krbException.getMessage());
            loginException.initCause(krbException);
            throw loginException;
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException(iOException.getMessage());
            loginException.initCause(iOException);
            throw loginException;
        }
    }

    private void promptForName(boolean bl) throws LoginException {
        this.krb5PrincName = new StringBuffer("");
        if (bl) {
            this.username = (String)this.sharedState.get(NAME);
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username == null) {
                System.out.println("username from shared state is null\n");
                throw new LoginException("Username can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username != null && this.username.length() > 0) {
                this.krb5PrincName.insert(0, this.username);
                return;
            }
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain Principal Name for authentication ");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user");
        }
        try {
            String string = System.getProperty("user.name");
            Callback[] callbackArray = new Callback[1];
            MessageFormat messageFormat = new MessageFormat(rb.getString("Kerberos.username.defUsername."));
            Object[] objectArray = new Object[]{string};
            callbackArray[0] = new NameCallback(messageFormat.format(objectArray));
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            if (this.username == null || this.username.length() == 0) {
                this.username = string;
            }
            this.krb5PrincName.insert(0, this.username);
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to garner " + " authentication information " + " from the user");
        }
    }

    private void promptForPass(boolean bl) throws LoginException {
        if (bl) {
            this.password = (char[])this.sharedState.get(PWD);
            if (this.password == null) {
                if (this.debug) {
                    System.out.println("Password from shared state is null");
                }
                throw new LoginException("Password can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("password is " + new String(this.password));
            }
            return;
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain password from user\n");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user");
        }
        try {
            Callback[] callbackArray = new Callback[1];
            String string = this.krb5PrincName.toString();
            MessageFormat messageFormat = new MessageFormat(rb.getString("Kerberos.password.for.username."));
            Object[] objectArray = new Object[]{string};
            callbackArray[0] = new PasswordCallback(messageFormat.format(objectArray), false);
            this.callbackHandler.handle(callbackArray);
            char[] cArray = ((PasswordCallback)callbackArray[0]).getPassword();
            if (cArray == null) {
                throw new LoginException("No password provided");
            }
            this.password = new char[cArray.length];
            System.arraycopy(cArray, 0, this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[0]).clearPassword();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            cArray = null;
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] user entered username: " + this.krb5PrincName);
                System.out.println();
            }
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to garner " + " authentication information " + "from the user");
        }
    }

    private void validateConfiguration() throws LoginException {
        if (!(!this.doNotPrompt || this.useTicketCache || this.useKeyTab || this.tryFirstPass || this.useFirstPass)) {
            throw new LoginException("Configuration Error - either doNotPrompt should be  false or at least one of useTicketCache,  useKeyTab, tryFirstPass and useFirstPass should be true");
        }
        if (this.ticketCacheName != null && !this.useTicketCache) {
            throw new LoginException("Configuration Error  - useTicketCache should be set to true to use the ticket cache" + this.ticketCacheName);
        }
        if (this.keyTabName != null & !this.useKeyTab) {
            throw new LoginException("Configuration Error - useKeyTab should be set to true to use the keytab" + this.keyTabName);
        }
        if (this.storeKey && this.doNotPrompt && !this.useKeyTab && !this.tryFirstPass && !this.useFirstPass) {
            throw new LoginException("Configuration Error - either doNotPrompt should be set to  false or at least one of tryFirstPass, useFirstPass or useKeyTab must be set to true for storeKey option");
        }
        if (this.renewTGT && !this.useTicketCache) {
            throw new LoginException("Configuration Error - either useTicketCache should be  true or renewTGT should be false");
        }
        if (this.krb5PrincName != null && this.krb5PrincName.toString().equals("*") && this.isInitiator) {
            throw new LoginException("Configuration Error - principal cannot be * when isInitiator is true");
        }
    }

    private boolean isCurrent(Credentials credentials) {
        Date date = credentials.getEndTime();
        if (date != null) {
            return System.currentTimeMillis() <= date.getTime();
        }
        return true;
    }

    private Credentials renewCredentials(Credentials credentials) {
        Credentials credentials2;
        block5: {
            try {
                if (!credentials.isRenewable()) {
                    throw new RefreshFailedException("This ticket is not renewable");
                }
                if (System.currentTimeMillis() > this.cred.getRenewTill().getTime()) {
                    throw new RefreshFailedException("This ticket is past its last renewal time.");
                }
                credentials2 = credentials.renew();
                if (this.debug) {
                    System.out.println("Renewed Kerberos Ticket");
                }
            }
            catch (Exception exception) {
                credentials2 = null;
                if (!this.debug) break block5;
                System.out.println("Ticket could not be renewed : " + exception.getMessage());
            }
        }
        return credentials2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean commit() throws LoginException {
        int n;
        if (!this.succeeded) {
            return false;
        }
        if (this.isInitiator && this.cred == null) {
            this.succeeded = false;
            throw new LoginException("Null Client Credential");
        }
        if (this.subject.isReadOnly()) {
            this.cleanKerberosCred();
            throw new LoginException("Subject is Readonly");
        }
        Set<Object> set = this.subject.getPrivateCredentials();
        Set<Principal> set2 = this.subject.getPrincipals();
        this.kerbClientPrinc = new KerberosPrincipal(this.principal.getName());
        if (this.isInitiator) {
            this.kerbTicket = Krb5Util.credsToTicket(this.cred);
        }
        if (this.storeKey && this.encKeys != null) {
            if (this.encKeys.length == 0) {
                this.succeeded = false;
                throw new LoginException("Null Server Key ");
            }
            this.kerbKeys = new KerberosKey[this.encKeys.length];
            for (n = 0; n < this.encKeys.length; ++n) {
                Integer n2 = this.encKeys[n].getKeyVersionNumber();
                this.kerbKeys[n] = new KerberosKey(this.kerbClientPrinc, this.encKeys[n].getBytes(), this.encKeys[n].getEType(), n2 == null ? 0 : n2);
            }
        }
        if (!this.unboundServer && !set2.contains(this.kerbClientPrinc)) {
            set2.add(this.kerbClientPrinc);
        }
        if (this.kerbTicket != null && !set.contains(this.kerbTicket)) {
            set.add(this.kerbTicket);
        }
        if (this.storeKey) {
            if (this.encKeys == null) {
                if (this.ktab == null) {
                    this.succeeded = false;
                    throw new LoginException("No key to store");
                }
                if (!set.contains(this.ktab)) {
                    set.add(this.ktab);
                }
            } else {
                for (n = 0; n < this.kerbKeys.length; ++n) {
                    if (!set.contains(this.kerbKeys[n])) {
                        set.add(this.kerbKeys[n]);
                    }
                    this.encKeys[n].destroy();
                    this.encKeys[n] = null;
                    if (!this.debug) continue;
                    System.out.println("Added server's key" + this.kerbKeys[n]);
                    System.out.println("\t\t[Krb5LoginModule] added Krb5Principal  " + this.kerbClientPrinc.toString() + " to Subject");
                }
            }
        }
        this.commitSucceeded = true;
        if (this.debug) {
            System.out.println("Commit Succeeded \n");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanKerberosCred();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[Krb5LoginModule]: Entering logout");
        }
        if (this.subject.isReadOnly()) {
            this.cleanKerberosCred();
            throw new LoginException("Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.kerbClientPrinc);
        Iterator<Object> iterator = this.subject.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof KerberosTicket) && !(object instanceof KerberosKey) && !(object instanceof KeyTab)) continue;
            iterator.remove();
        }
        this.cleanKerberosCred();
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug) {
            System.out.println("\t\t[Krb5LoginModule]: logged out Subject");
        }
        return true;
    }

    private void cleanKerberosCred() throws LoginException {
        try {
            if (this.kerbTicket != null) {
                this.kerbTicket.destroy();
            }
            if (this.kerbKeys != null) {
                for (int i = 0; i < this.kerbKeys.length; ++i) {
                    this.kerbKeys[i].destroy();
                }
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw new LoginException("Destroy Failed on Kerberos Private Credentials");
        }
        this.kerbTicket = null;
        this.kerbKeys = null;
        this.kerbClientPrinc = null;
    }

    private void cleanState() {
        if (this.succeeded) {
            if (this.storePass && !this.sharedState.containsKey(NAME) && !this.sharedState.containsKey(PWD)) {
                this.sharedState.put(NAME, this.username);
                this.sharedState.put(PWD, this.password);
            }
        } else {
            this.encKeys = null;
            this.ktab = null;
            this.principal = null;
        }
        this.username = null;
        this.password = null;
        if (this.krb5PrincName != null && this.krb5PrincName.length() != 0) {
            this.krb5PrincName.delete(0, this.krb5PrincName.length());
        }
        this.krb5PrincName = null;
        if (this.clearPass) {
            this.sharedState.remove(NAME);
            this.sharedState.remove(PWD);
        }
    }
}

