/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;

final class SimpleMethodHandle
extends BoundMethodHandle {
    static final BoundMethodHandle.SpeciesData SPECIES_DATA = BoundMethodHandle.SpeciesData.EMPTY;

    private SimpleMethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        super(methodType, lambdaForm);
    }

    static BoundMethodHandle make(MethodType methodType, LambdaForm lambdaForm) {
        return new SimpleMethodHandle(methodType, lambdaForm);
    }

    @Override
    public BoundMethodHandle.SpeciesData speciesData() {
        return SPECIES_DATA;
    }

    @Override
    BoundMethodHandle copyWith(MethodType methodType, LambdaForm lambdaForm) {
        return SimpleMethodHandle.make(methodType, lambdaForm);
    }

    @Override
    String internalProperties() {
        return "\n& Class=" + this.getClass().getSimpleName();
    }

    @Override
    public int fieldCount() {
        return 0;
    }

    @Override
    final BoundMethodHandle copyWithExtendL(MethodType methodType, LambdaForm lambdaForm, Object object) {
        return BoundMethodHandle.bindSingle(methodType, lambdaForm, object);
    }

    @Override
    final BoundMethodHandle copyWithExtendI(MethodType methodType, LambdaForm lambdaForm, int n) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(methodType, lambdaForm, n);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendJ(MethodType methodType, LambdaForm lambdaForm, long l) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(methodType, lambdaForm, l);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendF(MethodType methodType, LambdaForm lambdaForm, float f) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(methodType, lambdaForm, f);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
    }

    @Override
    final BoundMethodHandle copyWithExtendD(MethodType methodType, LambdaForm lambdaForm, double d) {
        try {
            return SPECIES_DATA.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(methodType, lambdaForm, d);
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.uncaughtException(throwable);
        }
    }
}

