/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosKey
implements SecretKey,
Destroyable {
    private static final long serialVersionUID = -4625402278148246993L;
    private KerberosPrincipal principal;
    private int versionNum;
    private KeyImpl key;
    private transient boolean destroyed = false;

    public KerberosKey(KerberosPrincipal kerberosPrincipal, byte[] byArray, int n, int n2) {
        this.principal = kerberosPrincipal;
        this.versionNum = n2;
        this.key = new KeyImpl(byArray, n);
    }

    public KerberosKey(KerberosPrincipal kerberosPrincipal, char[] cArray, String string) {
        this.principal = kerberosPrincipal;
        this.key = new KeyImpl(kerberosPrincipal, cArray, string);
    }

    public final KerberosPrincipal getPrincipal() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.principal;
    }

    public final int getVersionNumber() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.versionNum;
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getKeyType();
    }

    @Override
    public final String getAlgorithm() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getAlgorithm();
    }

    @Override
    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getFormat();
    }

    @Override
    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getEncoded();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.key.destroy();
            this.principal = null;
            this.destroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        if (this.destroyed) {
            return "Destroyed Principal";
        }
        return "Kerberos Principal " + this.principal.toString() + "Key Version " + this.versionNum + "key " + this.key.toString();
    }

    public int hashCode() {
        int n = 17;
        if (this.isDestroyed()) {
            return n;
        }
        n = 37 * n + Arrays.hashCode(this.getEncoded());
        n = 37 * n + this.getKeyType();
        if (this.principal != null) {
            n = 37 * n + this.principal.hashCode();
        }
        return n * 37 + this.versionNum;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosKey)) {
            return false;
        }
        KerberosKey kerberosKey = (KerberosKey)object;
        if (this.isDestroyed() || kerberosKey.isDestroyed()) {
            return false;
        }
        if (this.versionNum != kerberosKey.getVersionNumber() || this.getKeyType() != kerberosKey.getKeyType() || !Arrays.equals(this.getEncoded(), kerberosKey.getEncoded())) {
            return false;
        }
        return !(this.principal == null ? kerberosKey.getPrincipal() != null : !this.principal.equals(kerberosKey.getPrincipal()));
    }
}

