/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

abstract class WeakIdentityMap<T> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object NULL = new Object();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private volatile Entry<T>[] table = this.newTable(8);
    private int threshold = 6;
    private int size = 0;

    WeakIdentityMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Object object) {
        this.removeStaleEntries();
        if (object == null) {
            object = NULL;
        }
        int n = object.hashCode();
        Entry<T>[] entryArray = this.table;
        int n2 = WeakIdentityMap.getIndex(entryArray, n);
        Object object2 = entryArray[n2];
        while (object2 != null) {
            if (((Entry)object2).isMatched(object, n)) {
                return (T)((Entry)object2).value;
            }
            object2 = ((Entry)object2).next;
        }
        object2 = NULL;
        synchronized (object2) {
            n2 = WeakIdentityMap.getIndex(this.table, n);
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.isMatched(object, n)) {
                    return (T)entry.value;
                }
                entry = entry.next;
            }
            entry = this.create(object);
            this.table[n2] = new Entry<Entry>(object, n, entry, this.queue, this.table[n2]);
            if (++this.size >= this.threshold) {
                if (this.table.length == 0x40000000) {
                    this.threshold = Integer.MAX_VALUE;
                } else {
                    this.removeStaleEntries();
                    entryArray = this.newTable(this.table.length * 2);
                    this.transfer(this.table, entryArray);
                    if (this.size >= this.threshold / 2) {
                        this.table = entryArray;
                        this.threshold *= 2;
                    } else {
                        this.transfer(entryArray, this.table);
                    }
                }
            }
            return (T)entry;
        }
    }

    protected abstract T create(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        Reference<Object> reference = this.queue.poll();
        if (reference != null) {
            Object object = NULL;
            synchronized (object) {
                block3: do {
                    Entry entry;
                    Entry entry2 = (Entry)reference;
                    int n = WeakIdentityMap.getIndex(this.table, entry2.hash);
                    Entry entry3 = entry = this.table[n];
                    while (entry3 != null) {
                        Entry entry4 = entry3.next;
                        if (entry3 == entry2) {
                            if (entry == entry2) {
                                this.table[n] = entry4;
                            } else {
                                entry.next = entry4;
                            }
                            entry2.value = null;
                            entry2.next = null;
                            --this.size;
                            continue block3;
                        }
                        entry = entry3;
                        entry3 = entry4;
                    }
                } while ((reference = this.queue.poll()) != null);
            }
        }
    }

    private void transfer(Entry<T>[] entryArray, Entry<T>[] entryArray2) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.value = null;
                    entry.next = null;
                    --this.size;
                } else {
                    int n = WeakIdentityMap.getIndex(entryArray2, entry.hash);
                    entry.next = (Entry)entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    private Entry<T>[] newTable(int n) {
        return new Entry[n];
    }

    private static int getIndex(Entry<?>[] entryArray, int n) {
        return n & entryArray.length - 1;
    }

    private static class Entry<T>
    extends WeakReference<Object> {
        private final int hash;
        private volatile T value;
        private volatile Entry<T> next;

        Entry(Object object, int n, T t, ReferenceQueue<Object> referenceQueue, Entry<T> entry) {
            super(object, referenceQueue);
            this.hash = n;
            this.value = t;
            this.next = entry;
        }

        boolean isMatched(Object object, int n) {
            return this.hash == n && object == this.get();
        }
    }
}

