/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JButton
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "ButtonUI";

    public JButton() {
        this(null, null);
    }

    public JButton(Icon icon) {
        this(null, icon);
    }

    @ConstructorProperties(value={"text"})
    public JButton(String string) {
        this(string, null);
    }

    public JButton(Action action) {
        this();
        this.setAction(action);
    }

    public JButton(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isDefaultButton() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            return jRootPane.getDefaultButton() == this;
        }
        return false;
    }

    public boolean isDefaultCapable() {
        return this.defaultCapable;
    }

    public void setDefaultCapable(boolean bl) {
        boolean bl2 = this.defaultCapable;
        this.defaultCapable = bl;
        this.firePropertyChange("defaultCapable", bl2, bl);
    }

    @Override
    public void removeNotify() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null && jRootPane.getDefaultButton() == this) {
            jRootPane.setDefaultButton(null);
        }
        super.removeNotify();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.defaultCapable ? "true" : "false";
        return super.paramString() + ",defaultCapable=" + string;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleJButton() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

