/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FileTreeIterator
implements Iterator<FileTreeWalker.Event>,
Closeable {
    private final FileTreeWalker walker;
    private FileTreeWalker.Event next;

    FileTreeIterator(Path path, int n, FileVisitOption ... fileVisitOptionArray) throws IOException {
        this.walker = new FileTreeWalker(Arrays.asList(fileVisitOptionArray), n);
        this.next = this.walker.walk(path);
        assert (this.next.type() == FileTreeWalker.EventType.ENTRY || this.next.type() == FileTreeWalker.EventType.START_DIRECTORY);
        IOException iOException = this.next.ioeException();
        if (iOException != null) {
            throw iOException;
        }
    }

    private void fetchNextIfNeeded() {
        if (this.next == null) {
            FileTreeWalker.Event event = this.walker.next();
            while (event != null) {
                IOException iOException = event.ioeException();
                if (iOException != null) {
                    throw new UncheckedIOException(iOException);
                }
                if (event.type() != FileTreeWalker.EventType.END_DIRECTORY) {
                    this.next = event;
                    return;
                }
                event = this.walker.next();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        return this.next != null;
    }

    @Override
    public FileTreeWalker.Event next() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        FileTreeWalker.Event event = this.next;
        this.next = null;
        return event;
    }

    @Override
    public void close() {
        this.walker.close();
    }
}

