/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashMap;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

final class FileOwnerAttributeViewImpl
implements FileOwnerAttributeView,
DynamicFileAttributeView {
    private static final String OWNER_NAME = "owner";
    private final FileAttributeView view;
    private final boolean isPosixView;

    FileOwnerAttributeViewImpl(PosixFileAttributeView posixFileAttributeView) {
        this.view = posixFileAttributeView;
        this.isPosixView = true;
    }

    FileOwnerAttributeViewImpl(AclFileAttributeView aclFileAttributeView) {
        this.view = aclFileAttributeView;
        this.isPosixView = false;
    }

    @Override
    public String name() {
        return OWNER_NAME;
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        if (!string.equals(OWNER_NAME)) {
            throw new IllegalArgumentException("'" + this.name() + ":" + string + "' not recognized");
        }
        this.setOwner((UserPrincipal)object);
    }

    @Override
    public Map<String, Object> readAttributes(String[] stringArray) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : stringArray) {
            if (!string.equals("*") && !string.equals(OWNER_NAME)) {
                throw new IllegalArgumentException("'" + this.name() + ":" + string + "' not recognized");
            }
            hashMap.put(OWNER_NAME, this.getOwner());
        }
        return hashMap;
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        if (this.isPosixView) {
            return ((PosixFileAttributeView)this.view).readAttributes().owner();
        }
        return ((AclFileAttributeView)this.view).getOwner();
    }

    @Override
    public void setOwner(UserPrincipal userPrincipal) throws IOException {
        if (this.isPosixView) {
            ((PosixFileAttributeView)this.view).setOwner(userPrincipal);
        } else {
            ((AclFileAttributeView)this.view).setOwner(userPrincipal);
        }
    }
}

