/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MetalToolTipUI
extends BasicToolTipUI {
    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.tip = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        JToolTip jToolTip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getForeground());
        String string = jToolTip.getTipText();
        if (string == null) {
            string = "";
        }
        String string2 = this.getAcceleratorString(jToolTip);
        FontMetrics fontMetrics2 = SwingUtilities2.getFontMetrics(jComponent, graphics, this.smallFont);
        int n2 = this.calcAccelSpacing(jComponent, fontMetrics2, string2);
        Insets insets = jToolTip.getInsets();
        Rectangle rectangle = new Rectangle(insets.left + 3, insets.top, dimension.width - (insets.left + insets.right) - 6 - n2, dimension.height - (insets.top + insets.bottom));
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
            n = BasicHTML.getHTMLBaseline(view, rectangle.width, rectangle.height);
        } else {
            graphics.setFont(font);
            SwingUtilities2.drawString((JComponent)jToolTip, graphics, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            n = fontMetrics.getAscent();
        }
        if (!string2.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            SwingUtilities2.drawString((JComponent)jToolTip, graphics, string2, jToolTip.getWidth() - 1 - insets.right - n2 + 12 - 3, rectangle.y + n);
        }
    }

    private int calcAccelSpacing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return string.equals("") ? 0 : 12 + SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        String string = this.getAcceleratorString((JToolTip)jComponent);
        if (!string.equals("")) {
            dimension.width += this.calcAccelSpacing(jComponent, jComponent.getFontMetrics(this.smallFont), string);
        }
        return dimension;
    }

    protected boolean isAcceleratorHidden() {
        Boolean bl = (Boolean)UIManager.get("ToolTip.hideAccelerator");
        return bl != null && bl != false;
    }

    private String getAcceleratorString(JToolTip jToolTip) {
        this.tip = jToolTip;
        String string = this.getAcceleratorString();
        this.tip = null;
        return string;
    }

    public String getAcceleratorString() {
        String string;
        block3: {
            if (this.tip == null || this.isAcceleratorHidden()) {
                return "";
            }
            JComponent jComponent = this.tip.getComponent();
            if (!(jComponent instanceof AbstractButton)) {
                return "";
            }
            KeyStroke[] keyStrokeArray = jComponent.getInputMap(2).keys();
            if (keyStrokeArray == null) {
                return "";
            }
            string = "";
            int n = 0;
            if (n >= keyStrokeArray.length) break block3;
            int n2 = keyStrokeArray[n].getModifiers();
            string = KeyEvent.getKeyModifiersText(n2) + this.acceleratorDelimiter + KeyEvent.getKeyText(keyStrokeArray[n].getKeyCode());
        }
        return string;
    }
}

